<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
	<xsl:param name="codeLib" select="''"/>
	<xsl:param name="NonResident" select="''"/>
	<xsl:param name="titleUK" select="''"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 39 - Segementation et son explication</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE39/EJ39/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 39 - Segementation et son explication</caption>
					<xsl:call-template name="genLigneConfidentiel"/>
				  <xsl:apply-templates select="/FIBEN/ERREUR"/>
					<xsl:if test="not(/FIBEN/ERREUR)">
						<tr>
							<td class="clWidth64"></td>
							<td class="clWidth636 clCouleur2 clValignTop" colspan="3">
								<xsl:apply-templates select="FIBEN/PERSONNE/MODULE39/EJ39"/>
								<xsl:apply-templates select="//IST10" mode="genLib"/>   
								<xsl:apply-templates select="FIBEN/PERSONNE/MODULE39/DIFF39"/>
                <xsl:if test="not(//IST10)">
                  <xsl:call-template name="genFlecheHaut"/>
                </xsl:if>
							</td>
						</tr>

					</xsl:if>
				</table>
            <xsl:call-template name="genBasPage"/>
				</body>
		</html>
	</xsl:template>
  <xsl:template match="FIBEN/PERSONNE/MODULE39/EJ39">
		<xsl:call-template name="genEnTete">
			<xsl:with-param name="ident" select="IDENTS"/>
			<xsl:with-param name="nom" select="DENOM"/>
      <xsl:with-param name="segment" select="/FIBEN/PERSONNE/MODULE39/DIFF39/SEGMENTATION/SEGMENT"/>
      <xsl:with-param name="datseg" select="/FIBEN/PERSONNE/MODULE39/DIFF39/SEGMENTATION/DATSEG"/>
      <xsl:with-param name="datexa" select="/FIBEN/PERSONNE/MODULE39/DIFF39/SEGMENTATION/DATEXA"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="IST10" mode="genLib">
		<table class="clWidth635 clBorderCell" role="presentation">
			<tr>
				<td class="clWidth14"></td>
				<td class="clCouleur2 clValignTop">
					<xsl:apply-templates select="."/>
				</td>
			</tr>
			<tr>
				<td class="clWidth14"></td>
				<td>
					<xsl:call-template name="shim"/>
				</td>
			</tr>
		</table>
	</xsl:template>
  <xsl:template match="DIFF39">
     <table class="clWidth635 clBorderCell" role ="presentation">
       <caption class="visually-hidden">Message d'information sur la segmentation</caption>
      <tr>
        <xsl:if test="$Lang='FR'">
       <td class="clWidth612 clStyleDescriptif">
          <span>
            La segmentation des cotes X0, J0, K0, L0, M0 rsulte d'un traitement purement statistique reposant
            sur des donnes objectives (impays sur effets de commerce, endettement bancaire et donnes descriptives). Parmi celles-ci deux
            sont collectes exclusivement par la Banque de France : impays sur effets de commerce et endettement bancaire.
          </span>
        </td>
        </xsl:if> 
         <xsl:if test="$Lang='UK'">
       <td class="clWidth612 clStyleDescriptif">
          <span>
           The segmentation about cotation X0, K0, L0, M0 is resulted by a statistic processing from objective 
            data (outstanding payments on trade bill, banking indebtedness, descriptive data). Among these data, two are collected only by the 
            Bank of France : outstanding payments on trade bill and banking indebtedness).</span>
        </td>
        </xsl:if>  
      </tr>
    </table>
    <xsl:call-template name="shim"/>
     <table class="clWidth635 clBorderCell" role ="presentation">       
      <tr>
         <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clWidth597 clAlignCenter">
          <div class="clAlignCenter">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m37_Explititre'"/>
            </xsl:call-template>
           <br/>
          </div>
        </td>  
         <td class="clWidth19">&#160;</td>
      </tr>
    </table>
    
    <xsl:call-template name="shim"/>
    <xsl:apply-templates select="SEGDES"/>
    <xsl:apply-templates select="SEG01"/>
     <xsl:if test="$Lang='FR'">
    <table class="clWidth635 clBorderCell" role="presentation">      
        <tr>
        <td class="clWidthMax clHeight20" colspan="2">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10"></td>
        <td class="clWidth625 clStyleDescriptif">
          <span>
            La variable <strong> Impays </strong> correspond aux montants cumuls d'incidents de paiement
            effets de commerce (les contestations de crances CC sont exclues) sur une anne, dclars  la Centrale des Incidents de Paiement sur
            Effets.
          </span>
          <br/>
          <br/>
        </td>
      </tr>
      <tr>
        <td class="clWidth10"></td>
        <td class="clWidth625 clStyleDescriptif">
          <span>
            La variable <strong> Descriptive </strong> agrge 3 informations:&#160;<br/>
            &#160;&#160;- l'ge de l'entreprise <br/>
            &#160;&#160;- le secteur d'activit au niveau division NAF<br/>
            &#160;&#160;- la catgorie juridique<br/><br/>
          </span>
        </td>
      </tr>
      <tr>
        <td class="clWidth10"></td>
        <td class="clWidth625 clStyleDescriptif">
          <span>
            La variable <strong> Endettement Bancaire </strong> est labore  partir des
            dclarations de concours bancaires mensuels (crdits  court terme et crances commerciales) transmises  la Centrale des
            Risques.<br/><br/>
          </span>
        </td>
      </tr>
 </table>
</xsl:if>
     <xsl:if test="$Lang='UK'">
    <table class="clWidth635 clBorderCell" role="presentation">      
      <tr>
        <td class="clWidthMax clHeight20" colspan="2">&#160;</td>
      </tr>
      <tr>
        <td class="clWidth10"></td>
        <td class="clWidth625 clStyleDescriptif">
          <span>
            The variable <strong> Outstanding payments </strong> corresponds to the amount accumulated by the trade bill payment incidents (the contestation of 
            creances CC are ruled out) during a year, declared at the trade bill payment incidents Central department.
          </span>
          <br/>
          <br/>
        </td>
      </tr>
      <tr>
        <td class="clWidth10"></td>
        <td class="clWidth625 clStyleDescriptif">
          <span>
            The variable <strong> Descriptive </strong> incorporate 3 informations&#160;<br/>
            &#160;&#160;- the age of the firm <br/>
            &#160;&#160;- the sector of activity at level class NAF code (main French statistical classifications)<br/>
            &#160;&#160;- the legal categorie<br/><br/>
          </span>
        </td>
      </tr>
      <tr>
        <td class="clWidth10"></td>
        <td class="clWidth625 clStyleDescriptif">
          <span>
            The variable <strong> Banking indebtedness </strong> is worked out from monthly bank liabilities 
            declaration (short-term credit and trade creances) transmitted to Risk Central department<br/><br/>
          </span>
        </td>
      </tr>
 </table>
</xsl:if>
 <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="SEGDES">
     <a name="ancSEG"></a>
    <table class="clWidth635 clBorderCell" role="presentation" >
      <caption class="visually-hidden">Explication</caption>
      <tr>
        <td>
          <img src="{$root}Images/risque/danger.gif" width="18" height="18" border="0" alt="attention"/>
        </td>
        <xsl:if test="$Lang='FR'">
          <td class="clWidth612 clStyleDescriptif">
            <span>
              Plus le nombre de croix est important, plus la contribution pse ngativement sur le calcul de
              la segmentation.
            </span>
          </td>
        </xsl:if>
        <xsl:if test="$Lang='UK'">
          <td class="clWidth612 clStyleDescriptif">
            <span>
              More the number of cross is important, more the contribution carries weight negatively on the calculation of segmentation.
            </span>
          </td>
        </xsl:if>
      </tr>
    </table>
      <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <caption class="visually-hidden">IMPAYS</caption>
      <tr>
        <td class="clWidthMax clTexte" colspan="2"></td>
      </tr>
        <tr>
           <th class="clWidth175 clCouleurGras clAlignLeft">
             <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m39_IMP'"/>
            </xsl:call-template>
          </th>
          <td class="clWidth459 clGrasFond">
             <xsl:value-of select="//IMPAYES"/>
          </td>
        </tr>
      </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">DESCRIPTIF</caption>      
      <tr>
        
       <th class="clWidth175 clCouleurGras clAlignLeft" colspan="2">
          <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m39_DES'"/>
            </xsl:call-template>
        </th>
        <td class="clWidth459 clGrasFond">
           <xsl:value-of select="//DESCRIPT"/>
        </td>
      </tr>
      <tr>
       <td class="clWidth20">&#160;</td>
       <th class="clWidth155 clTexte clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m39_AGE'"/>
            </xsl:call-template>
        </th>
        <td class="clWidth459 clTexte">
          <xsl:value-of select="//DAGE"/>
        </td>
      </tr>
      <tr>
       <td class="clWidth20">&#160;</td>
       <th class="clWidth155 clTexte clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m39_SAC'"/>
            </xsl:call-template>
        </th>
        <td class="clWidth459 clTexte">
          <xsl:value-of select="//DNAF"/>
        </td>
      </tr>
      <tr>
       <td class="clWidth20">&#160;</td>
       <th class="clWidth155 clTexte clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m39_CJ'"/>
            </xsl:call-template>
        </th>
        <td class="clWidth459 clTexte">
           <xsl:value-of select="//DCATJUR"/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">ENDETTEMENT BANCAIRE</caption>
      <tr>
        <th class="clWidth175 clCouleurGras clAlignLeft">
          <xsl:call-template name="tradlib">
              <xsl:with-param name="codeLib" select="'m39_END'"/>
            </xsl:call-template>
        </th>
        <td class="clWidth459 clGrasFond">
           <xsl:value-of select="//BANC"/>
        </td>
      </tr>
    </table>
       <xsl:call-template name="shim"/>
 </xsl:template> 
  
  <xsl:template match="SEG01">
     <a name="ancSEG"></a>
     <table class="clWidth635 clBorderCell" role="presentation">      
      <tr>
        <td class="clWidth612 clFond"> &#160;
          <xsl:call-template name="traduction">
              <xsl:with-param name="code" select="'SEG01'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

</xsl:stylesheet>
