<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="Langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1" />
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="codeLib" select="''"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="titleUK" select="''"/>  

  <xsl:template match="/">   
    <html lang="fr">
      <title>Module 37 - Cotation et son explication</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULE37/*//IDENTC|/FIBEN/PERSONNE/MODULE37/*//IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>       
        <table class="mainmodule horizontal-auto clWidth739">
          <caption class="visually-hidden">Module 37 - Cotation et son explication</caption>
          <xsl:call-template name="genLigneConfidentiel"/>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">

            <tr>
               <td class="clWidth64"></td>
              <td class="clWidth636 clCouleurGras clValignTop" colspan="3">
                <xsl:call-template name="genEnTete">
                  <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE37/*//IDENTC|/FIBEN/PERSONNE/MODULE37/*//IDENTS"/>
                  <xsl:with-param name="nom">
                    <xsl:if test ="//EJ37/DENOM">
                      <xsl:value-of select ="//EJ37/DENOM"/>
                    </xsl:if>
                    <xsl:if test ="//IDENTITE/NOM">
                      <xsl:call-template name ="displayInLowerCaseXsl">
                        <xsl:with-param name ="InputStringNom" select ="(//IDENTITE/NOM)"/>
                        <xsl:with-param name ="InputStringPrenom" select ="(//IDENTITE/PRENOM)"/>
                      </xsl:call-template>
                    </xsl:if>
                  </xsl:with-param>
                  <xsl:with-param name="nomconj" select="//IDENTITE/NOMCONJ"/>
                  <xsl:with-param name="valcot" select="//COTATION/VALCOT | //VALCOT"/>
                  <xsl:with-param name="datcot" select="//COTATION/DATCOT"/>
                  <xsl:with-param name="datexa" select="//COTATION/DATEXA"/>
                  <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE37/PM37/EI37/IDRENV | /FIBEN/PERSONNE/MODULE37/PPEI37/IDRENV"/>
                </xsl:call-template>
                  <xsl:apply-templates select="//ACTBDF"/>                 
                  <xsl:apply-templates select="//COTATION/COTPREC"/>              
                <xsl:if test="//COTATION/COTPREC">
                  <xsl:call-template name="shim"/>
                </xsl:if>
                <xsl:apply-templates select="//COTATION/DATBILS"/>
                <xsl:apply-templates select="//COTATION/DATBILC"/>
                <xsl:if test="//COTATION/DATBILS or //COTATION/DATBILC">
                  <xsl:call-template name="shim"/>
                </xsl:if>
                <xsl:if test="//INFLUENCANTE">
                  <xsl:call-template name="Influencante"/>
                </xsl:if>
                <xsl:if test="//TETEDEGROUPE">
                  <xsl:call-template name="TeteGroupe">
                    <xsl:with-param name ="IdentInfluencante" select ="//INFLUENCANTE/EJ/IDENTS"/>
                    <xsl:with-param name ="IdentTeteGroupe" select ="//TETEDEGROUPE/EJ/IDENTS"/>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="//INFLUENCANTE or //TETEDEGROUPE">
                  <xsl:call-template name="shim"/>
                  <br />
                </xsl:if>
               
                <xsl:if test="not(//IEC01) and not(//IST37)">
                  <xsl:if test="//INDIG|//INDIS|//INDID|//INDIUP">

                    <div class="clAlignCenter">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m37_Caract'"/>
                      </xsl:call-template>
                      <br/>
                    </div>
                    <xsl:call-template name="shim"/>

                    <xsl:if test="//INDIG|//INDIS|//INDID">
                      <table class="clWidth635 clBorderCell" role="presentation">
                        <xsl:apply-templates select="//INDIG/*" mode="displayLib"/>
                        <xsl:apply-templates select="//INDIS/*" mode="displayLib"/>
                        <xsl:apply-templates select="//INDID/*" mode="displayLib"/>                          
                      </table>
                    </xsl:if>
                    <xsl:if test="//INDIUP">
                      <xsl:if test="$Lang = 'FR'"> 
                      <!-- affichage d'un infobulle-->                        
                        <table class="clTexte" title="Se distingue pour la Banque de France par 3 caractristiques: &#013;
                          - Fort potentiel de croissance &#013;
                          - Usage ou cration d'une &#013;
                            technologie nouvelle &#013;
                          - Besoin de financement souvent &#013;
                            assur par des leves de fonds &#013;Pour plus d'informations, consultez le site utilisateur FIBEN">
                          <td class="clWidth122"></td>
                          <td class="clWidth290">- Analyse tenant compte du modle de croissance des</td>
                          <td class="clWidth223 clSousLigner">start-up</td>
                        </table>
                      </xsl:if>
                      <xsl:if test="$Lang = 'UK'">
                        <!-- affichage d'un infobulle-->                       
                        <table class="clTexte" title="Identified by the Banque de France on the basis of 3 criteria: &#013;
                          - Strong growth potential &#013;
                          - Use or creation of new technology &#013;
                          - Financing needs often met through capital raising &#013;For more information, go to the FIBEN user site">
                          <td class="clWidth122"></td>
                          <td class="clWidth168">- Analysis taking account of the</td>
                          <td class="clWidth43 clSousLigner">start-up</td>
                          <td class="clWidth302">growth model</td>
                        </table>
                      </xsl:if>
                      
                    </xsl:if>

                    <xsl:call-template name="shim"/>
                  </xsl:if>
                  <xsl:if test="//COTECA">
                    <div class="clAlignCenter">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m37_CotAct'"/>
                      </xsl:call-template>
                      <br/>
                    </div>
                    <xsl:apply-templates select="//COTECA"/>
                  </xsl:if>
                  <xsl:if test="//COTECC">
                    <div class="clAlignCenter">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m37_CotCre'"/>
                      </xsl:call-template>
                      <br/>
                    </div>
                    <xsl:call-template name="coteDeCredit"/>
                    <xsl:call-template name="TableauBRIDGJES"/>
                    <xsl:if test ="//REPARTITIONSOCSECTEUR">
                      <xsl:call-template name="GrapheSocieteSecteur"/>
                    </xsl:if>                    
                  </xsl:if>                  
                  <xsl:if test="//MPP">                   
                    <div class="clAlignCenter">
                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="codeLib" select="'m37_Indica'"/>
                      </xsl:call-template>
                      <br/>
                    </div>
                    <xsl:call-template name="Indicateur"/>
                    <xsl:call-template name="TableauBRIDGJES"/>
                  </xsl:if>
                  <xsl:call-template name="shim"/>
                </xsl:if>
                
                <xsl:if test="//IEC01">
                  <table class="clWidth635 clBorderCell" role="presentation">
                    <tr>
                      <td class="clCouleur2 clAlignLeft">
                        <xsl:apply-templates select="//IEC01"/>
                      </td>
                    </tr>
                  </table>
                  <xsl:call-template name="shim"/>
                  <br />
                </xsl:if>  
                
                 <xsl:if test="//IST37">
                  <table class="clWidth635 clBorderCell" role="presentation">
                    <tr>
                      <td class="clCouleur2 clAlignLeft">
                        <xsl:apply-templates select="//IST37"/>
                      </td>
                    </tr>
                  </table>
                  <xsl:call-template name="shim"/>
                  <br />
                </xsl:if> 
              </td>
              <xsl:call-template name="genFlecheHaut"/>
            </tr>
            
            
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  
  
  </xsl:template> 

  <xsl:template match="ACTBDF">     
    <table class="clWidth635 clBorderCell" role="presentation">   
      <caption class="visually-hidden">Activit BDF</caption>
      <tr>       
         <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_ActBDF'"/>
          </xsl:call-template>
        </th>
        <td class="clTexte" colspan="3">
          &#160;<xsl:value-of select="//ACTBDF"/>&#160;&#160;
          <xsl:if test="$Lang = 'UK'">
            <xsl:call-template name="tradLibNaf">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codelib" select="//ACTBDF"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="$Lang = 'FR'">
            <xsl:value-of select="//LIBACT"/>
          </xsl:if>
        </td>
      </tr>
    </table>
   <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template name ="Influencante">
    <table class="clWidth635 clBorderCell" role="presentation">
      <caption class="visually-hidden">Entit influenante</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_EntInf'"/>
          </xsl:call-template>
        </th>
        <td class="clGrasFond clWidth80">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(//INFLUENCANTE/EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clWidth345 clAlignLeft">
          &#160;<xsl:value-of select="//INFLUENCANTE/EJ/DENOM"/>
        </td>
        <xsl:choose>
          <xsl:when test ="not($NonResident='NR')">
            <td class="clFond clAlignCenter clValignMiddle clWidth80 clHeight14 ">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|VB|','','1','{//INFLUENCANTE/EJ/IDENTS}',cstMultipleConfirm);">
                <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
              </a>
            </td>
          </xsl:when>
          <xsl:otherwise>
             <td class="clFond clWidth80">&#160;</td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name ="TeteGroupe">
    <xsl:param name ="IdentInfluencante"></xsl:param>
    <xsl:param name ="IdentTeteGroupe"></xsl:param>
    <table class="clWidth635 clBorderCell" role="presentation">
      <caption class="visually-hidden">Entit tte de groupe</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clHeight14 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="codeLib" select="'m37_TetGro'"/>
          </xsl:call-template>
        </th>
        <td class="clTexteGras clWidth80">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(//TETEDEGROUPE/EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clTexteGras clWidth345 clAlignLeft">
          &#160;<xsl:value-of select="//TETEDEGROUPE/EJ/DENOM"/>
        </td>
        <xsl:choose>
          <xsl:when test ="(not($NonResident='NR')) and ($IdentInfluencante != $IdentTeteGroupe)">
           <td class="clTexte clAlignCenter clValignMiddle clWidth80 clHeight14 ">
              <a href="#nullepart" onClick="requestBDFInfos('27|37|VB|','','1','{//TETEDEGROUPE/EJ/IDENTS}',cstMultipleConfirm);">
                <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
              </a>
            </td>
          </xsl:when>
          <xsl:otherwise>
             <td class="clTexte clWidth80">&#160;</td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="IS01|IS02|IS06|IS08|IS09|IS10|IG01|IG02|IG03|B5|BIL06|BIL07|BIL08|BIL09|UP01" mode="displayLib">
    <tr>
      <td class="clWidth130"></td>
      <td class="clTexte clWidth505">
        - <xsl:apply-templates select="."/>
      </td>
    </tr>
  </xsl:template>
  
  <!--Cote d'activit-->

  <xsl:template match="COTECA">
   <table class="clWidth635 clBorderCellpadding2" role="presentation">
     <caption class="visually-hidden">Cote d'activit</caption>
      <tr>
        <td class="clCouleur2 clWidth7 clBoxSizing">&#160;</td>
        <td class="clCouleur2 clWidth32 clAlignLeft clBoxSizing">
          &#160;<xsl:value-of select="substring(//COTATION/VALCOT,1,1)"/>&#160;:&#160;
        </td>
         <td class="clTexte clWidth421 clBoxSizing">
          &#160;<!--Il faut mettre seulement le 1er lment du noeud en cours <xsl:apply-templates select="./*[1]"/>  sinon nous avons la date dans le message -->
          <xsl:apply-templates select="./*[1]"/>
        </td>
        <th class="clCouleur2 clWidth75 clAlignRight clThNonGras clBoxSizing">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Attribuee'"/>
          </xsl:call-template>&#160;
        </th>
        <td class="clTexte clWidth100 clAlignLeft clBoxSizing">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="//DATCA"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <!--Cote de crdit-->

  <xsl:template name="coteDeCredit">
    <xsl:variable name ="ValeurJauge" select ="substring(//COTATION/VALCOT,2,3)"></xsl:variable>   
   <table class="clWidth635 clBorderCellpadding2" role="presentation">
     <caption class="visually-hidden">Cote de crdit</caption>
      <xsl:if test="//PM37">      
        <tr>
          <td class="clCouleur2 clWidth7 clBoxSizing">&#160;</td>
          <td class="clWidth32 clCouleur2 clAlignLeft clBoxSizing">
            &#160;<xsl:value-of select="substring(//COTATION/VALCOT,2,3)"/>&#160;:
          </td>
          <xsl:apply-templates select="//CC01|//MG1P|//MG1|//MG1M|//MG2P|//MG2|//MG2M|//MG3P|//MG3|//MG3M|//MG4P|//MG4|//MG4M|//MG5P|//MG5|//MG5M|//MG6P|//MG6|//MG6M|//MG7|//MG8|//MGP" mode="displayLib"/>
        </tr>
        <tr>
          <td class="clWidth7">&#160;</td>
          <td class="clWidth32">&#160;</td>
          <td class="clWidth421">&#160;</td>
          <th class="clCouleur2 clWidth75 clAlignRight clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m37_Attribuee'"/>
            </xsl:call-template>&#160;
          </th>
          <td class="clTexte clWidth100 clAlignLeft">
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(//DATCC)"/>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:if>
    </table>
      <table class="clWidth635 clBorderCell" role="presentation">
        <caption class="visually-hidden">Positionnement de l'entreprise sur l'chelle de cotation</caption>
          <tr class="clHeight5">
             <td class="clTexte clWidth40">&#160;</td>
              <td class="clTexte clWidth555">&#160;</td>
             <td class="clTexte clWidth40">&#160;</td>
          </tr>
          <tr>
             <td class="clTexte clWidth40"></td>
              <th class="clTexte clWidth555 clAlignCenter clThNonGras">
                  <xsl:call-template name="tradlib">
                      <xsl:with-param name="Lang" select="$Lang"/>
                      <xsl:with-param name="codeLib" select="'m37_Position'"/>
                  </xsl:call-template>
              </th>
             <td class="clTexte clWidth40"></td>
          </tr>
          <tr class="clHeight5">
             <td class="clTexte clWidth40">&#160;</td>
              <td class="clTexte clWidth555">&#160;</td>
             <td class="clTexte clWidth40">&#160;</td>
          </tr>
      </table>
    <table class="clWidth635 clBorderCell" role="presentation" longdesc="~/aide/DescriptionJaugeCotationTest.txt">
     <caption class="visually-hidden">Jauge cotation</caption>
      <tr>
        <td class="clWidth40"></td>
        <td class="clWidth555">
          <xsl:element name="img">
            <xsl:attribute name="src">
              M<xsl:value-of select="/FIBEN/@MODDEM"/>/Graphiques/graphe1.aspx?valcot=<xsl:value-of select="translate($ValeurJauge,'+','x')"/>
            </xsl:attribute>
          </xsl:element>
        </td>
        <td class="clWidth40"></td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template name="Indicateur">
   <table class="clWidth635 clBorderCellpadding2" role="presentation">  
     <caption class="visually-hidden">Indicateur</caption>
      <tr>
        <td class="clCouleur2 clWidth8">&#160;</td>
        <td class="clCouleur2 clWidth120 clAlignLeft">
          &#160;&#160;<xsl:value-of select="(//COTATION/VALCOT)"/>&#160;:&#160;
        </td>
        <xsl:apply-templates select="//CEX0|//CEX5|//CEX6" mode="displayLib"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template name="TableauBRIDGJES">    
    <table class="clWidth635 clBorderCell">      
      <xsl:choose>
        <xsl:when test ="//COTECC">
          <caption class="visually-hidden">EXPLICATION DE LA COTE DE CREDIT</caption>
          <tr>
           <th class="clCouleurGras clWidth635 clHeight14 clAlignCenter">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_ExpCotcre'"/>
              </xsl:call-template>
            </th>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <caption class="visually-hidden">EXPLICATION DE L'INDICATEUR</caption>
          <tr>
           <th class="clCouleurGras clWidth635 clHeight14 clAlignCenter">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Expindtitre'"/>
              </xsl:call-template>
            </th>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <tr>
        <td class="clCouleur2 clWidth635">&#160;</td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCellpadding2 clTableauExpli">
      <caption class="visually-hidden">EXPLICATION DE LA COTE DE CREDIT</caption>
      <tr>
       <th class="clCouleur2Border clWidth260 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Elementan'"/>
          </xsl:call-template>
        </th>
       <th class="clCouleur2Border clWidth260 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Observ'"/>
          </xsl:call-template>
        </th>
       <th class="clCouleur2Border clWidth115 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_ElementDet'"/>
          </xsl:call-template>
        </th>
      </tr>
      <xsl:variable name="ElemIDetermin" select ="//ELEMI/@DETERMIN"/>
      <xsl:variable name="ElemIValeur" select ="//ELEMI/@VALEUR"/>
      <xsl:variable name="ElemIMessage" select ="//ELEMI/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test ="$ElemIDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
                <xsl:if test ="($ElemIValeur = '1') or ($ElemIValeur = '3') or ($ElemIValeur ='5')">
                    <xsl:if test="not($NonResident='NR')">
                        <br></br>
                        <br></br>
                        <a href="#nullePart" onclick="requestBDFInfos('29','','2','',cstSimpleConfirm);" class="clCouleur2">
                            Pour plus de renseignement :&#160;
                            <u>
                                Module 29 (Incidents effets)
                            </u>
                        </a>
                    </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemIMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>

        </xsl:when>
        <xsl:when test ="$ElemIDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
                <xsl:if test ="($ElemIValeur = '1') or ($ElemIValeur = '3') or ($ElemIValeur ='5')">
                    <xsl:if test="not($NonResident='NR')">
                        <br></br>
                        <br></br>
                        <a href="#nullePart" onclick="requestBDFInfos('29','','2','',cstSimpleConfirm);" class="clCouleur2">
                            Pour plus de renseignement :&#160;
                            <u>
                                Module 29 (incidents effets)
                            </u>
                        </a>
                    </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemIMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
           <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemDDetermin" select ="//ELEMD/@DETERMIN"/>
      <xsl:variable name ="ElemDValeur" select ="//ELEMD/@VALEUR"/>
      <xsl:variable name="ElemDMessage" select ="//ELEMD/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test ="$ElemDDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
                <xsl:if test="$Lang = 'FR'">
                    <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
                    <xsl:if test="not($NonResident='NR')">
                        <xsl:if test ="$ElemDValeur = '1'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('51','','3','',cstSimpleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 51 (Dirigeants)
                                </u>
                            </a>
                        </xsl:if>
                        <xsl:if test ="$ElemDValeur = '2'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('56','','3','',cstSimpleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 56 (Fonctions de direction)
                                </u>
                            </a>
                        </xsl:if>
                        <xsl:if test ="$ElemDValeur = '3'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('51|56|','','3','',cstMultipleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 51 (Dirigeants) ou Module 56 (Fonctions de direction)
                                </u>
                            </a>
                        </xsl:if>
                    </xsl:if>
                </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemDMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>

        </xsl:when>
        <xsl:when test ="$ElemDDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
                <xsl:if test="$Lang = 'FR'">
                    <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
                    <xsl:if test="not($NonResident='NR')">
                        <xsl:if test ="$ElemDValeur = '1'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('51','','3','',cstSimpleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 51 (Dirigeants)
                                </u>
                            </a>
                        </xsl:if>
                        <xsl:if test ="$ElemDValeur = '2'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('56','','3','',cstSimpleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 56 (Fonctions de direction)
                                </u>
                            </a>
                        </xsl:if>
                        <xsl:if test ="$ElemDValeur = '3'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('51|56|','','3','',cstMultipleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 51 (Dirigeants) ou Module 56 (Fonctions de direction)
                                </u>
                            </a>
                        </xsl:if>
                    </xsl:if>
                </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemDMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
           <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemGDetermin" select ="//ELEMG/@DETERMIN"/>
      <xsl:variable name ="ElemGValeur" select ="//ELEMG/@VALEUR"/>
      <xsl:variable name="ElemGMessage" select ="//ELEMG/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test ="$ElemGDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemGMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>

        </xsl:when>
        <xsl:when test ="$ElemGDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemGMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
           <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemJDetermin" select ="//ELEMJ/@DETERMIN"/>
      <xsl:variable name ="ElemJValeur" select ="//ELEMJ/@VALEUR"/>
      <xsl:variable name="ElemJMessage" select ="//ELEMJ/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test ="$ElemJDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemJMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>

        </xsl:when>
        <xsl:when test ="$ElemJDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemJMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
           <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>    
      <xsl:variable name="ElemSDetermin" select ="//ELEMS/@DETERMIN"/>
      <xsl:variable name ="ElemSValeur" select ="//ELEMS/@VALEUR"/>
      <xsl:variable name="ElemSMessage" select ="//ELEMS/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test ="$ElemSDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
                <xsl:if test="$Lang = 'FR'">
                    <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
                    <xsl:if test="not($NonResident='NR')">
                        <xsl:if test ="$ElemSValeur = '1'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('45','','3','',cstSimpleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 45 (Jugements)
                                </u>
                            </a>

                        </xsl:if>
                    </xsl:if>
                </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemSMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>

        </xsl:when>
        <xsl:when test ="$ElemSDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
                <xsl:if test="$Lang = 'FR'">
                    <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
                    <xsl:if test="not($NonResident='NR')">
                        <xsl:if test ="$ElemSValeur = '1'">
                            <br></br>
                            <br></br>
                            <a href="#nullePart" onclick="requestBDFInfos('45','','3','',cstSimpleConfirm);" class="clCouleur2">
                                Pour plus de renseignement :&#160;
                                <u>
                                    Module 45 (Jugements)
                                </u>
                            </a>
                        </xsl:if>
                    </xsl:if>
                </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'" >
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemSMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
           <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <tr>
        <td class="clCouleur2 clWidth260 clAlignLeft">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_DateMaj'"/>
          </xsl:call-template>&#160;
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(//DESCRIPTEUR/DATEDESC)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth260">
          &#160;
        </td>
        <td class="clWidth115">
          &#160;
        </td>
      </tr>
    </table>

  </xsl:template>


  <xsl:template name="GrapheSocieteSecteur">
    <xsl:call-template name="shim"/>   

    <table class="clWidth635 clBorderCellpadding2" role="presentation">
      <caption class="visually-hidden">RPARTITION PAR COTE DE CRDIT DES SOCITS DU SECTEUR (hors cote d'activit X)</caption>
      <tr>
       <td class="clCouleurGras clWidth635 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="codeLib" select="'m37_RepCotSect'"/>
          </xsl:call-template>
          <br/>
        </td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth635 clAlignCenter">
      <xsl:call-template name="tradlib">
        <xsl:with-param name="codeLib" select="'m37_RepCotSectL2'"/>
      </xsl:call-template>
      </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth40"></td>
        <td class="clWidth555">
          <xsl:element name="img">
            <xsl:attribute name="src">
              <!--M<xsl:value-of select="/FIBEN/@MODDEM"/>/Graphiques/graphe2.aspx?date=<xsl:value-of select="FIBEN/@DATJOUR"/>&amp;v1=<xsl:value-of select ="//REPARTITIONSOCSECTEUR/NBCOT3PP"/>&amp;v2=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT3P"/>&amp;v3=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT3"/>&amp;v4=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT4P"/>&amp;v5=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT4"/>&amp;v6=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT5P"/>&amp;v7=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT5"/>&amp;v8=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT6"/>&amp;v9=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT7"/>&amp;v10=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT8"/>&amp;v11=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT9"/>&amp;v12=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOTP"/>&amp;ab1=Cotes 3XX&#160;&amp;ab2=Cotes 3X&#160;&amp;ab3=Cotes 3&#160;&amp;ab4=Cotes 4X&amp;ab5=Cotes 4&amp;ab6=Cotes 5X&amp;ab7=Cotes 5&amp;ab8=Cotes 6&amp;ab9=Cotes 7&amp;ab10=Cotes 8&amp;ab11=Cotes 9&amp;ab12=Cotes P&amp;actbdf=<xsl:value-of select ="//ACTBDF"/>&amp;libact=<xsl:value-of select ="//LIBACT"/>-->
              M<xsl:value-of select="/FIBEN/@MODDEM"/>/Graphiques/graphe2.aspx?date=<xsl:value-of select="FIBEN/@DATJOUR"/>&amp;v1=<xsl:value-of select ="//REPARTITIONSOCSECTEUR/NBCOT1P"/>&amp;v2=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT1"/>&amp;v3=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT1M"/>&amp;v4=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT2P"/>&amp;v5=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT2"/>&amp;v6=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT2M"/>&amp;v7=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT3P"/>&amp;v8=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT3"/>&amp;v9=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT3M"/>&amp;v10=<xsl:value-of select ="//REPARTITIONSOCSECTEUR/NBCOT4P"/>&amp;v11=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT4"/>&amp;v12=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT4M"/>&amp;v13=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT5P"/>&amp;v14=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT5"/>&amp;v15=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT5M"/>&amp;v16=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT6P"/>&amp;v17=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT6"/>&amp;v18=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT6M"/>&amp;v19=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT7"/>&amp;v20=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOT8"/>&amp;v21=<xsl:value-of select="//REPARTITIONSOCSECTEUR/NBCOTP"/>&amp;ab1=Cotes 1X&#160;&amp;ab2=Cotes 1&#160;&amp;ab3=Cotes 1-&#160;&amp;ab4=Cotes 2X&amp;ab5=Cotes 2&amp;ab6=Cotes 2-&amp;ab7=Cotes 3X&amp;ab8=Cotes 3&amp;ab9=Cotes 3-&amp;ab10=Cotes 4X&#160;&amp;ab11=Cotes 4&#160;&amp;ab12=Cotes 4-&amp;ab13=Cotes 5X&#160;&amp;ab14=Cotes 5&#160;&amp;ab15=Cotes 5-&amp;ab16=Cotes 6X&#160;&amp;ab17=Cotes 6&#160;&amp;ab18=Cotes 6-&amp;ab19=Cotes 7&amp;ab20=Cotes 8&amp;ab21=Cotes P&amp;actbdf=<xsl:value-of select ="//ACTBDF"/>&amp;libact=<xsl:value-of select ="//LIBACT"/>
          </xsl:attribute>
          </xsl:element>
        </td>
        <td class="clWidth40"></td>
      </tr>
    </table>    
  </xsl:template>

  <xsl:template match="CC01|MG1P|MG1|MG1M|MG2P|MG2|MG2M|MG3P|MG3|MG3M|MG4P|MG4|MG4M|MG5P|MG5|MG5M|MG6P|MG6|MG6M|MG7|MG8|MGP" mode="displayLib">

    <td colspan="3" class="clGrasFond clWidth598 clBoxSizing">

      <xsl:variable name="attribute" select="name(.)"/>
      <xsl:if test="$Lang = 'FR'">
        <xsl:value-of select="$dictionnaire/mot[@id=$attribute]"/>
      </xsl:if>
      <xsl:if test="$Lang = ''">
        <xsl:value-of select="$dictionnaire/mot[@id=$attribute]"/>
      </xsl:if>
      <xsl:if test="$Lang = 'UK'" >
        <xsl:value-of select="$dictionnaireUK/mot[@id=$attribute]"/>
      </xsl:if>
    </td>
  </xsl:template>

  <xsl:template match="CEX0|CEX5|CEX6" mode="displayLib">

    <td colspan="3" class="clGrasFond clWidth507">
      <xsl:variable name="attribute" select="name(.)"/>
      <xsl:if test="$Lang = 'FR'">
        <xsl:value-of select="$dictionnaire/mot[@id=$attribute]"/>
      </xsl:if>
      <xsl:if test="$Lang = ''">
        <xsl:value-of select="$dictionnaire/mot[@id=$attribute]"/>
      </xsl:if>
      <xsl:if test="$Lang = 'UK'" >
        <xsl:value-of select="$dictionnaireUK/mot[@id=$attribute]"/>
      </xsl:if>
    </td>
  </xsl:template>
 

</xsl:stylesheet>
