<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="'risque'"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="sIPEbrkPage" select="''"/>
  <xsl:variable name="condGraph1" select="boolean(/FIBEN/PERSONNE/MODULE31/DIFF31)"/>
  <xsl:template match="/">
    <html lang="fr">
      <title>Module 31 - Crances clients garanties</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE31/PM/EI/IDENTC | FIBEN/PERSONNE/MODULE31/PM/EI/IDENTS | FIBEN/PERSONNE/MODULE31/PM/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 31 - Crances clients garanties</caption>
          <xsl:call-template name="genLigneConfidentiel"/>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
              <td class="clWidth64"/>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE31/PM/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE31/PM/EI"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE31/ENGA1" mode="genDiv"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE31/DIFF31"/>
                <xsl:call-template name="shim"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE31/PM/EI/IDLIES"/>
                <br/>
              </td>
            </tr>
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
        <xsl:call-template name="genGraph31">
          <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE31/PM/EI/IDENTC | FIBEN/PERSONNE/MODULE31/PM/EI/IDENTS | FIBEN/PERSONNE/MODULE31/PM/EJ/IDENTS"/>
          <xsl:with-param name="nom" select="FIBEN/PERSONNE/MODULE31/PM/EI/IDENTITE/NOM | FIBEN/PERSONNE/MODULE31/PM/EJ/DENOM"/>
          <xsl:with-param name="prenom" select="FIBEN/PERSONNE/MODULE31/PM/EI/IDENTITE/PRENOM"/>
          <xsl:with-param name="nomconj" select="FIBEN/PERSONNE/MODULE31/PM/EI/IDENTITE/NOMCONJ"/>
        </xsl:call-template>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="FIBEN/PERSONNE/MODULE31/PM/EJ">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom" select="DENOM"/>
      <xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="FIBEN/PERSONNE/MODULE31/PM/EI">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS|IDENTC"/>
      <xsl:with-param name="idrenv" select="IDRENV"/>
      <xsl:with-param name="nom">
        <xsl:call-template name="displayInLowerCaseXsl">
          <xsl:with-param name="InputStringNom" select="(IDENTITE/NOM)"/>
          <xsl:with-param name="InputStringPrenom" select="(IDENTITE/PRENOM)"/>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="nomconj" select="IDENTITE/NOMCONJ"/>
      <xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="FIBEN/PERSONNE/MODULE31/DIFF31">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth415 clAlignLeft clThNonGras">
          DERNIERE CENTRALISATION AU
        </th>
        <td class="clFond clAlignCenter clWidth80">
          <xsl:call-template name="displayDateClot">
            <xsl:with-param name="InputDateClot" select="DATCENTR"/>
          </xsl:call-template>
        </td>
        <td class="clWidth140">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth415 clAlignLeft clThNonGras">
          MOYENNE DES ENCOURS GARANTIS SUR LES MOIS SIGNIFICATIFS&#160;(*)
        </th>
        <td class="clFond clAlignCenter clWidth80">
          <xsl:call-template name="displayFormatAfficheNombre">
            <xsl:with-param name="Inputnombre" select="MOYENCOU"/>
          </xsl:call-template>
        </td>
        <th class="clCouleur2 clWidth140 clAlignCenter clThNonGras">
          en milliers d'<img width="8" height="9" class="clCouleur2" src="{$root}Images/risque/euro_symb_bleu.gif" alt="symbole euro"/>
        </th>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <a name="situation"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clWidth597 clAlignCenter">
          SITUATION RSUME SUR LES 13 DERNIERS MOIS&#160;(montants exprims en milliers d'<img width="8" height="9" class="clCouleur2" src="{$root}Images/risque/euro_symb_bleu.gif" alt="symbole euro"/>)
        </td>
        <td class="clWidth19">
          <xsl:if test="$condGraph1 = 'true'">
            <a href="#nullePart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx';window.document.forms['FormGraphes'].submit();">
              <img src="{$root}Images/{$familyName}/diagramme_bleu.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique"/>
            </a>&#160;
          </xsl:if>
          <xsl:if test="$condGraph1 != 'true'">
            <img src="{$root}Images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique"/>&#160;
          </xsl:if>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Dtails des encours</caption>
      <tr>
        <td colspan="8" class="clHeight30">&#160;</td>
      </tr>
      <tr>
        <td class="clFond clWidth10"/>
        <th class="clGrasFond clAlignCenter clWidth102">
          Mois
        </th>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[1]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[2]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[3]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[4]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[5]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clWidth11"/>
      </tr>
      <tr class="clHeight25">
        <td class="clTexte clWidth10"/>
        <th class="clTexte clAlignCenter clWidth102 clThNonGras">
          <I>Montant(s)</I>
        </th>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[1]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[1]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[2]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[2]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[3]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[3]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[4]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[4]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[5]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[5]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clWidth11"/>
      </tr>
      <tr>
        <td colspan="8" class="clHeight15">&#160;</td>
      </tr>
      <tr>
        <td class="clFond clWidth10"/>
        <th class="clGrasFond clAlignCenter clWidth102">
          Mois
        </th>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[6]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[7]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[8]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[9]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[10]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clWidth11"/>
      </tr>
      <tr class="clHeight25">
        <td class="clTexte clWidth10"/>
        <th class="clTexte clAlignCenter clWidth102 clThNonGras">
          <I>Montant(s)</I>
        </th>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[6]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[6]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[7]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[7]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[8]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[8]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[9]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[9]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[10]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[10]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clWidth11"/>
      </tr>
      <tr>
        <td colspan="8" class="clHeight15">&#160;</td>
      </tr>
      <tr>
        <td class="clFond clWidth10"/>
        <th class="clGrasFond clAlignCenter clWidth102">
          Mois
        </th>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[11]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[12]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102">
          <xsl:call-template name="displayDateLettre">
            <xsl:with-param name="InputDate" select="(ENCOURS[13]/DATENCO)"/>
          </xsl:call-template>
        </td>
        <td class="clGrasFond clAlignCenter clWidth102"/>
        <td class="clGrasFond clAlignCenter clWidth102"/>
        <td class="clGrasFond clWidth11"/>
      </tr>
      <tr class="clHeight25">
        <td class="clTexte clWidth10"/>
        <th class="clTexte clAlignCenter clWidth102 clThNonGras">
          <I>Montant(s)</I>
        </th>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[11]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[11]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[12]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[12]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102">
          <xsl:choose>
            <xsl:when test="ENCOURS[13]/MONTENCO = '0'">
              &#160;
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="displayFormatAfficheNombre">
                <xsl:with-param name="Inputnombre" select="(ENCOURS[13]/MONTENCO)"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td class="clTexte clAlignCenter clWidth102"/>
        <td class="clTexte clAlignCenter clWidth102"/>
        <td class="clTexte clWidth11"/>
      </tr>
      <tr>
        <td colspan="8" class="clHeight30">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth40">&#160;</td>
        <td class="clItalic2 clAlignLeft clWidth555">
          (*) Moyenne calcule sur les seuls mois o un montant est dclar
        </td>
        <td class="clWidth40">&#160;</td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="ENGA1" mode="genDiv">
    <table class="clWidth635 clBorderCell">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="genGraph31">
    <xsl:param name="ident"/>
    <xsl:param name="nom"/>
    <xsl:param name="nomconj"/>
    <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
      <input name="familyNumber" type="hidden" value="1"/>
      <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
      <xsl:element name="input">
        <xsl:attribute name="name">GrapheData</xsl:attribute>
        <xsl:attribute name="type">hidden</xsl:attribute>
        <xsl:attribute name="value">
          &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name="displayDateForGraph2">
            <xsl:with-param name="InputDateForGraph" select="FIBEN/@DATJOUR"/>
          </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="$ident"/>&lt;/ident&gt;&lt;nom&gt;<xsl:value-of select="$nom"/>&lt;/nom&gt;&lt;nomconj&gt;<xsl:value-of select="$nomconj"/>&lt;/nomconj&gt;&lt;moyenne&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE31/DIFF31/MOYENCOU"/>&lt;/moyenne&gt;&lt;graphe&gt;&lt;serie&gt;<xsl:if test="FIBEN/PERSONNE/MODULE31/DIFF31">
            &lt;val&gt;<xsl:value-of select="//ENCOURS[1]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[2]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[3]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[4]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[5]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[6]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[7]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[8]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[9]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[10]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[11]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[12]/MONTENCO"/>&lt;/val&gt;
            &lt;val&gt;<xsl:value-of select="//ENCOURS[13]/MONTENCO"/>&lt;/val&gt;
            &lt;/serie&gt;&lt;abcisse&gt;&lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[1]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[2]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[3]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[4]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[5]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[6]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[7]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[8]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[9]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[10]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[11]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[12]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
            &lt;val&gt;<xsl:call-template name="displayDateClot">
              <xsl:with-param name="InputDateClot" select="(//ENCOURS[13]/DATENCO)"/>
            </xsl:call-template>&lt;/val&gt;
          </xsl:if>&lt;/abcisse&gt;&lt;titre&gt;Crdit court terme au cours des 13 dernires centralisations (en milliers d'euros)
          &lt;/titre&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
        </xsl:attribute>
      </xsl:element>
    </form>
  </xsl:template>
  <xsl:template match="text()"/>
</xsl:stylesheet>


