<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:variable name="condGraph1" select="(//CREDITCT[position()=1] != 0)"/>
  <xsl:variable name="condGraph2" select="(//CREDITMLT[position()=1] != 0)"/>
  <xsl:variable name="condGraph3" select="(//CREDITBM[position()=1] != 0) or (//CREDITBI[position()=1] != 0)" />
  <xsl:variable name="condGraph4" select="(//CREDITTOT6[position()=1] != 0)"/>
  <xsl:variable name="condGraph5" select="(//CREDITOC[position()=1] != 0) or (//CREDITOD[position()=1] != 0)"/>
  <xsl:variable name="condGraph6" select="(//CREDITAC[position()=1] != 0)"/>
  <xsl:variable name="condGraph" select="boolean($condGraph1 or $condGraph2 or $condGraph3 or $condGraph4 or $condGraph5 or $condGraph6)"/>
  <xsl:variable name="nbSurgroupes" select="count(//SURGROUPE)"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 30 - Sources de financement des groupes</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE30/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 30 - Sources de financement des groupes</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">

            <tr>
              <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE30/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE30/IST/ICB01|FIBEN/PERSONNE/MODULE30/IST/ICB02|FIBEN/PERSONNE/MODULE30/IST/IST02|FIBEN/PERSONNE/MODULE30/IST/IST03|FIBEN/PERSONNE/MODULE30/IST/IST04|FIBEN/PERSONNE/MODULE30/IST/IST10|FIBEN/PERSONNE/MODULE30/IST/IST12|FIBEN/PERSONNE/MODULE30/IST/IST13|FIBEN/PERSONNE/MODULE30/IST/IST14|FIBEN/PERSONNE/MODULE30/IST/IST15|FIBEN/PERSONNE/MODULE30/IST/IST20" mode="genLib"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE30/IST/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE30/DIFF30"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE30/DIFF30LF"/>
              </td>
            </tr>

          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>

        <xsl:call-template name="genGraph30"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE30/EJ">
    <xsl:call-template name="genEnTete30">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom" select="DENOM"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="ICB01|ICB02|IST02|IST03|IST04|IST10|IST12|IST13|IST14|IST15|IST20" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
          <br/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>


  <xsl:template match="DIFF30">

    <xsl:apply-templates select="NOMGROUP"/>

    <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30/SURGROUPE/EJ/IDENTS">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <th class="clCouleur2 clHeight12 clAlignLeft clThNonGras">&#160;Prsence de sur-groupe(s)</th>
        </tr>
      </table>
      <xsl:apply-templates select="SURGROUPE"/>
    </xsl:if>
    <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30/SOUSGROUPE/EJ/IDENTS">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <th class="clCouleur2 clHeight12 clAlignLeft clThNonGras">&#160;Prsence de sous-groupe(s)</th>
        </tr>
      </table>
      <xsl:apply-templates select="SOUSGROUPE"/>
    </xsl:if>

    <xsl:apply-templates select="PERIMETRE30"/>

    <!-- ****** gestion des concours bancaires DIFFUSI-308 -->

    <xsl:choose >
      <xsl:when test ="ICB01">
        <xsl:call-template name ="ICB01"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test ="ICB02">
            <xsl:call-template name="ICB02" />
          </xsl:when>
          <xsl:otherwise>
            <table class="clWidth739 clBorderCell" role="presentation">
              <tr class="clAlignCenter">
                <td class="clWidth636 clCouleurGras">SOURCES DE FINANCEMENT RECENSEES AU COURS DES TREIZE DERNIERS MOIS (EN MILLIERS D'EUROS)</td>
                <td class="clWidth103 clAlignRight"></td>
              </tr>
            </table>
            <xsl:call-template name="shim"/>

            <xsl:apply-templates select="@DATCENTR"/>

            <xsl:call-template name="CONCOURS" />
            <xsl:choose>
              <xsl:when test ="ICB06">
                <xsl:call-template name ="ICB06"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="CUMULCIFP" />
              </xsl:otherwise>
            </xsl:choose>

            <xsl:choose>
              <xsl:when test ="ICB07">
                <xsl:call-template name ="ICB07"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="CUMULCOA" />
              </xsl:otherwise>
            </xsl:choose>


            <xsl:apply-templates select="PERIMETRE30/ENTCONSO"/>

            <xsl:apply-templates select="PERIMETRE30/FILIALEIG1"/>

            <xsl:apply-templates select="PERIMETRE30/FILIALEIPME"/>

            <xsl:apply-templates select="PERIMETRE30/FILIALEIG2"/>
            <xsl:apply-templates select="EJ"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>


    <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>

  </xsl:template>

  <xsl:template match="DIFF30LF">

    <xsl:if test="ASSOCIEMAJORITAIRE/EJ/IDENTS">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <th colspan="2" class="clCouleur2 clValignTop clHeight12 clAlignLeft clThNonGras">Associ majoritaire</th>
        </tr>
        <tr>
          <td colspan="2" class="clHeight5"/>
        </tr>
        <tr>
          <td class="clFond clWidth130 clHeight12">

            <xsl:call-template name ="displaySirenXsl">
              <xsl:with-param name ="InputSiren" select ="ASSOCIEMAJORITAIRE/EJ/IDENTS"/>
            </xsl:call-template>
          </td>
          <td class="clFond clWidth505 clHeight12">
            <xsl:value-of select="ASSOCIEMAJORITAIRE/EJ/DENOM"/>
          </td>
        </tr>
        <tr>
          <td colspan="2" class="clAlignRight clValignMiddle clWidthMax clHeight14">
            <a href="#nullepart" onClick="requestBDFInfos('27|30|','','1','{ASSOCIEMAJORITAIRE/EJ/IDENTS}',cstMultipleConfirm);">
              <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </table>

      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>

    <xsl:apply-templates select="LIENSPARTICIPATION"/>

    <!-- ****** gestion des concours bancaires DIFFUSI-308 -->

    <xsl:choose >
      <xsl:when test ="ICB01">
        <xsl:call-template name ="ICB01"/>
      </xsl:when>
      <xsl:otherwise>

        <xsl:choose>
          <xsl:when test ="ICB02">
            <xsl:call-template name="ICB02" />
          </xsl:when>
          <xsl:otherwise>
            <table class="clWidth739 clBorderCell" role="presentation">
              <tr class="clAlignCenter">
                <td class="clWidth636 clCouleurGras">SOURCES DE FINANCEMENT RECENSEES AU COURS DES TREIZE DERNIERS MOIS (EN MILLIERS D'EUROS)</td>
                <td class="clWidth103 clAlignRight"></td>
              </tr>
            </table>
            <xsl:call-template name="shim"/>

            <xsl:apply-templates select="@DATCENTR"/>

            <xsl:call-template name="CONCOURS" />
            <xsl:choose>
              <xsl:when test ="ICB06">
                <xsl:call-template name ="ICB06"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="CUMULCIFP" />
              </xsl:otherwise>
            </xsl:choose>

            <xsl:choose>
              <xsl:when test ="ICB07">
                <xsl:call-template name ="ICB07"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="CUMULCOA" />
              </xsl:otherwise>
            </xsl:choose>

            <xsl:apply-templates select="LIENSPARTICIPATION/ENTCONSO"/>

            <xsl:apply-templates select="LIENSPARTICIPATION/PARTICIPSUP1"/>

            <xsl:apply-templates select="LIENSPARTICIPATION/PARTICIPINF"/>

            <xsl:apply-templates select="LIENSPARTICIPATION/PARTICIPSUP2"/>
            <xsl:apply-templates select="EJ"/>
            <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="NOMGROUP">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth130 clHeight12 clAlignLeft clThNonGras">&#160;Nom du groupe</th>
        <td class="clFond clWidth505 clHeight12">
          &#160;<xsl:value-of select="."/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="SURGROUPE|SOUSGROUPE">
    <table class="clWidth635 clBorderCell" role="presentation">

      <xsl:choose>
        <xsl:when test="name(.)='SURGROUPE'">
          <xsl:if test="(((position()-1) mod 20) = 0) and (position()!=1)">
            <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="((((position()-1)+$nbSurgroupes) mod 20) = 0) and (position()!=1)">
            <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>

      <tr>
        <td class="clFond clWidth130 clHeight12">
          &#160;<xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(./EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth505 clHeight12">
          &#160;<xsl:value-of select="EJ/DENOM"/>
        </td>
      </tr>
      <tr>
        <td colspan="2" class="clAlignRight clValignMiddle clWidthMax clHeight14">
          <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{EJ/IDENTS}',cstMultipleConfirm);">
            <img src="../images/Commun/clignotant2.gif" width="85" 	height="12" border="0" align="absbottom" alt="plus d'infos"/>
          </a>
        </td>
      </tr>
      <xsl:choose>
        <xsl:when test="name(.)='SURGROUPE'">
          <xsl:if test="(((position()-1) mod 20) = 0) and (position()!=1)">
            <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="((((position()-1)+$nbSurgroupes) mod 20) = 0) and (position()!=1)">
            <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>

    </table>
    <xsl:if test="position()=last()">
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="PERIMETRE30">
    <div class="clBreakPage" />
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth175 clHeight15 clAlignLeft clThNonGras">Primtre collect complet </th>
        <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:value-of select="@PERIMCPL"/>
        </td>
        <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">au</th>
        <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(@DATPERI)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth280 clHeight15" colspan="4"></td>
        <td class="clCouleur2"></td>
      </tr>
      <xsl:apply-templates select="NBFILIALES"/>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="LIENSPARTICIPATION">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clWidth540 clHeight15 clCouleur2 clAlignLeft clThNonGras">Nombre de participations</th>
        <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:value-of select="NBPARTICIPATION30/NBPARTICIPATIONTOTAL"/>
        </td>
        <td class="clWidth35 clHeight15 clCouleur2"></td>
      </tr>
      <tr>
        <th class="clCouleur2 clHeight15 clAlignLeft clThNonGras">Nombre de participations dtenues  plus de 50%</th>
        <td class="clFond clHeight15 clAlignRight">
          <xsl:value-of select="NBPARTICIPATION30/NBPARTICIPATIONSUP"/>
        </td>
        <td class="clCouleur2 clHeight15"></td>
      </tr>
      <tr>
        <th class="clCouleur2 clHeight15 clAlignLeft clThNonGras">Nombre de participations incluses dans le calcul des sources de financement cumules (1)</th>
        <td class="clFond clHeight15 clAlignRight">
          <xsl:value-of select="NBPARTICIPATION30/NBPARTICIPATIONSUPCB"/>
        </td>
        <td class="clCouleur2 clHeight15"></td>
      </tr>
      <tr>
        <td colspan="3" class="clHeight10"></td>
      </tr>
      <tr>
        <td colspan="3" class="clItalic clWidth635">(1) Seules les entits dtenues  plus de 50% sont incluses dans le calcul des sources de financement cumules sur les treize derniers mois</td>
      </tr>
    </table>

    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="NBFILIALES">
    <tr>
      <td colspan="5" class="clWidth455 clHeight15 clCouleur2"></td>
      <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IG</th>
      <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IP</th>
      <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">ME</th>
      <td class="clCouleur2"></td>
    </tr>
    <tr>
      <th colspan="2" class="clWidth235 clHeight15 clCouleur2 clAlignLeft clThNonGras">Nombre de filiales consolides</th>
      <td class="clFond clWidth60 clHeight15 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(NBFILTOT)"/>
        </xsl:call-template>
      </td>
      <td class="clWidth60 clHeight15"></td>
      <th class="clCouleur2 clWidth100 clHeight15 clThNonGras">rparties en (1)</th>
      <td class="clFond clWidth60 clHeight15 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(NBFILIG)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clWidth60 clHeight15 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(NBFILIP)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clWidth60 clHeight15 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(NBFILME)"/>
        </xsl:call-template>
      </td>
      <td class="clCouleur2"></td>
    </tr>
    <tr>
      <th colspan="5" class="clWidth455 clHeight15 clCouleur2 clAlignLeft clThNonGras">Nombre de filiales incluses dans le calcul des sources de financement cumules</th>
      <td class="clFond clWidth60 clHeight15 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(NBFILIG1)"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td colspan="7" class="clHeight10"></td>
    </tr>
    <tr>
      <td colspan="8" class="clItalic clWidth635">
        (1) Seules les entits en intgration globale sont incluses dans le calcul des sources de financement cumules sur les treize derniers mois
      </td>
    </tr>
    <tr>
      <td class="clItalic" colspan="7">&#160; </td>
    </tr>
    <tr>
      <td class="clItalic" colspan="7">IG : Filiale consolide selon la mthode de l'intgration globale</td>
    </tr>
    <tr>
      <td class="clItalic" colspan="7">IP : Filiale consolide selon la mthode de l'intgation proportionnelle</td>
    </tr>
    <tr>
      <td class="clItalic" colspan="7">ME : Filiale consolide selon la mthode de la mise en quivalence</td>
    </tr>
  </xsl:template>

  <xsl:template match="@DATCENTR">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth200 clHeight12 clThNonGras">&#160;DERNIRE CENTRALISATION AU</th>
        <td class="clFond clWidth200 clHeight12">
          <div class="clAlignRight">
            &#160;<xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(.)"/>
            </xsl:call-template>
          </div>
        </td>
        <td class="clCouleur2 clWidth235 clHeight12 clAlignCenter">
          <div class="clAlignRight">&#160;&#160;(en milliers d'euros)</div>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>



  <!--DTAILS DES CONCOURS BANCAIRES-->

  <xsl:template name ="ICB01">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2" >
          <xsl:value-of select="($dictionnaire/mot[@id='ICB01'])"></xsl:value-of>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name ="ICB02">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2" >
          <xsl:value-of select="($dictionnaire/mot[@id='ICB02'])"></xsl:value-of>
        </td>
        <td>
          <a href="#nullepart" onclick="requestBDFInfos('28','','{$familyNumber}','{.}',cstSimpleConfirm)" class="clCouleur2">
            <u>
              <xsl:value-of select="."/>
            </u>
          </a>
        </td>
      </tr>
      <tr>
        <td colspan="2">
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name ="ICB06">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2" >
          <xsl:value-of select="($dictionnaire/mot[@id='ICB06'])"></xsl:value-of>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name ="ICB07">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2"  >
          <xsl:value-of select="($dictionnaire/mot[@id='ICB07'])"></xsl:value-of>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="CONCOURS">

    <div class="clBreakPage"/>

    <table class="clWidth737 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          <a name="concours">DTAIL DES CONCOURS BANCAIRES</a>
        </td>
        <td class="clWidth102 clAlignRight">
          <xsl:call-template name="fleche_haut"/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Dtails des concours bancaires</caption>
      <tr>
        <xsl:apply-templates select="CONCOURS/@MOISREF"/>
        <xsl:apply-templates select="CONCOURS/CREDITCO"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="11"></td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Dtails des concours bancaires</caption>
      <tr>
        <xsl:apply-templates select="CONCOURS/@MOISREF"/>
        <xsl:apply-templates select="CONCOURS/CREDITMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <div class="clBreakPage"/>
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Dtails des concours bancaires</caption>
      <tr>
        <xsl:apply-templates select="CONCOURS/@MOISREF"/>
        <xsl:apply-templates select="CONCOURS/CREDITOC"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <div class="clBreakPage"/>
  </xsl:template>

  <xsl:template match="@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth45 clHeight20 clCouleur2"></td>
      </tr>
      <tr>
        <td class="clWidth45 clHeight25 clCouleur2"></td>
      </tr>
      <tr>
        <td class="clWidth45 clHeight45 clCouleur2"></td>
      </tr>
      <tr>
        <td class="clWidth45 clItalic clValignBottom clAlignCenter clHeight5"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clWidth45 clFond clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clWidth45 clTexte clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">

      <tr>
        <td class="clWidth45 clItalic clAlignRight clHeight15">&#160;</td>
      </tr>
      <tr>
        <th class="clWidth45 clFond clAlignRight clHeight15">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clWidth45 clItalic clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT COURT-->

  <xsl:template match="CREDITCO">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <a name="credit_ct"></a>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">
          <a name="credit_mobiliseInd"></a>CREDITS MOBILISES
        </th>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clWidth580 clAlignCenter clThNonGras" nowrap="true">
          Court terme
          <xsl:if test="$condGraph1">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </xsl:if>
          <xsl:if test="not($condGraph1)">
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="lien vers diagramme"/>
          </xsl:if>
        </th>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <th class="clCouleur2 clValignTop clHeight30 clWidth108 clAlignRight clThNonGras">
          Cptes ordinaires dbiteurs<br/>
          (CO)
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Crances commerciales<br/>
          (CC)
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Affacturage<br/>
          (AF)
        </th>
        <td class="clCouleur2 clWidth10">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Autres crdits  court terme<br/>
          (CA)
        </th>
        <td class="clWidth10 clCouleur2 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth108 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth114 clAlignRight"></td>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"></td>
        <td class="clWidth10 clItalic clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:apply-templates select="../CREDITCC"/>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:apply-templates select="../CREDITAF"/>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITCA)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:apply-templates select="../CREDITCC"/>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:apply-templates select="../CREDITAF"/>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignRight">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITCA)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td colspan="7" class="clItalic clWidth462"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108 clAlignRight"></td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITCO)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITAF)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITCA)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td colspan="10" class="clItalic clHeight1">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT MOYEN ET LONG TERME-->

  <xsl:template match="CREDITMLT">

    <xsl:if test="position()=1">

      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>

      <tr>
        <xsl:if test="($condGraph2)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_mlt"/>Moyen
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a><br/> et long terme<br/>
            (TE+TA)
            <br/>[II]
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph2)">
          <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            <a name="credit_mlt"/>Moyen
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/><br/> et long terme<br/>
            (TE+TA)
            <br/>[II]
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph3)">
          <th colspan="3" class="clCouleur2 clWidth226 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_b">
              Crdits-bails
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe3';window.document.forms['FormGraphes'].submit	();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph3)">
          <th colspan="3" class="clCouleur2 clWidth226 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_b">
              Crdits-bails
              <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </a>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth88 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_titr"/>Titriss<br/>
          (IT)
          <br/>[V]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph4)">
          <th rowspan="2" class="clCouleur2 clWidth128 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            Total <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe4';window.document.forms['FormGraphes'].submit();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a><br/>
            des crdits mobiliss [VI]<br/>[I]+[II]+[III]+[IV]+[V]
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph4)">
          <th rowspan="2" class="clCouleur2 clWidth128 clValignMiddle clAlignRight clThNonGras" nowrap="true">
            Total <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/><br/>
            des crdits mobiliss [VI]<br/>[I]+[II]+[III]+[IV]+[V]
          </th>
        </xsl:if>

        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Mobiliers
          (BM)
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth10 clAlignCenter">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          (BI)
          <br/>[IV]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td colspan="3" class="clItalic clWidth226">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth88"></td>
        <td class="clItalic clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth128"></td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>

    <xsl:if test="position() mod 2 != 0">
      <tr>

        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth88 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTIT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth128 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>

        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth88 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTIT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth128 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td colspan="3" class="clItalic clWidth226">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth88"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
      <tr>

        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt="" />
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth88 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITTIT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt="" />
        </td>
        <td class="clFond clWidth128 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td colspan="10" class="clItalic clHeight1">&#160;</td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- CREDIT MOBILISABLE -->

  <xsl:template match="CREDITOC">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <xsl:if test="($condGraph5)">
          <th colspan="5" class="clCouleur2 clHeight25 clWidth270 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_mobilisableInd">
              CREDITS MOBILISABLES
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe5';window.document.forms['FormGraphes'].submit	();">
                <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
              </a>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph5)">
          <th colspan="5" class="clCouleur2 clHeight25 clWidth270 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
            <a name="credit_mobilisableInd">
              CREDITS MOBILISABLES

              <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
            </a>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          crdits mobiliss <br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>
        <xsl:if test="($condGraph6)">
          <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            ENGAGEMENTS<br/>
            DE GARANTIE<br/>
            (AC)
            <br/>
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe6';window.document.forms['FormGraphes'].submit	();">
              <img border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </th>
        </xsl:if>
        <xsl:if test="not($condGraph6)">
          <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
            <a name="credit_eg"></a>
            ENGAGEMENTS<br/>
            DE GARANTIE<br/>
            (AC)
            <br/>
            <img border="0" src="{$root}Images/risque/diagramme_in.gif" width="19" height="20" alt="diagramme non disponible"/>
          </th>
        </xsl:if>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          TITRES&#160;<br/>
          DE CREANCES<br/>
          NEGOCIABLES<br/>
          (IE)
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth94 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crdits mobilisables<br/>
          (OC)
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth80 clAlignRight clValignMiddle clThNonGras">
          Crdits documentaires<br/>
          (OD)
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth76 clAlignRight clValignMiddle clThNonGras">Total crdits mobilisables [VII]</th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114 clAlignRight clBoxSizing"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth94 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth80 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITOD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth76 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITIE)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114 clHeight15"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="cltexte clWidth94 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10">&#160;</td>
        <td class="cltexte clWidth80 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITOD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth76 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth93 clAlignRight clHeight15">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../CREDITIE)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114 clHeight15"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth94 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth80 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth76 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93 clHeight15"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth93 clHeight15"></td>
        <td class="clItalic clWidth114 clHeight15"></td>
      </tr>
      <tr>
        <td class="clFond clWidth94 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITOC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth80 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITOD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth76 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight clHeight15">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYENNES/CREDITIE)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114 clHeight15"></td>
      </tr>
      <tr>
        <td colspan="12" class="clItalic clHeight1">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>


  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
  <!-- *****************Concours dclars par des intermdiaires en financement participatif *******************************************-->

  <xsl:template name="CUMULCIFP">
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS D&#201;CLAR&#201;S PAR</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">DES INTERMEDIAIRES EN FINANCEMENT PARTICIPATIF</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Dtails des concours dclars par des intermdiaires en financement participatif</caption>
      <tr>
        <xsl:apply-templates select="CUMULCIFP/@MOISREF"/>
        <xsl:apply-templates select="CUMULCIFP/MTCD"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="CUMULCIFP/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight5"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clAlignRight clWidth45 clHeigh15">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="CUMULCIFP/MTCD">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>

      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2b clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"></td>
      </tr>

      <tr class="clHeight25">
        <th class="clCouleur2b clValignTop clWidth110 clAlignRight clThNonGras">
          Dure &#60;=  1 an
        </th>
        <td class="clWidth4"></td>
        <td class="clCouleur2b clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth5"></td>
        <th class="clCouleur2b clValignTop clWidth100 clAlignRight clThNonGras">
          Dure &#62;  1 an
        </th>
        <td class="clCouleur2b clWidth7">&#160;</td>
        <td class="clCouleur2b clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="25" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2b clValignTop clWidth110 clAlignRight clThNonGras">
          Total
        </th>
        <td class="clWidth106 clAlignRight"></td>
      </tr>
      <tr class="clHeight5">
        <td class="clItalic" colspan="7"></td>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr class="clHeight15">
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTLD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr class="clHeight15">
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth5 clAlignRight">&#160;</td>
        <td class="clTexte clWidth100 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTLD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth7 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>


    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCIFP/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCIFP/MTLD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCIFP/MTTOT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
  <!-- **************Concours dclars par des socits de gestion de portefeuille et des entreprises d?assurance, mutuelles et institutions de prvoyance *******************************************-->

  <!-- ***************** Concours bancaires individuels *******************************************-->

  <!--DTAILS DES CREDITS-->

  <xsl:template name="CUMULCOA">
    <!-- titre du tableau -->
    <table class="clWidth739 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635"> D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Dtails des concours dclars par des societes de gestion de portefeuille et des entreprises d'assurance, mutuelles et institutions de prvoyance</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOA/MTCCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Dtails des concours dclars par des societes de gestion de portefeuille et des entreprises d'assurance, mutuelles et institutions de prvoyance</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOA/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Dtails des concours dclars par des societes de gestion de portefeuille et des entreprises d'assurance, mutuelles et institutions de prvoyance</caption>
      <tr>
        <xsl:apply-templates select="CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="CUMULCOA/MTCC"/>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>

  <xsl:template match="CUMULCOA/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"></td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"></td>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth65 clAlignRight clHeight15">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">

      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15">&#160;</td>
      </tr>
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>


  </xsl:template>

  <!--CREDIT COURT-->

  <xsl:template match="CUMULCOA/MTCCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>

      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>

        <th colspan="9" class="clCouleur2b clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"></td>
      </tr>
      <tr>

        <th colspan="9" class="clCouleur2b clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>

      <tr class="clHeight30">
        <td class="clCouleur2b clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth4"></td>
        <th class="clCouleur2b clValignTop clWidth110 clAlignRight clThNonGras">
          Crances<br/>commerciales<br/>(CC)
        </th>
        <td class="clWidth5"></td>
        <td class="clCouleur2b clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2b clWidth7">&#160;</td>
        <th class="clCouleur2b clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crdits<br/> court terme<br/>(CA)
        </th>
        <td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2b clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"></td>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"></td>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">&#160;</td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth110 clAlignRight">&#160;</td>
        <td class="clTexte clWidth4 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth5 clAlignRight">&#160;</td>
        <td class="clTexte clWidth100 clAlignRight">&#160;</td>
        <td class="clTexte clWidth7 clAlignRight">&#160;</td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth110 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>

      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--CREDIT MOYEN ET LONG TERME-->

  <xsl:template match="CUMULCOA/MTCMLT">

    <xsl:if test="position()=1">

      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10" colspan="9"></td>
        <td class="clWidth106"></td>
      </tr>
      <tr>
        <th class="clCouleur2b clWidth103 clValignMiddle clAlignRight clThNonGras" rowspan="2">
          Moyen
          <br/> et long terme<br/>(TE+TA)<br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th colspan="3" class="clCouleur2b clValignMiddle clAlignCenter clThNonGras" nowrap="true">Crdits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2b  clWidth74 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          (IT - Crdits<br/>Titriss+ CR<br/>- Crdits Repris)<br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2b clWidth158 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          des crdits mobiliss [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page" />
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2b clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers (BM)<br/>[III]
        </th>
        <td class="clCouleur2b clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2b clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers (BI)<br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"></td>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"></td>
        <td class="clItalic"></td>
        <td class="clItalic"></td>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"></td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"  width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth158"></td>
        <td class="clItalic clWidth104"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth103 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clAlignCenter clWidth10">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth104 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth5">&#160;</td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth74 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td ></td>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td ></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>

  </xsl:template>

  <!-- CREDIT MOBILISABLE -->

  <xsl:template match="CUMULCOA/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crdits mobiliss<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          (AC)
        </th>
        <td class="clWidth114 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crdits mobilisables<br/>
          (OC)
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crdits documentaires<br/>
          (OD)
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crdits mobilisables [VII]</th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>

    </xsl:if>
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10">&#160;</td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="cltexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="cltexte clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clTexte clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter"></td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"></td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>

  </xsl:template>

  <xsl:template match="ENTCONSO">
    <table class="clWidth635 clBorderCell" role=" presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          <a name="consolidante">
            <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30">SOCIT CONSOLIDANTE</xsl:if>
            <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30LF">ENTREPRISE INTERROGE</xsl:if>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td colspan="3" class="clHeight6"></td>
      </tr>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(./EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="./EJ/DENOM"/>
        </td>
        <td class="clFond clWidth169">
          <xsl:value-of select="./LOCALI"/>
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits bancaires mobiliss sur les treize derniers mois (Total [VI])</th>
        <td class="clfond clWidth75 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(./@CREDMOY)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">&#160;</td>
      </tr>
      <xsl:variable name="CrifpMoyEntiteConso" select ="(./@CRIFPMOY)"></xsl:variable>
      <xsl:if test ="$CrifpMoyEntiteConso">
        <tr>
          <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits IFP mobiliss sur les treize derniers mois</th>
          <td class="clfond clWidth75 clAlignRight">
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(./@CRIFPMOY)"/>
            </xsl:call-template>
          </td>
          <td class="clWidth90 clHeight14 clAlignRight" colspan="4">&#160;</td>
        </tr>
      </xsl:if>
      <tr>
        <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits OA/SGP mobiliss sur les treize derniers mois (Total [VI])</th>
        <td class="clfond clWidth75 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(./@CROAMOY)"/>
          </xsl:call-template>
        </td>
        <xsl:call-template name ="isFrenchLocali1">
          <xsl:with-param name ="Locali" select ="LOCALI"/>
        </xsl:call-template>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:if test="position() = last()">
      <div class="clBreakPage"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="FILIALEIG1">
    <xsl:if test="position()=1">
      <table class="clWidth737 clBorderCell" role="presentation">
        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <a name="IG">
              FILIALES EN INTGRATION GLOBALE (<xsl:value-of select="count(/FIBEN/PERSONNE/MODULE30/DIFF30/PERIMETRE30/FILIALEIG1)"/>)
            </a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>

    <table class="clWidth635 clBorderCell" role="presentation">
      <xsl:if test="((position()-1) mod 15 = 0) and (position()!=1)">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:if>
      <xsl:if test="not((position()-1) mod 15 = 0) and (position()!=1)">
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:if>
      <td colspan="3" class="clHeight6"></td>
      <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clFond clWidth249">
          <xsl:value-of select="LOCALI"/>
        </td>
      </tr>
    </table>

    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits bancaires mobiliss sur les treize derniers mois (Total [VI])</th>
        <td class="clfond clWidth75 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(@CREDMOY)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">&#160;</td>
      </tr>

      <xsl:variable name="CrifpMoyFilialeInteGlobal" select ="(@CRIFPMOY)"></xsl:variable>
      <xsl:if test ="$CrifpMoyFilialeInteGlobal">
        <tr>
          <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits IFP mobiliss sur les treize derniers mois</th>
          <td class="clfond clWidth75 clAlignRight">
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(@CRIFPMOY)"/>
            </xsl:call-template>
          </td>
          <td class="clWidth90 clHeight14 clAlignRight" colspan="4">&#160;</td>
        </tr>
      </xsl:if>
      <tr>
        <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits OA/SGP mobiliss sur les treize derniers mois (Total [VI])</th>
        <td class="clfond clWidth75 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(@CROAMOY)"/>
          </xsl:call-template>
        </td>
        <xsl:call-template name ="isFrenchLocali2">
          <xsl:with-param name ="Locali" select ="LOCALI"/>
        </xsl:call-template>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>


  </xsl:template>

  <xsl:template match="FILIALEIPME">
    <xsl:if test="position()=1">
      <div class="clBreakPage" />

      <table class="clWidth737 clBorderCell" role="presentation">

        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <a name="autres_filiales">
              FILIALES N'ENTRANT PAS DANS LE CALCUL DES SOURCES DE FINANCEMENT DU GROUPE (<xsl:value-of select="count(/FIBEN/PERSONNE/MODULE30/DIFF30/PERIMETRE30/FILIALEIPME)"/>)
            </a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>

      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <table class="clWidth737 clBorderCell" role="presentation">
      <xsl:if test="((position()-1) mod 15 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:if>
      <xsl:if test="not((position()-1) mod 15 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:if>
      <td colspan="5" class="clHeight6"></td>
      <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clFond clWidth241">
          <xsl:value-of select="LOCALI"/>
        </td>
        <td class="clFond clWidth45 clAlignRight">
          <xsl:value-of select="@MODCONSO"/>
        </td>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>

    </table>
    <xsl:call-template name ="isFrenchLocali3">
      <xsl:with-param name ="Locali" select ="LOCALI"/>
    </xsl:call-template>


    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>

  <xsl:template match="FILIALEIG2">
    <xsl:if test="position()=1">
      <div class="clBreakPage" />

      <table class="clWidth737 clBorderCell" role="presentation">

        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <a name="sans_concours">
              FILIALES EN INTEGRATION GLOBALE SANS SOURCES DE FINANCEMENT (<xsl:value-of select="count(/FIBEN/PERSONNE/MODULE30/DIFF30/PERIMETRE30/FILIALEIG2)"/>)
            </a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>

      </table>
      <!-- <xsl:call-template name="shim"/><br/>-->
    </xsl:if>
    <table class="clWidth737 clBorderCell" role="presentation">
      <xsl:if test="((position()-1) mod 20 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:if>
      <xsl:if test="not((position()-1) mod 20 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:if>
      <td colspan="4" class="clHeight6"></td>
      <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clFond clWidth249">
          <xsl:value-of select="LOCALI"/>
        </td>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>
      <xsl:call-template name="shim"/>
      <br/>

    </table>
    <xsl:if test="position()=last()">
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="PARTICIPSUP1">
    <xsl:if test="position()=1">
      <table class="clWidth737 clBorderCell" role="presentation">
        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <a name="SUP1">
              PARTICIPATIONS DETENUES &#192; PLUS DE 50% AYANT DES SOURCES DE FINANCEMENT (<xsl:value-of select="count(/FIBEN/PERSONNE/MODULE30/DIFF30LF/LIENSPARTICIPATION/PARTICIPSUP1)"/>)
            </a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>

    <table class="clWidth635 clBorderCell" role="presentation">

      <xsl:if test="((position() mod 15) = 0) and (position()!=1)">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>

      </xsl:if>
      <xsl:if test="not((position() mod 15) = 0) and (position()!=1)">
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:if>
      <td colspan="3" class="clHeight6"></td>
      <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clFond clWidth249">
          <xsl:value-of select="LOCALI"/>
        </td>
      </tr>
    </table>


    <table class="clWidth737 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits bancaires mobiliss sur les treize derniers mois (Total [VI])</th>
        <td class="clfond clWidth75 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(./@CREDMOY)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">&#160;</td>
        <td class="clWidth102 clHeight14 clAlignRight" colspan="4">&#160;</td>
      </tr>
      <xsl:variable name="CrifpMoyFilialePartic" select ="(@CRIFPMOY)"></xsl:variable>
      <xsl:if test ="$CrifpMoyFilialePartic">
        <tr>
          <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits IFP sur les treize derniers mois</th>
          <td class="clfond clWidth75 clAlignRight">
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(./@CRIFPMOY)"/>
            </xsl:call-template>
          </td>
          <td class="clWidth90 clHeight14 clAlignRight" colspan="4">&#160;</td>
          <td class="clWidth102 clHeight14 clAlignRight" colspan="4">&#160;</td>
        </tr>
      </xsl:if>
      <tr>
        <th class="clCouleur2 clWidth470 clAlignLeft clThNonGras">Moyenne des crdits OA/SGP sur les treize derniers mois (Total [VI])</th>
        <td class="clfond clWidth75 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(./@CROAMOY)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>


  <xsl:template match="PARTICIPINF">
    <xsl:if test="position()=1">
      <div class="clBreakPage" />

      <table class="clWidth737 clBorderCell" role="presentation">

        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <a name="INF">
              PARTICIPATIONS DETENUES &#192; MOINS DE 50% (<xsl:value-of select="count(/FIBEN/PERSONNE/MODULE30/DIFF30LF/LIENSPARTICIPATION/PARTICIPINF)"/>)
            </a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>

      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <table class="clWidth737 clBorderCell" role="presentation">
      <xsl:if test="((position()-1) mod 15 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:if>
      <xsl:if test="not((position()-1) mod 15 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:if>
      <td colspan="5" class="clHeight6"></td>
      <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clFond clWidth241">
          <xsl:value-of select="LOCALI"/>
        </td>
        <td class="clFond clWidth45 clAlignRight"></td>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>

    </table>
    <xsl:call-template name ="isFrenchLocali3">
      <xsl:with-param name ="Locali" select ="LOCALI"/>
    </xsl:call-template>

    <xsl:call-template name="shim"/>
    <br/>

  </xsl:template>

  <xsl:template match="PARTICIPSUP2">
    <xsl:if test="position()=1">
      <div class="clBreakPage" />

      <table class="clWidth737 clBorderCell" role="presentation">

        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <a name="SUP2">
              PARTICIPATIONS DETENUES &#192; PLUS DE 50% SANS SOURCES DE FINANCEMENT (<xsl:value-of select="count(/FIBEN/PERSONNE/MODULE30/DIFF30LF/LIENSPARTICIPATION/PARTICIPSUP2)"/>)
            </a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>

      </table>
      <!-- <xsl:call-template name="shim"/><br/>-->
    </xsl:if>
    <table class="clWidth737 clBorderCell" role="presentation">
      <xsl:if test="((position()-1) mod 20 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:if>
      <xsl:if test="not((position()-1) mod 20 = 0) and (position() !=1) ">
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:if>
      <td colspan="4" class="clHeight6"></td>
      <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
      <tr>
        <td class="clFond clWidth139">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(EJ/IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth247">
          <xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clFond clWidth249">
          <xsl:value-of select="LOCALI"/>
        </td>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>
      <xsl:call-template name="shim"/>
      <br/>

    </table>
    <xsl:if test="position()=last()">
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE30/IST/EJ">
    <xsl:if test="position()=1">
      <table class="clWidth737 clBorderCell" role="presentation">
        <tr class="clBreakPage clAlignCenter">
          <td class="clCouleurGras">
            <a name="consolidant">SOCIT(S) CONSOLIDANT L'ENTREPRISE</a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <table class="clWidth737 clBorderCell" role="presentation">

      <tr>
        <td class="clFond clWidth130 clHeight14">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth425 clHeight14">
          <xsl:value-of select="DENOM"/>
        </td>
        <th class="clFond clWidth80 clThNonGras">
          au <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(@DATPERI)"/>
          </xsl:call-template>
        </th>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td colspan="3" class="clWidth635 clValignMiddle clAlignRight">
          <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
            <img src="../images/Commun/clignotant2.gif" width="85" 	height="12" border="0" align="absbottom" alt="plus d'infos"/>
          </a>
        </td>
        <td class="clWidth102">&#160;</td>
      </tr>
    </table>
    <xsl:if test="position()=last()">
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="EJ">
    <xsl:if test="position()=1">
      <table class="clWidth737 clBorderCell" role="presentation">
        <tr class="clBreakPage clAlignCenter">
          <td class="clCouleurGras">
            <a name="consolidant">SOCIT(S) CONSOLIDANT L'ENTREPRISE</a>
          </td>
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <table class="clWidth737 clBorderCell" role="presentation">

      <tr>
        <td class="clFond clWidth130 clHeight14">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(IDENTS)"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth425 clHeight14">
          <xsl:value-of select="DENOM"/>
        </td>
        <th class="clFond clWidth80 clThNonGras">
          au <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(@DATPERI)"/>
          </xsl:call-template>
        </th>
        <xsl:if test="position() mod 10 != 0">
          <td class="clWidth102">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 10 = 0">
          <td class="clWidth102 clAlignRight">
            <xsl:call-template name="fleche_haut"/>
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td colspan="3" class="clWidth635 clValignMiddle clAlignRight">
          <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
            <img src="../images/Commun/clignotant2.gif" width="85" 	height="12" border="0" align="absbottom" />
          </a>
        </td>
        <td class="clWidth102">&#160;</td>
      </tr>
    </table>
    <xsl:if test="position()=last()">
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
  </xsl:template>

  <!-- IsFrenchLocali1-->
  <xsl:template name ="isFrenchLocali1">
    <xsl:param name ='Locali'/>
    <xsl:variable name ='CodeLocali' select ='(substring ($Locali,1,2))'/>
    <xsl:choose>
      <xsl:when test ="string-length($CodeLocali)= 0">
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28|66|67|','','5','{EJ/IDENTS}',cstMultipleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </xsl:when>
      <xsl:when test ="(number($CodeLocali)&gt; 1 ) and (number($CodeLocali)&lt; 98)">
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28|66|67|','','5','{EJ/IDENTS}',cstMultipleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </xsl:when>
      <xsl:when test ="($CodeLocali='MC') or (CodeLocali='2A') or (CodeLocali='2B')">
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28|66|67|','','5','{EJ/IDENTS}',cstMultipleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td class="clWidth90 clHeight14" colspan="4">&#160;</td>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--isFrenchLocali2-->
  <xsl:template name ="isFrenchLocali2">
    <xsl:param name ='Locali'/>
    <xsl:variable name ='CodeLocali' select ='(substring ($Locali,1,2))'/>
    <xsl:choose>
      <xsl:when test ="string-length($CodeLocali)= 0">
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </xsl:when>
      <xsl:when test ="(number($CodeLocali)&gt; 1 ) and (number($CodeLocali)&lt; 98)">
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </xsl:when>
      <xsl:when test ="($CodeLocali='MC') or (CodeLocali='2A') or (CodeLocali='2B')">
        <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
          <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td class="clWidth90 clHeight14" colspan="4">&#160;</td>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--isFrenchLocali3-->
  <xsl:template name ="isFrenchLocali3">
    <xsl:param name ='Locali'/>
    <xsl:variable name ='CodeLocali' select ='(substring ($Locali,1,2))'/>
    <xsl:choose>
      <xsl:when test ="string-length($CodeLocali)= 0">
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="clCouleur2 clWidth535"></td>
            <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
              <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr>
        </table>
      </xsl:when>
      <xsl:when test ="(number($CodeLocali)&gt; 1 ) and (number($CodeLocali)&lt; 98)">
        <table class="clWidth635 clBorderCell">
          <tr>
            <td class="clCouleur2 clWidth535"></td>
            <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
              <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr>
        </table>
      </xsl:when>
      <xsl:when test ="($CodeLocali='MC') or (CodeLocali='2A') or (CodeLocali='2B')">
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="clCouleur2 clWidth535"></td>
            <td class="clWidth90 clHeight14 clAlignRight" colspan="4">
              <a href="#nullepart" onClick="requestBDFInfos('28','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
              </a>
            </td>
          </tr>
        </table>
      </xsl:when>
      <xsl:otherwise>

      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="genEnTete30">
    <xsl:param name="ident"/>
    <xsl:param name="nom"/>
    <xsl:param name="nomconj"/>
    <xsl:param name="valcot"/>
    <xsl:param name="datcot"/>
    <xsl:param name="datexa"/>
    <xsl:param name="idrenv"/>

    <xsl:call-template name="genTitreModule30"/>
    <xsl:call-template name="genIdentification">
      <xsl:with-param name="ident" select="$ident"/>
      <xsl:with-param name="nom" select="$nom"/>
      <xsl:with-param name="nomconj" select="$nomconj"/>
      <xsl:with-param name="valcot" select="$valcot"/>
      <xsl:with-param name="datcot" select="$datcot"/>
      <xsl:with-param name="datexa" select="$datexa"/>
      <xsl:with-param name="idrenv" select="$idrenv"/>
    </xsl:call-template>
    <xsl:apply-templates select="/FIBEN/PERSONNE/IDNOUV"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/ENTMORT"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/LEI"/>
    <xsl:apply-templates select="/FIBEN/PERSONNE/LIEU"/>
    <xsl:apply-templates select="/FIBEN/RALPH/DEMANDE"/>

  </xsl:template>

  <xsl:template name="genTitreModule30">
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur1 clValignTop clAlignLeft clWidth617">

          <xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>
          <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30">
            (Analyse sur groupe consolid)
          </xsl:if>
          <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30LF">
            (Analyse sur liens de participation)
          </xsl:if>
          <xsl:if test="/FIBEN/@GRAPHE">
            - Graphique(s)<br />
            <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30">
              (Analyse sur groupe consolid)
            </xsl:if>
            <xsl:if test="/FIBEN/PERSONNE/MODULE30/DIFF30LF">
              (Analyse sur liens de participation)
            </xsl:if>
          </xsl:if>
        </td>
        <td class="clValignMiddle clAlignCenter clWidth18">
          <span id="imgNumMod">
            <xsl:value-of select="$moddem"/>
          </span>
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>

  <xsl:template name="genGraph30">
    <xsl:if test="$condGraph">
      <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
        <input name="familyNumber" type="hidden" value="1"/>
        <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
        <xsl:element name="input">
          <xsl:attribute name="name">GrapheData</xsl:attribute>
          <xsl:attribute name="type">hidden</xsl:attribute>
          <xsl:attribute name="value">
            &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
              <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
            </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE30/EJ/IDENTS"/>&lt;/ident&gt;
            <xsl:if test="FIBEN/PERSONNE/MODULE30/EJ">
              &lt;nom&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE30/EJ/DENOM"/>&lt;/nom&gt;
            </xsl:if>
            <xsl:if test="FIBEN/PERSONNE/MODULE30/DIFF30">&lt;typeM30&gt;DIFF30&lt;/typeM30&gt;</xsl:if>
            <xsl:if test="FIBEN/PERSONNE/MODULE30/DIFF30LF">&lt;typeM30&gt;DIFF30LF&lt;/typeM30&gt;</xsl:if>

            &lt;graphe&gt;
            <xsl:if test="$condGraph1">
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITCO"/>&lt;/val&gt;
              </xsl:for-each>
              &lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITCC"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITAF"/>&lt;/val&gt;
              </xsl:for-each>
              &lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITCA"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS/@MOISREF">
                &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(.)"/>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/abcisse&gt;
            </xsl:if>
            &lt;titre&gt;Crdits  court terme&lt;/titre&gt;&lt;signet&gt;Court terme&lt;/signet&gt;&lt;/graphe&gt;

            &lt;graphe&gt;
            <xsl:if test="$condGraph2">
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITMLT"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS/@MOISREF">
                &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(.)"/>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/abcisse&gt;
            </xsl:if>
            &lt;titre&gt;Crdits  moyen et long terme&lt;/titre&gt;&lt;signet&gt;Moyen et long terme&lt;/signet&gt;&lt;/graphe&gt;

            &lt;graphe&gt;
            <xsl:if test="$condGraph3">
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITBI"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITBM"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS/@MOISREF">
                &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(.)"/>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/abcisse&gt;
            </xsl:if>
            &lt;titre&gt;Crdits-bails&lt;/titre&gt;&lt;signet&gt;Crdits-bails&lt;/signet&gt;&lt;/graphe&gt;

            &lt;graphe&gt;
            <xsl:if test="$condGraph4">

              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITCT"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITMLT"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:call-template name="doubleFlux">
                  <xsl:with-param name = "fCREDITBM" >
                    <xsl:value-of select="CREDITBM"/>
                  </xsl:with-param>
                  <xsl:with-param name = "fCREDITBI" >
                    <xsl:value-of select="CREDITBI"/>
                  </xsl:with-param>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITTIT"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS/@MOISREF">
                &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(.)"/>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/abcisse&gt;
            </xsl:if>
            &lt;titre&gt;Crdits mobiliss(Total VI)&lt;/titre&gt;&lt;signet&gt;Total VI&lt;/signet&gt;&lt;/graphe&gt;

            &lt;graphe&gt;
            <xsl:if test="$condGraph5">
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITOC"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITOD"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS/@MOISREF">
                &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(.)"/>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/abcisse&gt;
            </xsl:if>
            &lt;titre&gt;Crdits mobilisables(Total VII)&lt;/titre&gt;&lt;signet&gt;Crdits mobilisables&lt;/signet&gt;&lt;/graphe&gt;

            &lt;graphe&gt;
            <xsl:if test="$condGraph6">
              &lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS">
                &lt;val&gt;<xsl:value-of select="CREDITAC"/>&lt;/val&gt;
              </xsl:for-each>&lt;/serie&gt;
              &lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE30/*/CONCOURS/@MOISREF">
                &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                  <xsl:with-param name ="InputDate" select ="(.)"/>
                </xsl:call-template>&lt;/val&gt;
              </xsl:for-each>&lt;/abcisse&gt;
            </xsl:if>
            &lt;titre&gt;Engagements de garantie&lt;/titre&gt;&lt;signet&gt;Engagements de garantie&lt;/signet&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
          </xsl:attribute>
        </xsl:element>
      </form>
    </xsl:if>
  </xsl:template>

  <xsl:template name="doubleFlux">
    <xsl:param name = "fCREDITBM" />
    <xsl:param name = "fCREDITBI" />
    <xsl:value-of select = "$fCREDITBM+$fCREDITBI" />
  </xsl:template>
  <xsl:template match="CREDITCC">
    <xsl:if test="@ETAT">
      <xsl:value-of select="@ETAT"/>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(../CREDITCC)"/>
      </xsl:call-template>
    </xsl:if>

  </xsl:template>
  <xsl:template match="CREDITAF">
    <xsl:if test="@ETAT">
      <xsl:value-of select="@ETAT"/>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <xsl:call-template name ="displayNumberXsl">
        <xsl:with-param name ="InputStringNumber" select ="(../CREDITAF)"/>
      </xsl:call-template>
    </xsl:if>

  </xsl:template>
</xsl:stylesheet>
