<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="sIPEbrkPage" select="''"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:variable name="condGraph1" select="((count(/FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM/MTMIPE[text()!='0'])) >= '6') and ((count(/FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM/MTMIPE[text()!='0,0'])) >= '6') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[1]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[2]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[3]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[4]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[5]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[6]/MTIP = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[1]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[2]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[3]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[4]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[5]/MTCC = '99999') and not(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM[6]/MTCC = '99999')"/>

  <xsl:template match="/">
    <html lang="fr">
      <title>Module 29 - Incidents de paiement sur effets</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | FIBEN/PERSONNE/MODULE29/PM/EI/IDENTC | FIBEN/PERSONNE/MODULE29/PM/EI/IDENTS | FIBEN/PERSONNE/MODULE29/PM/EJ/IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 29 - Incidents de paiement sur effets</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">

            <tr>
               <td class="clWidth64"></td>
              <td class="clCouleur2 clValignTop clWidth739" colspan="4">
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/PM/EJ"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/PM/EI"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/ICIP01" mode="genDiv"/>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME"/>
                <xsl:call-template name="shim"/>
                <br/>
                <a name="detail"></a>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/DIFF29/CIP03" mode="genDiv"/>
                <xsl:if test="FIBEN/PERSONNE/MODULE29/DIFF29/IPEDETAIL">
                  <table class="clWidth635 clBorderCell" role="presentation">
                    <tr>
                      <td class="clCouleurGras clWidth635 clAlignCenter">DTAIL DES INCIDENTS DE PAIEMENT EFFETS SUPRIEURS OU GAUX  1524 EUROS</td>
                    </tr>
                  </table>
                  <xsl:call-template name="shim"/>
                  <br/>
                  <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/DIFF29/IPEDETAIL"/>
                </xsl:if>
                <xsl:apply-templates select="FIBEN/PERSONNE/MODULE29/PM/EI/IDLIES"/>
              </td>
            </tr>

          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>

        <xsl:call-template name="genGraph29"/>

      </body>
    </html>
  </xsl:template>

  <xsl:template match="EVJANT">
    <xsl:call-template name="shim" />
    <br />
    <span class="clCouleur2"></span>
    <br />
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE29/PM/EJ">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS"/>
      <xsl:with-param name="nom" select="DENOM"/>
      <xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE29/PM/EI">
    <xsl:call-template name="genEnTete">
      <xsl:with-param name="ident" select="IDENTS|IDENTC"/>
      <xsl:with-param name="idrenv" select="IDRENV"/>
      <xsl:with-param name="nom" >
        <xsl:call-template name ="displayInLowerCaseXsl">
          <xsl:with-param name ="InputStringNom" select ="(IDENTITE/NOM)"/>
          <xsl:with-param name ="InputStringPrenom" select ="(IDENTITE/PRENOM)"/>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="nomconj" select="IDENTITE/NOMCONJ"/>
      <xsl:with-param name="idnouv" select="/FIBEN/PERSONNE/IDNOUV"/>
    </xsl:call-template>
  </xsl:template>


  <xsl:template match="FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME">
    <a name="situation"></a>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
         <td class="clWidth19">&#160;</td>
         <td class="clCouleurGras clWidth597 clAlignCenter">
            SITUATION RSUME SUR 15 MOIS&#160;(en
            <xsl:call-template name ="displayUnitXsl">
              <xsl:with-param name ="InputUnit" select ="(./@UNITE)"/>
            </xsl:call-template> euros)
          </td>
           <td class="clWidth19">
          <xsl:if test="not($condGraph1)">
            <img name="Image69" border="0" src="{$root}images/boutons/diagramme_in.gif" width="19" height="20"/>
          </xsl:if>
          <xsl:if test="$condGraph1">
            <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#graphe1';window.document.forms['FormGraphes'].submit();">
              <img name="Image69" border="0" src="{$root}Images/risque/diagramme_bleu.gif" width="19" height="20" alt="lien vers diagramme"/>
            </a>
          </xsl:if>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Situation rsume sur 15 mois (en milliers d'euros)</caption>
      <tr>
       
       <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">&#160;</th>
        
       <th colspan="2" class="clCouleur2 clWidth210 clAlignRight clThNonGras">
          Incapacit
          de payer&#160;&#160;&#160;&#160;&#160;&#160;
       </th>
       <th colspan="2" class="clCouleur2 clWidth210 clAlignRight clThNonGras">
          Contestation de
          crance&#160;&#160;&#160;
       </th>
       <th class="clCouleur2 clWidth105 clAlignRight clValignTop clThNonGras">&#160;</th>
      
      </tr>
      <tr>
       
          <th class="clCouleur2 clWidth110 clAlignRight clThNonGras">Mois&#160;</th>
          <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Nombre&#160;</th>
          <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Montant&#160;</th>
          <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Nombre&#160;</th>
          <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Montant&#160;</th>
          <th class="clCouleur2 clWidth105 clAlignRight clThNonGras">Total&#160;</th>
       
      </tr>
      <xsl:apply-templates select="SITRESM"/>
      <xsl:apply-templates select="SITREST"/>
    </table>
    <div class="clBreakPage"/>
  </xsl:template>

  <xsl:template match="SITRESM">
   <tr class="clAlignRight">
      <xsl:if test="position() mod 2 = 0">
        <td class="clTexte clWidth110">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTCC)"/>
          </xsl:call-template>&#160;
        </td>
       <td class="clTexteGras clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTMIPE)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:if>
      <xsl:if test="position() mod 2 != 0">
        <td class="clFond clWidth110">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(NBCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clGrasFond clWidth105">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(MTMIPE)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:if>
    </tr>
  </xsl:template>

  <xsl:template match="SITREST">
   <tr class="clAlignRight">
      <td class="clTexte clWidth110">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="t3b clWidth105">&#160;</td>
    </tr>
   <tr class="clAlignRight">
      <td class="clCouleur2 clWidth110">Total&#160;</td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTNBIP)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTMTIP)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTNBCC)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTMTCC)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(TOTSEIPE)"/>
        </xsl:call-template>&#160;
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="ICIP01" mode="genDiv">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="CIP03" mode="genDiv">
    <table class="clWidth636 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>

  <xsl:template match="FIBEN/PERSONNE/MODULE29/DIFF29/IPEDETAIL">
    <table class="clWidth739 clBorderCell">
      <caption class="visually-hidden">Dtail des incidents de paiement effets suprieurs ou gaux  1524 euros</caption>

      <xsl:if test="position() > 1">
        <xsl:call-template name="StrSplit">
          <xsl:with-param name="str" select="$sIPEbrkPage"/>
          <xsl:with-param name="moisRefCourant" select="IPEMENS/MOISREF"/>
        </xsl:call-template>
      </xsl:if>

      <xsl:apply-templates select="IPEMENS"/>
      <tr>
        <th class="clCouleur2 clWidth51 clAlignRight clValignBottom clThNonGras">Banque&#160;</th>
        <th class="clCouleur2 clWidth46 clAlignRight clValignBottom clThNonGras">Guichet&#160;</th>
        <th class="clCouleur2 clWidth67 clAlignRight clValignBottom clThNonGras">chance&#160;</th>
        <th class="clCouleur2 clWidth43 clAlignRight">
          <p>
            Code<br/>Accept.
          </p>
        </th>
       <th class="clCouleur2 clWidth7 clAlignRight clThNonGras">&#160;</th>
        <th class="clCouleur2 clWidth49 clAlignRight clThNonGras">
          &#160;MdNP<br/>(1)
        </th>
        <th class="clCouleur2 clWidth68 clAlignRight clValignBottom clThNonGras">&#160;Montant</th>
        <th class="clCouleur2 clWidth96 clAlignRight clValignBottom clThNonGras">Identifiant</th>
        <th class="clCouleur2 clWidth208 clAlignRight clValignBottom clThNonGras">&#160;Nom du crancier</th>
        <xsl:if test="position() mod 2 = 0">
          <xsl:call-template name="genFlecheHaut"/>
        </xsl:if>
        <xsl:if test="position() mod 2 != 0">
         <th class="clWidth103 clThNonGras"></th>
        </xsl:if>
      </tr>
      <xsl:apply-templates select="IPEDET"/>
      <xsl:if test="position() = last()">
        <tr>
          <td colspan="9" class="clCouleur2 clValignMiddle">
            <br/> (1) MdNP : Motif de non paiement
          </td>
        </tr>
      </xsl:if>
    </table>

     <img src="{$root}images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>


  </xsl:template>

  <xsl:template match="IPEMENS">
    <tr>
      <td class="clCouleur2" colspan="2">&#160;Mois de rejet</td>
     <td class="clGrasFond clWidth67">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
        </xsl:call-template>
      </td>
      <td class="clCouleur2 clWidth43 clAlignRight">&#160;</td>
     <td class="clCouleur2 clWidth7 clAlignRight">&#160;</td>
      <td class="clCouleur2 clWidth46">&#160;Montant</td>
     <td class="clGrasFond clWidth68 clAlignRight">
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(MT1500E)"/>
        </xsl:call-template>
        <xsl:call-template name ="displayUnitXsl2">
          <xsl:with-param name ="InputUnit" select ="(./@UNITE)"/>
          <xsl:with-param name ="Indic" select ='"1"'/>
        </xsl:call-template>
        &#160;<img src="{$root}images/risque/euro_symb_noir.png" width="8" height="9" alt="symbole euro"/>&#160;
      </td>
      <td class="clTexte clWidth96 clAlignRight clHeight10"></td>      
    </tr>
    <tr>
      <td class="clCouleur2 clWidth51 clHeight10"></td>
      <td class="clTexte clAlignCenter clWidth46 clHeight10"></td>
      <td class="clTexte clWidth67 clHeight10"></td>
     <td class="clCouleur2 clWidth7 clAlignRight clHeight10"></td>
      <td class="clCouleur2 clWidth7 clAlignRight clHeight10"></td>
      <td class="clCouleur2 clWidth49 clHeight10"></td>
      <td class="clTexte clWidth68 clAlignRight clHeight10"></td>
      <td class="clTexte clWidth96 clAlignRight clHeight10"></td>      
    </tr>
  </xsl:template>

  <xsl:template match="IPEDET">

    <xsl:variable name="COACCEP">
      <xsl:call-template name="traduction">
        <xsl:with-param name="code" select="COACCEP"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="COMOTIF">
      <xsl:call-template name="traduction">
        <xsl:with-param name="code" select="COMOTIF"/>
      </xsl:call-template>
    </xsl:variable>
    <!--pour remplacer bdf:escapestring-->
    <xsl:variable name="valCOACCEP" select="COACCEP"/>
    <xsl:variable name="valCOMOTIF" select="COMOTIF"/>
    <xsl:choose>
      <xsl:when test="position() = 55">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:when>
      <xsl:when test="position() > 67 and (position()+5) mod 60=0">
        <xsl:text disable-output-escaping="yes">&lt;tr class="clBreakPage"&gt;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="position() mod 2 != 0">
      <td class="clFond clAlignRight clWidth51">
        <xsl:value-of select="COBAN"/>&#160;
      </td>
      <td class="clFond clAlignRight clWidth46">
        <xsl:value-of select="COGUI"/>&#160;
      </td>
     <td class="clFond clAlignRight clWidth67">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATECHIPE)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clAlignRight clWidth43">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOACCEP}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COACCEP"/>
          </u>
        </a>&#160;
      </td>
     <td class="clFond clWidth7 clAlignRight">&#160;</td>
      <td class="clFond clAlignRight clWidth49">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOMOTIF}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COMOTIF"/>
          </u>
        </a>
      </td>
     <td class="clFond clAlignRight clWidth68">
        &#160;
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(MTUNIT)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clAlignRight clValignBottom clWidth96">
        &#160;
        <xsl:if test="string-length(IDENTCR) != 0">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(IDENTCR)"/>
          </xsl:call-template>
        </xsl:if>
      </td>
     <td class="clFond clAlignRight clWidth208">
        &#160;<xsl:value-of select="CREAN"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <td class="clTexte clAlignRight clWidth51">
        <xsl:value-of select="COBAN"/>&#160;
      </td>
     <td class="clTexte clAlignRight clWidth46">
        <xsl:value-of select="COGUI"/>&#160;
      </td>
     <td class="clTexte clAlignRight clWidth67">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(DATECHIPE)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clFond clAlignRight clWidth43">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOACCEP}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COACCEP"/>
          </u>
        </a>&#160;
      </td>
     <td class="clFond clWidth7 clAlignRight">&#160;</td>
      <td class="clFond clAlignRight clWidth49">
        <a href="#nullePart" onclick="requestInfosLibelle('{$valCOMOTIF}',cstWordingCodeAcceptMotif)" class="clTexte">
          <u>
            <xsl:value-of select="COMOTIF"/>
          </u>
        </a>
      </td>
     <td class="clFond clAlignRight clWidth68">
        &#160;
        <xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(MTUNIT)"/>
        </xsl:call-template>
      </td>
      <td class="clTexte clAlignRight clValignBottom clWidth96">
        &#160;
        <xsl:if test="string-length(IDENTCR) != 0">
          <xsl:call-template name ="displaySirenXsl">
            <xsl:with-param name ="InputSiren" select ="(IDENTCR)"/>
          </xsl:call-template>
        </xsl:if>
      </td>
     <td class="clTexte clAlignRight clWidth208">
        &#160;<xsl:value-of select="CREAN"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="position() mod 10 = 0">
      <xsl:call-template name="genFlecheHaut"/>
    </xsl:if>
    <xsl:if test="position() mod 10 != 0">
     <td class="clWidth103"></td>
    </xsl:if>
    <xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>

    <!--<02/06/2008 tec 9303 ajout d'un lien pour interroger autre module> revu le 21 juillet par pierre-->
    <xsl:choose>
      <xsl:when test="IDENTCR != ''">
        <tr>
         <td class="clAlignRight" colspan="9">
            <a href="#nullepart" onClick="requestBDFInfos('27','','','{IDENTCR}',cstSimpleConfirm,false,this);">
              <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:when>
      <xsl:when test="CREAN != ''">
        <tr>
         <td class="clAlignRight" colspan="9">
            <a href="#nullepart" onClick="requestBDFInfos('07','','','{CREAN}',cstSimpleConfirm,false,this);">
              <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <tr>
         <td class="clAlignRight" colspan="9">&#160;</td>
        </tr>

      </xsl:otherwise>
    </xsl:choose>

    <!--fin<02/06/2008>-->

  </xsl:template>

  <xsl:template name="StrSplit">
    <xsl:param name="str"/>
    <xsl:param name="moisRefCourant"/>

    <xsl:choose>
      <xsl:when test="contains($str,',')">
        <xsl:if test="$moisRefCourant = substring-before($str,',')">
          <div class="clBreakPage"/>
        </xsl:if>

        <xsl:call-template name="StrSplit">
          <xsl:with-param name="str" select="substring-after($str,',')" />
          <xsl:with-param name="moisRefCourant" select="$moisRefCourant"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$moisRefCourant = $str">
          <div class="clBreakPage"/>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="genGraph29">
    <xsl:if test="$condGraph1">
      <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
        <input name="familyNumber" type="hidden" value="1"/>
        <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
        <xsl:element name="input">
          <xsl:attribute name="name">GrapheData</xsl:attribute>
          <xsl:attribute name="type">hidden</xsl:attribute>
          <xsl:attribute name="value">
            &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
              <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
            </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE29/PM/EJ/IDENTS|FIBEN/PERSONNE/MODULE29/PM/EI/IDENTS|FIBEN/PERSONNE/MODULE29/PM/EI/IDENTC"/>&lt;/ident&gt;<xsl:if test="FIBEN/PERSONNE/MODULE29/PM/EJ">
              &lt;nom&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE29/PM/EJ/DENOM"/>&lt;/nom&gt;
            </xsl:if><xsl:if test="FIBEN/PERSONNE/MODULE29/PM/EI">
              &lt;nom&gt;<xsl:call-template name ="displayInLowerCaseXsl">
                <xsl:with-param name ="InputStringNom" select ="(FIBEN/PERSONNE/MODULE29/PM/EI/IDENTITE/NOM)"/>
                <xsl:with-param name ="InputStringPrenom" select ="(FIBEN/PERSONNE/MODULE29/PM/EI/IDENTITE/PRENOM)"/>
              </xsl:call-template>&lt;/nom&gt;&lt;nomconj&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE29/PM/EI/IDENTITE/NOMCONJ"/>&lt;/nomconj&gt;<xsl:if test="FIBEN/PERSONNE/MODULE29/PM/EI/IDENTC">
                &lt;idrenv&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE29/PM/EI/IDRENV"/>&lt;/idrenv&gt;
              </xsl:if>
            </xsl:if>&lt;graphe&gt;&lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM">
              &lt;val&gt;<xsl:value-of select="MTIP"/>&lt;/val&gt;
            </xsl:for-each>&lt;/serie&gt;&lt;serie&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM">
              &lt;val&gt;<xsl:value-of select="MTCC"/>&lt;/val&gt;
            </xsl:for-each>&lt;/serie&gt;&lt;abcisse&gt;<xsl:for-each select="FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/SITRESM">
              &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(MOISREF)"/>
              </xsl:call-template>&lt;/val&gt;
            </xsl:for-each>&lt;/abcisse&gt;&lt;titre&gt;Incidents de paiement effets au cours des 15 derniers mois (en
            <xsl:call-template name ="displayUnitXsl">
              <xsl:with-param name ="InputUnit" select ="(FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/@UNITE)"/>
            </xsl:call-template>
            euros)&lt;/titre&gt;&lt;signet&gt;Situation rsume&lt;/signet&gt;&lt;unite&gt;<xsl:value-of select="FIBEN/PERSONNE/MODULE29/DIFF29/IPERESUME/@UNITE"/>&lt;/unite&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
          </xsl:attribute>
        </xsl:element>
      </form>
    </xsl:if>
  </xsl:template>

  <xsl:template match="text()"/>

</xsl:stylesheet>

