﻿Imports System.IO
Imports System.Web.UI.DataVisualization.Charting

Partial Class modules_m27_graphiques_Graphe1
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Const nbSeries As Integer = 2
        Const nbValues As Integer = 3

        Dim sSerieTitle(nbSeries) As String
        Dim sTitles(2) As String
        sTitles(0) = "Chiffre d'affaires sur 3 exercices (en millions d'euros)" 'titre principal
        sTitles(1) = "Dates d'arrêté" 'Titre des abcisses
        sTitles(2) = "Montants des CA" 'Titre des ordonnées

        sSerieTitle(0) = "CA intérieur"
        sSerieTitle(1) = "CA exportation"

        Using oGraphique As New NewGraphique(Context, nbSeries, nbValues)
            Using imgStream As New MemoryStream()
                oGraphique.QueryStringToDataTable()
                ' Transformation de la valeur de la première série  de CA TOTAL en CA intérieur (= CA TOTAL - CA extérieur)
                If nbSeries > 1 Then
                    For ligne As Integer = 0 To nbValues - 1
                        oGraphique.data(ligne)("Col1") = oGraphique.data(ligne)("Col1") - oGraphique.data(ligne)("Col2")
                    Next
                End If

                oGraphique.CreateColumGraphImage(sSerieTitle, sTitles, NewGraphique.Style_Stacked).SaveImage(imgStream, ChartImageFormat.Png)
                'Output the contents of the watermarked image stream
                Response.ContentType = "image/png"
                Response.BinaryWrite(imgStream.GetBuffer())
            End Using
        End Using

    End Sub
End Class
