<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="codeLib" select="''"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="titleUK" select="''"/>

  <xsl:variable name="condGraph1" select="((//BILAN27[1]/p2052FL/@ETAT='ND' or //BILAN27[2]/p2052FL/@ETAT='ND' or //BILAN27[3]/p2052FL/@ETAT='ND' or //BILAN27[1]/p209101='' or //BILAN27[2]/p209101='' or //BILAN27[3]/p209101='') or count(//BILAN27)!=3)=false"/>
  <xsl:variable name="condGraph2" select=" (count(//IMPAYE[NBIPE=0]) >= 2 or not(translate(//IMPAYE[1]/MTIPE,',','.') + translate(//IMPAYE[2]/MTIPE,',','.') + translate(//IMPAYE[3]/MTIPE,',','.') + translate(//IMPAYE[4]/MTIPE,',','.') >10000) or //IMPAYE[1]/MTIPE = '99999999999' or //IMPAYE[1]/MTIPE = '99999999,99' or //IMPAYE[2]/MTIPE = '99999999999' or //IMPAYE[2]/MTIPE = '99999999,99' or //IMPAYE[3]/MTIPE = '99999999999' or //IMPAYE[3]/MTIPE = '99999999,99' or //IMPAYE[4]/MTIPE = '99999999999' or //IMPAYE[4]/MTIPE = '99999999,99')=false"/>

  <!--Essai-->
  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr">
      <title>Module 27 - Panorama de l'entreprise ou du dirigeant</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULE27/*//IDENTC|/FIBEN/PERSONNE/MODULE27/*//IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>

        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 27 - Panorama de l'entreprise ou du dirigeant</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
               <td class="clWidth64"></td>
              <td class="clWidth636 clValignTop clCouleurGras" colspan="2">
                <xsl:call-template name="genEnTete">
                  <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE27/*//IDENTC|/FIBEN/PERSONNE/MODULE27/*//IDENTS"/>
                  <xsl:with-param name="nom">
                    <xsl:if test="//EJ27/DENOM">
                      <xsl:value-of select="//EJ27/DENOM"/>
                    </xsl:if>
                    <xsl:if test="//IDENTITE/NOM">
                      <xsl:call-template name ="displayInLowerCaseXsl">
                        <xsl:with-param name ="InputStringNom" select ="(//IDENTITE/NOM)"/>
                        <xsl:with-param name ="InputStringPrenom" select ="(//IDENTITE/PRENOM)"/>
                      </xsl:call-template>

                    </xsl:if>
                  </xsl:with-param>
                  <xsl:with-param name="nomconj" select="(/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDENTITE/NOMCONJ|/FIBEN/PERSONNE/MODULE27/PP/IDENTITE/NOMCONJ)"/>
                  <xsl:with-param name="valcot" select="//COTATION/VALCOT"/>
                  <xsl:with-param name="segment">
                    <xsl:if test="//COTATION/SEGMENT">
                      <xsl:value-of select="//COTATION/SEGMENT"/>
                    </xsl:if>
                  </xsl:with-param>
                  <xsl:with-param name="datcot" select="//COTATION/DATCOT"/>
                  <xsl:with-param name="datexa" select="//COTATION/DATEXA"/>
                  <xsl:with-param name="dateseg" select="//COTATION/DATESEG"/>
                  <xsl:with-param name="datsegrv" select="//COTATION/DATSEGRV"/>
                  <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDRENV"/>
                  <xsl:with-param name="valindic" select="//INDICEI/VALINDIC"/>
                  <xsl:with-param name="datindic" select="//INDICEI/DATINDIC"/>
                  <xsl:with-param name="indexa2" select="//INDICEI/DATEXAIN"/>

                </xsl:call-template>
                <xsl:variable name="cotation" select="//COTATION/COTPREC/VALCOT"/>
                <xsl:if test="not($cotation='NS')">
                  <!--POUR MASQUER "Cotation(s) prcdente(s) attribue(s) dans les 23 derniers mois" lorsque NON RESIDENT (NS)-->
                  <xsl:apply-templates select="//COTATION/DATBILS"/>
                  <xsl:apply-templates select="//COTATION/DATBILC"/>
                  <xsl:choose>
                    <xsl:when test="//EI27/IDENTS">
                      <xsl:apply-templates select="//COTATION/COTPREC"/>
                      <xsl:apply-templates select="//INDICEI/INDPREC"/>
                    </xsl:when>
                    <xsl:when test="//EI27/IDENTC">
                      <xsl:apply-templates select="//INDICEI/INDPREC"/>
                      <xsl:apply-templates select="//COTATION/COTPREC"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:apply-templates select="//COTATION/COTPREC"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:if test="(((//COTATION/DATBILS) or (//COTATION/DATBILC) or (//COTATION/COTPREC)) and not(//INDICEI/INDPREC)) ">
                    <xsl:call-template name="shim"/>
                  </xsl:if>
                  <xsl:if test="(((//COTATION/DATBILS) or (//COTATION/DATBILC) or (//COTATION/COTPREC)) and (//INDICEI/INDPREC)) ">
                    <xsl:call-template name="shim"/>
                  </xsl:if>
                  <xsl:if test="(not((//COTATION/DATBILS) or (//COTATION/DATBILC) or (//COTATION/COTPREC)) and (//INDICEI/INDPREC)) ">
                    <xsl:call-template name="shim"/>
                  </xsl:if>
                </xsl:if>
                <xsl:call-template name="FONCDIR"/>
                <xsl:apply-templates select="//INFOJURIDIQUES"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/IEC01" mode="DisplayM27"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/INFOCOMPTABLES"/>
                <xsl:if test="/FIBEN/PERSONNE/MODULE27/PM27/EJ27/GROUPE/BIL01C">
                  <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/PM27/INFOCOMPTABLES/BIL01S) and not(/FIBEN/PERSONNE/MODULE27/PM27/INFOCOMPTABLES/BIL02)">
                    <br>
                      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/EJ27/GROUPE/BIL01C"/>
                    </br>
                  </xsl:if>
                  <xsl:if test="(/FIBEN/PERSONNE/MODULE27/PM27/INFOCOMPTABLES/BIL01S) or (/FIBEN/PERSONNE/MODULE27/PM27/INFOCOMPTABLES/BIL02)">
                    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/EJ27/GROUPE/BIL01C"/>
                  </xsl:if>
                  <xsl:call-template name="shim"/>
                </xsl:if>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/EJ27/GROUPE/EJ"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/INFOIMPAYES"/>
                <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/EVMARQ or /FIBEN/PERSONNE/MODULE27/DIFF27/EVJUD or /FIBEN/PERSONNE/MODULE27/PM27/EI27/JUGEIND">
                  <a name="ancJugement"></a>
                </xsl:if>
                <table class="clWidth635 clBorderCell">
                  <caption class="visually-hidden">VNEMENT(S) MARQUANT(S)/JUDICIAIRE(S)</caption>
                  <tr class="clHeight0">
                    <td class="clWidth20"></td>
                    <td class="clWidth110"></td>
                    <td class="clWidth130"></td>
                    <td class="clWidth135"></td>
                    <td class="clWidth120"></td>
                    <td class="clWidth120"></td>
                  </tr>
                  <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/DIFF27/EVMARQ"/>
                  <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/DIFF27/EVJUD"/>
                  <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/EI27/JUGEIND" mode="genTable"/>
                  <xsl:apply-templates select="/FIBEN/PERSONNE/MODULE27/PM27/INFORISQUES"/>
                </table>
                <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/PP)">
                  <xsl:call-template name="shim"/>
                </xsl:if>
                <xsl:apply-templates select="//HOMONYME"/>
                <xsl:apply-templates select="//IDLIES"/>
              </td>
              <xsl:call-template name="genFlecheHaut"/>
            </tr>

          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>


        <xsl:call-template name="genGraph27">
          <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULE27/*//IDENTC|/FIBEN/PERSONNE/MODULE27/*//IDENTS"/>
          <xsl:with-param name="nom" select="//IDENTITE/NOM"/>
          <xsl:with-param name="prenom" select ="//IDENTITE/PRENOM"/>
          <xsl:with-param name="nomconj" select="//IDENTITE/NOMCONJ"/>
          <xsl:with-param name="valcot" select="//COTATION/VALCOT"/>
          <xsl:with-param name="segment">
            <xsl:if test="//COTATION/SEGMENT">
              <xsl:value-of select="//COTATION/SEGMENT"/>
            </xsl:if>
          </xsl:with-param>
          <xsl:with-param name="datcot" select="//COTATION/DATCOT"/>
          <xsl:with-param name="datexa" select="//COTATION/DATEXA"/>
          <xsl:with-param name="idrenv" select="/FIBEN/PERSONNE/MODULE27/PM27/EI27/IDRENV"/>
        </xsl:call-template>

      </body>
    </html>
  </xsl:template>

  <!--********************************************************************************************************************************************************************-->
  <!--TEMPLATE 3eme PAVE : INFORMATIONS JURIDIQUES-->

  <xsl:template match="INFOJURIDIQUES">
    <a name="ancJurid"></a>
    <table class="clWidth635 clBorderCell" role="presentation">     
     <tr class="clAlignCenter">
        <td class="clCouleurGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_InfJur'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br />
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">INFORMATIONS JURIDIQUES</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_CatJur'"/>
          </xsl:call-template>
        </th>
        <td class="clFond" colspan="3">
          &#160;<xsl:value-of select="CODECAT"/>&#160;&#160;&#160;<xsl:value-of select="CATJUR"/>
        </td>
      </tr>
      <tr>
         <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_ActBDF'"/>
          </xsl:call-template>
        </th>
        <td class="clTexte" colspan="3">
          &#160;<xsl:value-of select="ACTBDF"/>&#160;&#160;
          <xsl:if test="$Lang = 'UK'">
            <xsl:call-template name="tradLibNaf">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codelib" select="ACTBDF"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="$Lang = 'FR'">
            <xsl:value-of select="LIBACT"/>
          </xsl:if>
        </td>
      </tr>
      <xsl:apply-templates select="CODNAF"/>
      <xsl:apply-templates select="p2051DA"/>
      <xsl:apply-templates select="ENSEIGNE"/>
      <xsl:if test="not(p2051DA) and not(ENSEIGNE) and DATCRE">
        <tr>
           <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clTexte clWidth305">&#160;</td>
          <xsl:apply-templates select="DATCRE"/>
        </tr>
      </xsl:if>
      <xsl:apply-templates select="SIGLE"/>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="CODNAF">
    <tr>
       <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m27_CodeNaf'"/>
        </xsl:call-template>
      </th>
      <td class="clFond" colspan="3">
        &#160;<xsl:value-of select="."/>&#160;&#160;
        <xsl:if test="$Lang = 'UK'">
          <xsl:call-template name="tradLibNaf">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codelib" select="."/>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="$Lang = 'FR'">
          <xsl:value-of select="../LIBNAF"/>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="p2051DA">
    <tr>
      <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m27_Cap'"/>
        </xsl:call-template>
      </th>
      <xsl:if test="../CODNAF">
        <td class="clTexte clWidth305">
          <xsl:if test="@ETAT">
            &#160;<xsl:value-of select="@ETAT"/>
          </xsl:if>
          <xsl:if test="not(@ETAT)">
            &#160;<xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(.)"/>
            </xsl:call-template>&#160;<img height="9" src="{$root}images/Commun/euro_symb_noir.png" width="8" alt="symbole euro"/>
          </xsl:if>
          <xsl:if test="../DATAG">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_au'"/>
            </xsl:call-template>&#160;
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(../DATAG)"/>
            </xsl:call-template>
          </xsl:if>
        </td>
        <xsl:apply-templates select="../DATCRE"/>
        <xsl:if test="not(../DATCRE) and ../SIGLE[1]">
          <xsl:call-template name="SIGLEclTexte">
            <xsl:with-param name="titre">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="sigle" select="../SIGLE[1]"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
      <xsl:if test="not(../CODNAF)">
        <td class="clFond clWidth305">
          <xsl:if test="@ETAT">
            &#160;<xsl:value-of select="@ETAT"/>
          </xsl:if>
          <xsl:if test="not(@ETAT)">
            &#160;<xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(.)"/>
            </xsl:call-template>&#160;<img height="9" src="{$root}images/Commun/euro_symb_noir.png" width="8" alt="symbole euro"/>
          </xsl:if>
          <xsl:if test="../DATAG">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_au'"/>
            </xsl:call-template>&#160;
            <xsl:call-template name ="displayDateXsl">
              <xsl:with-param name ="InputDate" select ="(../DATAG)"/>
            </xsl:call-template>
          </xsl:if>
        </td>
        <xsl:apply-templates select="../DATCRE"/>
        <xsl:if test="not(../DATCRE) and ../SIGLE[1]">
          <xsl:call-template name="SIGLEclFond">
            <xsl:with-param name="titre">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="sigle" select="../SIGLE[1]"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
    </tr>
  </xsl:template>

  <xsl:template match="ENSEIGNE">
    <tr>
      <xsl:if test="position()=1">
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Enseig'"/>
          </xsl:call-template>
        </th>
        <xsl:if test="(../CODNAF and ../p2051DA) or (not(../CODNAF) and not(../p2051DA))">
          <td class="clFond">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA)">
            <xsl:apply-templates select="../DATCRE"/>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE))and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
        <xsl:if test="(../CODNAF and not(../p2051DA)) or (not(../CODNAF) and ../p2051DA)">
          <td class="clTexte clWidth305">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA)">
            <xsl:apply-templates select="../DATCRE"/>
            <xsl:if test="not(../DATCRE)">
              <td class="clTexte clWidth200">&#160;</td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
      </xsl:if>
      <xsl:if test="position()=2">
        <td class="clCouleur2 clWidth130">&#160;</td>
        <xsl:if test="(../CODNAF and ../p2051DA) or (not(../CODNAF) and not(../p2051DA))">
          <td class="clTexte clWidth305">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA) and ../DATCRE and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[3]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="sigle" select="../SIGLE[3]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
        <xsl:if test="(../CODNAF and not(../p2051DA)) or (not(../CODNAF) and ../p2051DA)">
          <td class="clFond clWidth305">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA) and ../DATCRE and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[3]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="sigle" select="../SIGLE[3]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </tr>
  </xsl:template>

  <xsl:template match="DATCRE">
     <th class="clCouleur2 clWidth120 clAlignLeft clThNonGras">
       &#160;
      <xsl:call-template name="tradlib">
        <xsl:with-param name="Lang" select="$Lang"/>
        <xsl:with-param name="codeLib" select="'m27_DatCre'"/>
      </xsl:call-template>
    </th>
    <xsl:if test="../CODNAF">
      <td class="clTexte clWidth80">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(.)"/>
        </xsl:call-template>
      </td>
    </xsl:if>
    <xsl:if test="not(../CODNAF)">
      <td class="clFond clWidth80">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(.)"/>
        </xsl:call-template>
      </td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="SIGLE">
    <xsl:if test="position()=1">
      <xsl:if test="(../DATCRE and not(../ENSEIGNE))or(not(../p2051DA) and count(../ENSEIGNE)=1 and ../DATCRE)">
        <tr>
           <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clWidth305">&#160;</td>
          <th class="clCouleur2 clWidth120 clAlignLeft clThNonGras">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
            </xsl:call-template>
          </th>
          <xsl:if test="../CODNAF">
             <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
             <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="not(../DATCRE) and not(../ENSEIGNE) and not (../p2051DA)">
        <tr>
           <td class="clCouleur2 clWidth130">&#160;</td>
           <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
            </xsl:call-template>
          </td>
          <xsl:if test="../CODNAF">
             <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
             <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=2">
      <xsl:if test="(not(../DATCRE) and not(../ENSEIGNE))or(not(../ENSEIGNE[2]) and not(../DATCRE)and not(../p2051DA))">
        <tr>
           <td class="clCouleur2 clWidth130">&#160;</td>
           <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">&#160;</td>
          <xsl:if test="../CODNAF">
             <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
             <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="(not(../p2051DA) and count(../ENSEIGNE)!=0 and ../DATCRE) or (not(../ENSEIGNE) and ../DATCRE) or (count(../ENSEIGNE)=1 and ../DATCRE and ../p2051DA)">
        <tr>
           <td class="clCouleur2 clWidth130">&#160;</td>
           <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">&#160;</td>
          <xsl:if test="../CODNAF">
             <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
             <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=3">
      <xsl:if test="not(../ENSEIGNE[2] and ../p2051DA and not(../DATCRE))">
        <tr>
           <td class="clCouleur2 clWidth130">&#160;</td>
           <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">&#160;</td>
          <xsl:if test="(../CODNAF and ../DATCRE) or (not(../CODNAF) and not(../p2051DA) and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and not(../DATCRE))">
             <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="(../CODNAF and ../p2051DA and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and ../DATCRE) or (not(../p2051DA) and not(../CODNAF) and ../DATCRE ) or (not(../DATCRE) and not(../p2051DA) and ../CODNAF)">
             <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=4">
      <tr>
         <td class="clCouleur2 clWidth130">&#160;</td>
         <td class="clWidth305">&#160;</td>
        <td class="clCouleur2 clWidth120">&#160;</td>
        <xsl:if test="(../CODNAF and ../DATCRE) or (not(../CODNAF) and not(../p2051DA) and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and not(../DATCRE))">
           <td class="clTexte clWidth80">
            &#160;<xsl:value-of select="."/>
          </td>
        </xsl:if>
        <xsl:if test="(../CODNAF and ../p2051DA and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and ../DATCRE) or (not(../p2051DA) and not(../CODNAF) and ../DATCRE ) or (not(../DATCRE) and not(../p2051DA) and ../CODNAF)">
           <td class="clFond clWidth80">
            &#160;<xsl:value-of select="."/>
          </td>
        </xsl:if>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template name="SIGLEclFond">
    <xsl:param name="titre"/>
    <xsl:param name="sigle"/>
    <td class="clCouleur2 clWidth120">
      &#160;<xsl:value-of select="$titre"/>
    </td>
     <td class="clFond clWidth80">
      &#160;<xsl:value-of select="$sigle"/>
    </td>
  </xsl:template>

  <xsl:template name="SIGLEclTexte">
    <xsl:param name="titre"/>
    <xsl:param name="sigle"/>
    <td class="clCouleur2 clWidth120">
      &#160;<xsl:value-of select="$titre"/>
    </td>
     <td class="clTexte clWidth80">
      &#160;<xsl:value-of select="$sigle"/>
    </td>
  </xsl:template>

  <!--********************************************************************************************************************************************************************-->
  <!--TEMPLATE 4eme PAVE : COMPTE SOCIAUX, COMPTES CONSOLIDEES CHIFFRES CLES-->

  <xsl:template match="INFOCOMPTABLES">
    <a name="ancSociaux"></a>
    <xsl:apply-templates select="BILAN27[last()]"/>
    <xsl:if test="BIL01S or BIL02">
      <xsl:apply-templates select="../EJ27/GROUPE/BILCONSO"/>
      <table class="clWidth635 clBorderCell" role="presentation">        
        <tr>
          <td class="clTexte clCouleur2">            
              <xsl:apply-templates select="BIL01S|BIL02"/>           
          </td>
        </tr>
      </table>
      <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/PM27/EJ27/GROUPE/BIL01C)">
        <xsl:call-template name="shim"/>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="BILAN27">
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">CHIFFRES CLS</caption>
     <tr class="clAlignCenter">
         <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clWidth597">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
          </xsl:call-template>
        </td>
         <td class="clWidth19">
          <xsl:if test="not($NonResident='NR')">
            <xsl:if test="$condGraph1='true'">
              <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms['FormGraphes'].submit();">
                <img title="Graphique" alt="Graphique" border="0" height="20" name="dia2" src="{$root}images/risque/diagramme_bleu.gif" width="19"/>
              </a>
            </xsl:if>
            <xsl:if test="$condGraph1 != 'true'">
              <img src="{$root}images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique" />&#160;
            </xsl:if>
          </xsl:if>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br />
    <xsl:if test="//EJ27/GROUPE/BILCONSO">      
      <table class="clWidth635 clHeight125 clBorderCell" role="presentation">        
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComSoc'"/>
            </xsl:call-template>
          </th>
          <td colspan="{count(../BILAN27)}">
            &#160;
          </td>
          <td class="clWidth15 clHeight125 clAlignCenter clValignBottom" rowspan="10">
            <img height="125" src="{$root}images/risque/shim_bleu.gif" width="1" alt=""/>
          </td>
          <th colspan="2" class="clCouleur2 clWidth140 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComCon'"/>
            </xsl:call-template>
          </th>
          <td colspan="{count(//EJ27/GROUPE/BILCONSO)}">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"></td>
          <td class="clHeight5" colspan="4"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/@DATCLOT"/>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/@DATCLOT"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/@DUREEEX"/>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/@DUREEEX"/>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"></td>
          <td class="clHeight5" colspan="4"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth85 clHeight15 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_CA'"/>
            </xsl:call-template>
            (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>)
          </th>
          <td class="clCouleur2 clWidth65 clHeight15">&#160;</td>
          <td colspan="{count(../BILAN27)}" class="clFond clHeight15">&#160;</td>
          <th class="clCouleur2 clWidth140 clHeight15 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_CAGRP'"/>
            </xsl:call-template>
            (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>)
          </th>
          <td colspan="{count(//EJ27/GROUPE/BILCONSO)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clCouleur2"></td>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/p2052FL"/>
          <td class="clWidth39"></td>
          <th class="clCouleur2 clWidth101 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/pCACONS"/>
        </tr>
        <tr>
          <td></td>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Export'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/p2052FK"/>
          <td></td>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Etranger'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/p2010AD"/>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"></td>
          <td class="clHeight5" colspan="4"></td>
        </tr>
        <tr>
          <th class="clCouleur2  clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/p2058YP"/>
          <th class="clCouleur2  clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/pEFFECT"/>
        </tr>
        <xsl:if test="../DATDOC">
          <xsl:if test="not($NonResident='NR')">
            <tr>
              <td class="clAlignRight" colspan="10">
                <a href="#nullepart" onClick="requestBDFInfos('VB','','','{//IDRENV}',false,false,this);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" title="Gnrer une Vitrine Bilans" alt="Gnrer une Vitrine Bilans"/>
                </a>
              </td>
            </tr>
          </xsl:if>          
        </xsl:if>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
    <xsl:if test="not(//EJ27/GROUPE/BILCONSO)">
      <table class="clWidth635 clHeight125 clBorderCell" role="presentation">        
        <tr>
          <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComSoc'"/>
            </xsl:call-template>
          </th>
          <td colspan="4">
            &#160;
          </td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="6"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/@DATCLOT"/>
          <td width="{75-25*count(//BILAN27)}%" colspan="{3-count(//BILAN27)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/@DUREEEX"/>
          <td colspan="{3-count(//BILAN27)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="6"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth85 clHeight15 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_CA'"/>
            </xsl:call-template>
            (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8" alt="symbole euro"/>)
          </th>
          <td class="clCouleur2 clWidth65 clHeight15">&#160;</td>
          <td class="clFond clHeight15" colspan="4">&#160;</td>
        </tr>
        <tr>
          <td class="clCouleur2"></td>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/p2052FL|../BILAN27/p209101"/>
          <td colspan="{3-count(//BILAN27)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td></td>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Export'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/p2052FK"/>
          <td colspan="{3-count(//BILAN27)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="6"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILAN27/p2058YP"/>
          <td colspan="{3-count(//BILAN27)}" class="clFond">&#160;</td>
        </tr>
        <xsl:if test="../DATDOC">
          <xsl:if test="not($NonResident='NR')">
            <tr>
              <td class="clAlignRight" colspan="6">
                <a href="#nullepart" onClick="requestBDFInfos('VB','','','{//IDRENV}',false,false,this);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" title="Gnrer une Vitrine Bilans" alt="Gnrer une Vitrine Bilans"/>
                </a>
              </td>
            </tr>
          </xsl:if>         
        </xsl:if>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="BILCONSO">
    <xsl:if test="position()=last()">
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">CHIFFRES CLS</caption>
       <tr class="clAlignCenter">
           <td class="clWidth19">&#160;</td>
           <td class="clCouleurgras clWidth597">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
            </xsl:call-template>
          </td>
           <td class="clWidth19">
            <xsl:if test="not($NonResident='NR')">
              <xsl:if test="$condGraph1='true'">
                <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe1';window.document.forms	['FormGraphes'].submit();">
                  <img title="Graphique" alt="Graphique" border="0" height="20" name="dia2" src="{$root}images/risque/diagramme_bleu.gif" width="19" />
                </a>
              </xsl:if>
              <xsl:if test="$condGraph1 != 'true'">
                <img src="{$root}images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique" />&#160;
              </xsl:if>
            </xsl:if>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br />
      <table class="clWidth635 clHeight125 clBorderCell" role="presentation">        
        <tr>
          <td colspan="2" class="clCouleur2 clWidth140">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComCon'"/>
            </xsl:call-template>
          </td>
          <td colspan="3">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/@DATCLOT"/>
          <td width="{80-40*count(//EJ27/GROUPE/BILCONSO)}%" class="clFond">&#160;</td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/@DUREEEX"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth140 clHeight15 clAlignLeft clThNonGras" colspan="2">
            CA Groupe (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8" alt="symbole euro"/>)
          </th>
          <td colspan="3" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clCouleur2 clWidth39"></td>
          <th class="clCouleur2 clAlignLeft clWidth101 clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/pCACONS"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td></td>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Etranger'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/p2010AD"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"></td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//EJ27/GROUPE/BILCONSO/pEFFECT"/>
          <td class="clFond">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="p2052FL|p209101|p2052FK|pCACONS|p2010AD">
    <xsl:if test="@ETAT">
      <td class="clFond clAlignRight">
        &#160;<xsl:value-of select="@ETAT"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <td class="clFond clAlignRight">
        &#160;<xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="p2058YP|pEFFECT">
    <xsl:if test="@ETAT">
     <td class="clFond clAlignRight">
        &#160;<xsl:value-of select="@ETAT"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
     <td class="clFond clAlignRight">
        &#160;<xsl:call-template name ="displayNumberXsl">
          <xsl:with-param name ="InputStringNumber" select ="(.)"/>
        </xsl:call-template>&#160;
      </td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="@DATCLOT|@DUREEEX">
   <td class="clFond clAlignRight">
      <xsl:if test="$Lang='FR'">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(.)"/>
        </xsl:call-template>&#160;

      </xsl:if>
      <xsl:if test="$Lang='UK'">
        &#160;<xsl:call-template name ="displayDateUKXsl">
          <xsl:with-param name ="InputDate" select ="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
  </xsl:template>

  <!--********************************************************************************************************************************************************************-->
  <!--TEMPLATE 5eme PAVE : SOCIETE CONSOLIDANTE-->

  <xsl:template match="GROUPE/EJ">
    <xsl:if test="position()=last()">
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">SOCIT(S) CONSOLIDANT L'ENTREPRISE</caption>
        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_SoCoEn'"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br />
      <table class="clWidth635 clBorderCell" role="presentation">
        <xsl:for-each select="../EJ">
          <tr>
            <td class="clFond clWidth130">
              &#160;<xsl:call-template name ="displaySirenXsl">
                <xsl:with-param name ="InputSiren" select ="(IDENTS)"/>
              </xsl:call-template>
            </td>
            <td class="clFond clWidth425">
              &#160;<xsl:value-of select="DENOM"/>
            </td>
            <td class="clFond clWidth80 clAlignRight">
              &#160;	<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Au'"/>
              </xsl:call-template>&#160;
              <xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(@DATPERI)"/>
              </xsl:call-template>
            </td>
          </tr>
          <xsl:if test="not($NonResident='NR')">
            <tr>
              <td colspan="3" class="clWidth635 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                </a>
              </td>
            </tr>
          </xsl:if>
          <xsl:if test="$NonResident='NR'">
            <tr>
              <td colspan="3" class="clWidth635 clAlignRight">&#160;</td>
            </tr>
          </xsl:if>
        </xsl:for-each>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>

  <!--********************************************************************************************************************************************************************-->
  <!--TEMPLATE 6eme PAVE : INCIDENTS DE PAIEMENT-->

  <xsl:template match="INFOIMPAYES">
    <a name="ancEffet"></a>
    <xsl:if test="CIP01 or CIP02">
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">INCIDENTS DE PAIEMENT EFFETS</caption>
        <tr>
          <td class="clTexte clCouleur2">           
              <xsl:apply-templates select="CIP01|CIP02"/>            
          </td>
          <xsl:if test="CIP02">
            <xsl:if test="not($NonResident='NR')">
              <tr>
                <td colspan="2" class="clWidth635 clAlignRight">
                  <a href="#nullepart" onclick="requestBDFInfos('29','','','',cstSimpleConfirm);">
                    <img border="0" height="12"	src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                  </a>
                </td>
              </tr>
            </xsl:if>
          </xsl:if>
        </tr>
      </table>
    </xsl:if>
    <xsl:apply-templates select="IMPAYE"/>
    <xsl:call-template name="shim"/>
  </xsl:template>

  <xsl:template match="IMPAYE">
    <xsl:if test="position()=last()">
      <table class="clWidth635 clBorderCell" role="presentation">
        <caption class="visually-hidden">INCIDENTS DE PAIEMENT EFFETS</caption>
       <tr class="clAlignCenter">
           <td class="clWidth19">&#160;</td>
          <td class="clCouleurGras clWidth597">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_InPaEf'"/>
            </xsl:call-template>
          </td>
           <td class="clWidth19">
            <xsl:if test="not($NonResident = 'NR')">
              <xsl:if test="$condGraph2 = 'true'">
                <a href="#nullepart" onclick="window.document.forms['FormGraphes'].action='Graphes.aspx#Graphe2';window.document.forms['FormGraphes'].submit();">
                  <img title="Graphique" alt="Graphique" border="0" height="20" name="dia2" src="{$root}images/risque/diagramme_bleu.gif" width="19"/>
                </a>
              </xsl:if>
              <xsl:if test="$condGraph2 != 'true'">
                <img src="{$root}images/boutons/diagramme_in.gif" width="19" height="20" border="0" title="Graphique" alt="Graphique" />&#160;
              </xsl:if>
            </xsl:if>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br />
      <xsl:variable name="tmp" select="../IMPAYE[1]/MTIPE + ../IMPAYE[2]/MTIPE + ../IMPAYE[3]/MTIPE + ../IMPAYE[4]/MTIPE"/>

      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">INCIDENTS DE PAIEMENT EFFETS</caption>
        <tr>
          <th class="clCouleur2 clWidth205 clAlignRight clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Trim'"/>
            </xsl:call-template>
          </th>
          <th class="clCouleur2 clWidth200 clAlignRight clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Nombre'"/>
            </xsl:call-template>
          </th>
          <th class="clCouleur2 clWidth230 clAlignRight clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Montant1'"/>
            </xsl:call-template>           
              &#160;<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8" alt="symbole euro"/>)           
          </th>
        </tr>
        <xsl:if test="$Lang='FR'">
          <tr>
            <td class="clFond clWidth205 clAlignRight" >
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[1]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
            <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[1]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
            <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[1]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
          <tr>
             <td class="clFond clWidth205 clAlignRight">
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[2]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[2]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[2]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
          <tr>
            <td class="clFond clWidth205 clAlignRight">
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[3]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
            <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[3]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
            <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[3]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
          <tr>
             <td class="clFond clWidth205 clAlignRight">
              &#160;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[4]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[4]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[4]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="$Lang='UK'">
          <tr>
            <td class="clFond clWidth205 clAlignRight">
              &#160;<xsl:call-template name ="displayDateUKXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[1]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
           <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[1]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
            <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[1]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
          <tr>
             <td class="clFond clWidth205 clAlignRight">
              &#160;
              <xsl:call-template name ="displayDateUKXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[2]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[2]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[2]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
          <tr>
             <td class="clFond clWidth205 clAlignRight">
              &#160;<xsl:call-template name ="displayDateUKXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[3]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[3]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[3]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
          <tr>
             <td class="clFond clWidth205 clAlignRight">
              &#160;<xsl:call-template name ="displayDateUKXsl">
                <xsl:with-param name ="InputDate" select ="(../IMPAYE[4]/TRIM)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth200 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[4]/NBIPE)"/>
              </xsl:call-template>&#160;
            </td>
             <td class="clFond clWidth230 clAlignRight">
              <xsl:call-template name ="displayNumberXsl">
                <xsl:with-param name ="InputStringNumber" select ="(../IMPAYE[4]/MTIPE)"/>
              </xsl:call-template>&#160;
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="$tmp>'0'">
          <xsl:if test="not($NonResident='NR')">
            <tr>
              <td colspan="2" class="clWidth405"></td>
              <td class="clWidth230 clAlignRight">
                <a href="#nullepart" onclick="requestBDFInfos('29','','','',cstSimpleConfirm);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                </a>
              </td>
            </tr>
          </xsl:if>
          <xsl:if test="$NonResident='NR'">
            <tr>
              <td class="clWidth635" colspan="3">&#160;</td>
            </tr>
          </xsl:if>
        </xsl:if>
      </table>
      <a name="ancEvent"></a>
    </xsl:if>
  </xsl:template>

  <!--********************************************************************************************************************************************************************-->
  <!--TEMPLATE 7eme PAVE : EVENEMENT MARQUANT, DERNIER JUGEMENT-->

  <xsl:template match="EVMARQ">
    <xsl:if test="position()=1">
     <tr class="clAlignCenter">
        <td colspan="6" class="clCouleurGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_EveMar'"/>
          </xsl:call-template>
          <br />
          <xsl:call-template name="shim"/>
        </td>
      </tr>
      <tr>
        <td colspan="6" class="clCouleur2 clWidth255">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_DerEve'"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth20 clBoxSizing">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Le'"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth110 clBoxSizing">
          &#160;<xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(DATEVM)"/>
          </xsl:call-template>&#160;
        </td>
        <xsl:if test="EVMDO">
          <td class="clFond clWidth265 clBoxSizing" colspan="2">
            <xsl:apply-templates select="EVMDO"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EVMDO)">
          <td class="clFond clWidth505 clBoxSizing" colspan="4">
            <xsl:apply-templates select="EVMC|EVMCD|EVMCI|EVMD|EVMDC|EVMDO|EVME|EVMJ|EVMJM|EVMM|EVMR|EVMS|EVMV"/>
          </td>
        </xsl:if>
        <xsl:apply-templates select="IDENTS" mode="clFond"/>
      </tr>
      <xsl:call-template name="savoirSirenAbsorbant"/>
    </xsl:if>
    <xsl:if test="position()=2">
      <tr>
        <td class="clCouleur2 clWidth20 clBoxSizing">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Le'"/>
          </xsl:call-template>
        </td>
        <td class="clTexte clWidth110 clBoxSizing">
          &#160;<xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(DATEVM)"/>
          </xsl:call-template>&#160;
        </td>
        <xsl:if test="EVMDO">
          <td class="clTexte clWidth265 clBoxSizing" colspan="2">
            <xsl:apply-templates select="EVMDO"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EVMDO)">
          <td class="clTexte clWidth505 clBoxSizing" colspan="4">
            <xsl:apply-templates select="EVMC|EVMCD|EVMCI|EVMD|EVMDC|EVMDO|EVME|EVMJ|EVMJM|EVMM|EVMR|EVMS|EVMV"/>
          </td>
        </xsl:if>
        <xsl:apply-templates select="IDENTS" mode="clTexte"/>
      </tr>
      <xsl:call-template name="savoirSirenAbsorbant"/>
    </xsl:if>
    <xsl:if test="position()=last() and not(/FIBEN/PERSONNE/MODULE27/DIFF27/EVJUD) and not(//JUGEIND)">
      <tr>
        <td colspan="6">
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template name="savoirSirenAbsorbant">
    <xsl:if test="IDENTS">
      <xsl:if test="not($NonResident='NR')">         
        <tr>
           <td class="clWidth20 clBoxSizing">&#160;</td>
           <td class="clWidth110 clBoxSizing">&#160;</td>
           <td class="clWidth130 clBoxSizing">&#160;</td>
           <td class="clWidth135 clBoxSizing">&#160;</td>
           <td class="clWidth120 clHeight12 clBoxSizing">
            <a href="#nullepart" onclick="requestBDFInfos('27','','1','{IDENTS[1]}',cstSimpleConfirm);">
              <img align="middle" border="0" height="12" name="ev1" src="{$root}images/Commun/clignotant2.gif" width="85" alt="plus d'infos"/>
            </a>
          </td>
          <xsl:if test="IDENTS[2]">
            <td class="clWidth120 clHeight12 clBoxSizing">
              <a href="#nullepart" onclick="requestBDFInfos('27','','1','{IDENTS[2]}',cstSimpleConfirm);">
                <img align="middle" border="0" height="12" name="ev2" src="{$root}images/Commun/clignotant2.gif" width="85" alt="plus d'infos"/>
              </a>
            </td>
          </xsl:if>
          <xsl:if test="not(IDENTS[2])"> 
            <td class="clWidth125 clHeight12 clBoxSizing">&#160;</td>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="$NonResident='NR'">
        <tr>
          <td class="clWidth20 clBoxSizing">&#160;</td>
          <td class="clWidth110 clBoxSizing">&#160;</td>
          <td class="clWidth130 clBoxSizing">&#160;</td>
          <td class="clWidth135 clBoxSizing">&#160;</td>
          <td class="clWidth120 clBoxSizing">&#160;</td>
          <td class="clWidth120 clBoxSizing">&#160;</td>
        </tr>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="EVMARQ/IDENTS" mode="clFond">
    <td class="clFond clWidth120 clBoxSizing">
      <xsl:call-template name ="displaySirenXsl">
        <xsl:with-param name ="InputSiren" select ="(.)"/>
      </xsl:call-template>
    </td>
    <xsl:if test="position()=1 and position()=last()">
      <td class="clFond clWidth120 clBoxSizing">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="EVMARQ/IDENTS" mode="clTexte">
    <td class="clTexte clWidth120 clBoxSizing">
      <xsl:call-template name ="displaySirenXsl">
        <xsl:with-param name ="InputSiren" select ="(.)"/>
      </xsl:call-template>
    </td>
    <xsl:if test="position()=1 and position()=last()">
      <td class="clTexte clWidth120 clBoxSizing">&#160;</td>
    </xsl:if>
  </xsl:template>

  <xsl:template match="EVJUD">
    <xsl:if test="count(../EVMARQ)=0">
     <tr class="clAlignCenter">
        <td colspan="6"  class="clCouleurGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_EveMar'"/>
          </xsl:call-template>
          <br />
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="count(../EVMARQ)>0">
      <tr>
        <td colspan="6" class="clCouleur2">&#160;</td>
      </tr>
    </xsl:if>
    <tr>
      <td colspan="2" class="clCouleur2 clWidth130">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m27_DerJug'"/>
        </xsl:call-template>
      </td>
      <td class="clTexte clWidth125">&#160;</td>
      <td class="clTexte clWidth130">&#160;</td>
      <td class="clWidth125">&#160;</td>
      <td class="clWidth125 clAlignRight">&#160;</td>
    </tr>
    <tr>
      <td class="clCouleur2 clWidth20">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m27_Le'"/>
        </xsl:call-template>
      </td>
       <td class="clFond clWidth110">
        &#160;<xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(../EVJUD/DATEVJ)"/>
        </xsl:call-template>&#160;
      </td>
      <td colspan="4" class="clFond clWidth505">
        <xsl:apply-templates select="EVJAM|EVJAP|EVJCM|EVJCP|EVJCT|EVJCV|EVJDM|EVJDU|EVJEM|EVJFM|EVJFP|EVJGA|EVJGD|EVJGO|EVJGR|EVJHC|EVJHM|EVJIA|EVJIC|EVJIG|EVJIM|EVJIP|EVJIT|EVJLB|EVJLG|EVJLJ|EVJLM|EVJPA|EVJPC|EVJPM|EVJPO|EVJPV|EVJRC|EVJRD|EVJRG|EVJRJ|EVJRL|EVJRM|EVJRP|EVJRR|EVJRS|EVJSM|EVJAC|EVJCR|EVJOS|EVJOB|EVJPS|EVJRPS|EVJOD|EVJOT|EVJOP|EVJPT|EVJRT|EVJMC"/>
      </td>
    </tr>
    <xsl:if test="../EVJUD/DATECHJUG">
      <tr>
        <td colspan="2" class="clCouleur2 clWidth130">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Jusq'"/>
          </xsl:call-template>
        </td>
        <td class="clTexte clWidth125">
          <xsl:call-template name ="displayDateXsl">
            <xsl:with-param name ="InputDate" select ="(../EVJUD/DATECHJUG)"/>
          </xsl:call-template>
        </td>
        <td class="clTexte clWidth130"></td>
        <td class="clWidth125"></td>
        <xsl:if test="/FIBEN/PERSONNE/MODULE27/*//IDENTC">
          <xsl:if test="not($NonResident='NR')">
            <xsl:variable name="cotation" select="/FIBEN/PERSONNE/MODULE27/*//VALCOT"/>
            <xsl:if test="not($cotation='NS')">
              <td class="clWidth125 clAlignRight">
                <a href="#nullepart" onclick="requestBDFInfos('45','','1','{/FIBEN/PERSONNE/MODULE27/*//IDRENV}',cstSimpleConfirm);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                </a>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$NonResident='NR'">
            <td class="clWidth125 clAlignRight">&#160;</td>
          </xsl:if>
        </xsl:if>
        <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/*//IDENTC)">
          <xsl:if test="not($NonResident='NR')">
            <td class="clWidth125 clAlignRight">&#160;</td>
          </xsl:if>
          <xsl:if test="$NonResident='NR'">
            <td class="clWidth125 clAlignRight">&#160;</td>
          </xsl:if>
        </xsl:if>
      </tr>
    </xsl:if>
    <xsl:if test="not(../EVJUD/DATECHJUG)">
      <xsl:if test="not($NonResident='NR')">
        <xsl:variable name="cotation" select="/FIBEN/PERSONNE/MODULE27/*//VALCOT"/>
        <xsl:if test="not($cotation='NS')">
          <tr>
            <xsl:if test="/FIBEN/PERSONNE/MODULE27/*//IDENTC">
              <td colspan="6" class="clAlignRight">
                <a href="#nullepart" onclick="requestBDFInfos('45','','1','{/FIBEN/PERSONNE/MODULE27/*//IDRENV}',cstSimpleConfirm);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/*//IDENTC)">
              <td colspan="6" class="clAlignRight">
                <a href="#nullepart" onclick="requestBDFInfos('45','','1','',cstSimpleConfirm);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                </a>
              </td>
            </xsl:if>
          </tr>
        </xsl:if>
      </xsl:if>
      <xsl:if test="$NonResident='NR'">
        <tr>
          <xsl:if test="/FIBEN/PERSONNE/MODULE27/*//IDENTC">
            <td colspan="6" class="clAlignRight">&#160;</td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/PERSONNE/MODULE27/*//IDENTC)">
            <td colspan="6" class="clAlignRight">&#160;</td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="not(//JUGEIND)">
      <tr>
        <td colspan="6">
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template match="JUGEIND" mode="genTable">
    <xsl:if test="count(//EVMARQ)>0 or //EVJUD">
      <tr>
        <td colspan="6" class="clCouleur2">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="count(//EVMARQ)=0 and not(//EVJUD)">
     <tr class="clAlignCenter">
        <td colspan="6"  class="clCouleurGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_EveMar'"/>
          </xsl:call-template>
          <br />
          <xsl:call-template name="shim"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td class="clCouleur2" colspan="4">
        <xsl:apply-templates select="."/>
      </td>
      <td class="clFond clWidth290" colspan="2">
        &#160;<xsl:value-of select="."/>
      </td>
    </tr>
    <xsl:if test="not($NonResident='NR')">
      <xsl:variable name="cotation" select="/FIBEN/PERSONNE/MODULE27/*//VALCOT"/>
      <xsl:if test="not($cotation='NS')">
        <tr>          
          <td class="clWidth20">&#160;</td>
          <td class="clWidth110">&#160;</td>
          <td class="clWidth125">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth125">&#160;</td>
          <td class="clWidth125 clAlignRight">
            <a href="#nullepart" onclick="requestBDFInfos('45','','1','{.}',cstSimpleConfirm);">
              <img src="{$root}images/Commun/clignotant2.gif" width="90" height="12" border="0" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$NonResident='NR'">
      <tr>
        <td class="clWidth20">&#160;</td>
        <td class="clWidth110">&#160;</td>
        <td class="clWidth125">&#160;</td>
        <td class="clWidth130">&#160;</td>
        <td class="clWidth125">&#160;</td>
        <td class="clWidth125">&#160;</td>
      </tr>
    </xsl:if>
    <tr>
      <td colspan="6">
        <xsl:call-template name="shim"/>
      </td>
    </tr>
  </xsl:template>

  <!--********************************************************************************************************************************************************************-->
  <!--TEMPLATE 8eme PAVE : CONCOURS BANCAIRES A COURT TERME-->

  <xsl:template match="INFORISQUES">

    <tr>
      <td class="clTexte" colspan="6">
        <table class="clWidth635 clBorderCell">  
          <caption class="visually-hidden">SOURCES DE FINANCEMENT RECENSES AU COURS DES TREIZE DERNIERS MOIS</caption>
          <tr class="clAlignCenter">
            <td class="clCouleurGras">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_ConBan'"/>
              </xsl:call-template>
              <br/>
              <xsl:call-template name="shim"/>
            </td>
          </tr>
        </table>
      </td >
    </tr>
    <xsl:if test ="RISQ04">
      <tr>
        <td class="clTexte" colspan="6">
          <table class="clWidth635 clBorderCell" role="presentation">            
            <tr>
              <td class="clCouleur2 clWidth635">
                <xsl:call-template name="traduction">
                  <xsl:with-param name="code" select="'RISQ04'"/>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td class="clWidth635 clAlignRight clHeight12"></td>
            </tr>
          </table>
        </td>
      </tr>

    </xsl:if>
    <xsl:if test ="RISQ05">
      <tr>
        <td class="clTexte" colspan="6">
          <table class="clWidth635 clBorderCell" role="presentation">            
            <tr>
              <td class="clCouleur2 clWidth635">
                <xsl:call-template name="traduction">
                  <xsl:with-param name="code" select="'RISQ05'"/>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td class="clWidth635 clAlignRight clHeight12"></td>
            </tr>
          </table>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test ="RISQ06">
      <tr>
        <td class="clTexte" colspan="6">
          <table class="clWidth635 clBorderCell" role="presentation">          
            <tr>
              <td class="clCouleur2 clWidth635">                
                <xsl:call-template name="traduction">
                  <xsl:with-param name="code" select="'RISQ06'"/>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td class="clWidth635 clAlignRight clHeight12"></td>
            </tr>
          </table>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test ="RISQ07">
      <tr>
        <td class="clTexte" colspan="6">
          <table class="clWidth635 clBorderCell" role="presentation">
             <tr>
              <td class="clCouleur2 clWidth635">
                <xsl:call-template name="traduction">
                  <xsl:with-param name="code" select="'RISQ07'"/>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td class="clWidth635 clAlignRight clHeight12"></td>
            </tr>
          </table>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test ="RISQ08">
      <tr>
        <td class="clTexte" colspan="6">
          <table class="clWidth635 clBorderCell" role="presentation">             
            <tr>
              <td class="clCouleur2 clWidth635">
                <xsl:call-template name="traduction">
                  <xsl:with-param name="code" select="'RISQ08'"/>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td class="clWidth635 clAlignRight clHeight12"></td>
            </tr>
          </table>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test ="RISQ09">
      <tr>
        <td class="clTexte" colspan="6">
          <table class="clWidth635 clBorderCell" role="presentation">            
            <tr>
              <td class="clCouleur2 clWidth635">
                <xsl:call-template name="traduction">
                  <xsl:with-param name="code" select="'RISQ09'"/>
                </xsl:call-template>
              </td>
            </tr>
            <tr>
              <td class="clWidth635 clAlignRight clHeight12"></td>
            </tr>
          </table>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="not($NonResident='NR')">
      <xsl:if test="RISQ04|RISQ06|RISQ08">
        <tr>
          <td colspan="6" class="clWidth635 clAlignRight">
            <a href="#nullepart" onclick="requestBDFInfos('28|30|','','1','{IDENTS}',cstMultipleConfirm);">
              <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
            </a>
          </td>
        </tr>
      </xsl:if>
    </xsl:if>


  </xsl:template>
  <!--********************************************************************************************************************************************************************-->



  <!-- 01/2004 template supprim : plus besoin d'afficher la succursale dans IEC01 -->
  <xsl:template match="IEC01" mode="DisplayM27">
    <br/>
    <xsl:apply-templates select="."/>
  </xsl:template>

  <xsl:template name="genGraph27">
    <xsl:param name="ident"/>
    <xsl:param name="denom"/>
    <xsl:param name="nom"/>
    <xsl:param name ="prenom"/>
    <xsl:param name="nomconj"/>
    <xsl:param name="valcot"/>
    <xsl:param name ="segment"/>
    <xsl:param name="datcot"/>
    <xsl:param name="datexa"/>
    <xsl:param name="idrenv"/>
    <form action="Graphes.aspx" method="post" name="FormGraphes" target="_blank">
      <input name="familyNumber" type="hidden" value="1"/>
      <input name="moduleNumber" type="hidden" value="{/FIBEN/@MODDEM}"/>
      <xsl:element name="input">
        <xsl:attribute name="name">GrapheData</xsl:attribute>
        <xsl:attribute name="type">hidden</xsl:attribute>
        <xsl:attribute name="value">
          &lt;FIBEN MODDEM=&quot;<xsl:value-of select="FIBEN/@MODDEM"/>&quot; DATJOUR=&quot;<xsl:call-template name ="displayDateForGraph2">
            <xsl:with-param name ="InputDateForGraph" select ="FIBEN/@DATJOUR"/>
          </xsl:call-template>&quot; GRAPHE=&quot;1&quot;&gt;&lt;ident&gt;<xsl:value-of select="$ident"/>&lt;/ident&gt;	&lt;nom&gt;
          <xsl:if test="//EJ27/DENOM">
            <xsl:value-of select="//EJ27/DENOM"/>
          </xsl:if>
          <xsl:if test="//IDENTITE/NOM">
            <xsl:call-template name ="displayInLowerCaseXsl">
              <xsl:with-param name ="InputStringNom" select ="$nom"/>
              <xsl:with-param name ="InputStringPrenom" select ="$prenom"/>
            </xsl:call-template>
          </xsl:if>
          &lt;/nom&gt;&lt;nomconj&gt;<xsl:value-of select="$nomconj"/>&lt;/nomconj&gt;&lt;valcot&gt;<xsl:value-of select="$valcot"/>&lt;/valcot&gt;&lt;segment&gt;<xsl:value-of select="$segment"/>&lt;/segment&gt;&lt;datcot&gt;<xsl:value-of select="$datcot"/>&lt;/datcot&gt;&lt;datexa&gt;<xsl:value-of select="$datexa"/>&lt;/datexa&gt;&lt;graphe&gt;<xsl:if test="$condGraph1">
            &lt;serie&gt;	<xsl:for-each select="//BILAN27">
              &lt;val&gt;<xsl:value-of select="p2052FL|p209101"/>&lt;/val&gt;
            </xsl:for-each>&lt;/serie&gt;<xsl:if test="not((//BILAN27[1]/p2052FK = '0,00') and (//BILAN27[2]/p2052FK = '0,00') and (//BILAN27[3]/p2052FK = '0,00'))">
              &lt;serie&gt;<xsl:for-each select="//BILAN27">
                <xsl:if test="p2052FK/@ETAT='ND'">&lt;val&gt;0&lt;/val&gt;</xsl:if>
                <xsl:if test="not(p2052FK/@ETAT)">
                  &lt;val&gt;<xsl:value-of select="p2052FK"/>&lt;/val&gt;
                </xsl:if>
              </xsl:for-each>&lt;/serie&gt;
            </xsl:if>&lt;abcisse&gt;<xsl:for-each select="//BILAN27">
              &lt;val&gt;<xsl:call-template name ="displayDateXsl">
                <xsl:with-param name ="InputDate" select ="(@DATCLOT)"/>
              </xsl:call-template>&lt;/val&gt;
            </xsl:for-each>&lt;/abcisse&gt;
          </xsl:if>&lt;titre&gt;Chiffre d'affaires sur 3 exercices (en millions d'euros)&lt;/titre&gt;&lt;signet&gt;Chiffre d'affaires&lt;/signet&gt;&lt;/graphe&gt;&lt;graphe&gt;<xsl:if test="$condGraph2">
            &lt;serie&gt;<xsl:for-each select="//INFOIMPAYES/IMPAYE">
              &lt;val&gt;<xsl:value-of select="MTIPE"/>&lt;/val&gt;
            </xsl:for-each>&lt;/serie&gt;&lt;abcisse&gt;<xsl:for-each select="//INFOIMPAYES/IMPAYE">
              &lt;val&gt;<xsl:value-of select="concat(substring(TRIM,1,1),'T',substring(TRIM,2))"/>&lt;/val&gt;
            </xsl:for-each>&lt;/abcisse&gt;
          </xsl:if>&lt;titre&gt;Incidents de paiement effets au cours des 4 derniers trimestres (en euros)&lt;/titre&gt;&lt;signet&gt;Incidents de paiement&lt;/signet&gt;&lt;/graphe&gt;&lt;/FIBEN&gt;
        </xsl:attribute>
      </xsl:element>
    </form>
  </xsl:template>

  <xsl:template name="FONCDIR" >
    <xsl:if test="$NonResident='NR'">
      <xsl:if test="$Lang='FR'">
        <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDEI">
          <table class="clBorderCell clWidth635 clCouleur2">
            <tr>
              <td class="clWidth522 clAlignLeft">
                <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"></xsl:value-of>
              </td>

              <td class="clWidth103 clAlignRight">
                &#160;
              </td>
            </tr>

          </table>
          <xsl:call-template name="shim"/>
          <br/>
        </xsl:if>
        <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDPP">
          <table class="clBorderCell clWidth635 clCouleur2">
            <tr>
              <td class="clWidth522 clAlignLeft">
                <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDPP'])"></xsl:value-of>
              </td>

              <td class="clWidth103 clAlignRight">
                &#160;
              </td>
            </tr>

          </table>
          <xsl:call-template name="shim"/>
          <br/>
        </xsl:if>

        <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDEJ">
          <table class="clBorderCell clWidth635 clCouleur2">
            <tr>
              <td colspan="2" class="clWidth635 clAlignLeft">
                <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEJ'])"></xsl:value-of>
              </td>
            </tr>
            <tr>
              <td colspan="2" class="clWidth635 clAlignRight">
                &#160;
              </td>
            </tr>

          </table>
          <xsl:call-template name="shim"/>
          <br/>
        </xsl:if>
      </xsl:if>
      <xsl:if test="$Lang='UK'">
        <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDEI">
          <table class="clBorderCell clWidth635 clCouleur2">
            <tr>
              <td class="clWidth522 clAlignLeft">
                <xsl:value-of select="($dictionnaireUK/mot[@id='AUTRFDEI'])"></xsl:value-of>
              </td>
              <td class="clWidth103 clAlignRight">
                &#160;
              </td>
            </tr>

          </table>
          <xsl:call-template name="shim"/>
          <br/>
        </xsl:if>
        <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDPP">
          <table class="clBorderCell clWidth635 clCouleur2">
            <tr>
              <td class="clWidth522 clAlignLeft">
                <xsl:value-of select="($dictionnaireUK/mot[@id='AUTRFDPP'])"></xsl:value-of>
              </td>

              <td class="clWidth103 clAlignRight">
                &#160;
              </td>
            </tr>

          </table>
          <xsl:call-template name="shim"/>
          <br/>
        </xsl:if>

        <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDEJ">
          <table class="clBorderCell clWidth635 clCouleur2">
            <tr>
              <td colspan="2" class="clWidth635 clAlignLeft">
                <xsl:value-of select="($dictionnaireUK/mot[@id='AUTRFDEJ'])"></xsl:value-of>
              </td>
            </tr>
            <tr>
              <td colspan="2" class="clWidth635 clAlignRight">
                &#160;
              </td>
            </tr>

          </table>
          <xsl:call-template name="shim"/>
          <br/>
        </xsl:if>
      </xsl:if>
    </xsl:if>
    <xsl:if test="not($NonResident='NR')">
      <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDEI">
        <table class="clBorderCell clWidth635 clCouleur2">
          <tr>
            <td class="clWidth522 clAlignLeft">
              <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEI'])"></xsl:value-of>
            </td>

            <td class="clWidth103 clAlignRight">
              <a href="#nullepart" onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
                <img border="0" height="12"	src="{$root}images/Commun/clignotant2.gif" width="90"/>
              </a>
            </td>
          </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
      </xsl:if>
      <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDPP">
        <table class="clBorderCell clWidth635 clCouleur2">
          <tr>
            <td class="clWidth522 clAlignLeft">
              <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDPP'])"></xsl:value-of>
            </td>
            <td class="clWidth103 clAlignRight">
              <a href="#nullepart" onclick="requestBDFInfos('56','','','',cstSimpleConfirm);">
                <img border="0" height="12"	src="{$root}images/Commun/clignotant2.gif" width="90"/>
              </a>
            </td>
          </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
      </xsl:if>

      <xsl:if test="/FIBEN/PERSONNE/MODULE27/DIFF27/AUTRFDEJ">
        <table class="clBorderCell clWidth635 clCouleur2">
          <tr>
            <td colspan="2" class="clWidth635 clAlignLeft">
              <xsl:value-of select="($dictionnaire/mot[@id='AUTRFDEJ'])"></xsl:value-of>
            </td>
          </tr>
          <tr>
            <td colspan="2" class="clWidth635 clAlignRight">
              <a href="#nullepart" onclick="requestBDFInfos('51','','','',cstSimpleConfirm);">
                <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90"/>
              </a>
            </td>
          </tr>

        </table>
        <xsl:call-template name="shim"/>
        <br/>
      </xsl:if>
    </xsl:if>
  </xsl:template>
 
</xsl:stylesheet>
