<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
	<xsl:import href="../../Ressources/XSL/Commun_RALPH.xsl"/>   
<!-- IMPORTANT : commun_RALPH aprs Commun pour respecter l'ordre des surcharges -->
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="familyNumber" select="''"/>
  <xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
	<xsl:param name="menuHTML1"/>
	<xsl:param name="Lang" select="'FR'"/>
	<xsl:param name="codeLib" select="''"/>
	<xsl:param name="NonResident" select="''"/>


<!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr">
      <title>Module 07 - Recherche alphabtique</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="//RECHDEN"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <link rel="stylesheet" href="{$root}Ressources/CSS/Commun.css" />
        <xsl:element name="link">
          <xsl:attribute name="rel">stylesheet</xsl:attribute>
          <xsl:attribute name="href">
            <xsl:value-of select="$root"/>Ressources/CSS/risque.css
          </xsl:attribute>
        </xsl:element>
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
          <xsl:with-param name="type" select="'ralph'" />
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <xsl:call-template name="insertClientScripts"/>
        <table class="maincontainer horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module 07 - Recherche alphabtique</caption>
          <xsl:call-template name="genLigneConfidentiel" />
          <xsl:apply-templates select="/FIBEN/ERREUR">
            <xsl:with-param name="alerte" select="false()"/>
          </xsl:apply-templates>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
              <td colspan="2"  class="clHeight10"></td>
            </tr>
            <tr>
              <td class="clWidth64"></td>
              <td  class="clCouleur2 clValignTop clWidth739">
                <table class="clWidth635 clBorderCell" role="presentation">
                  <tr>
                    <td class="clCouleurGras clValignTop clWidth635">

                      <xsl:call-template name="tradlib">
                        <xsl:with-param name="Lang" select="$Lang"/>
                        <xsl:with-param name="codeLib" select="'m07_VotRech'"/>
                      </xsl:call-template>
                    </td>
                  </tr>
                </table>
                <table class="clWidth635 clBorderCell" role="presentation">
                  <tr>
                    <td class="clValignTop">
                      <xsl:apply-templates select="/FIBEN/DEMANDE"/>
                    </td>
                  </tr>
                </table>
                <xsl:apply-templates select="//IRECH|//SCR|//IST07|//U051|//U052|//U057" mode="genLib"/>
                <xsl:if test="not(//IRECH|//SCR|//U051|//U052|//U057)">
                  <!--Partie Spcifique demande simple-->
                  <table  class="clWidth739 clBorderCell" role="presentation">
                    <xsl:call-template name="shim"/>
                    <tr>
                      <td>
                        <table title="Nombre de rponses" class="clWidth635 clBorderCell">
                          <tr>                            
                            <td class="clCouleurGras clAlignCenter clValignMiddle">
                              <xsl:call-template name="tradlib">
                                <xsl:with-param name="Lang" select="$Lang"/>
                                <xsl:with-param name="codeLib" select="'m07_Reponses'"/>
                              </xsl:call-template>
                              (<xsl:value-of select="/FIBEN/nbReponsesAffichees"/>
                              <xsl:if test ="(/FIBEN/nbReponsesTotales) != (/FIBEN/nbReponsesAffichees)">
                                &#160;
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m07_RepDisp'"/>
                                </xsl:call-template>&#160;
                                <xsl:value-of select="/FIBEN/nbReponsesTotales"/>
                              </xsl:if>)
                            </td>
                          </tr>
                          <xsl:if test ="(/FIBEN/nbReponsesTotales) > 150">
                            <tr>                             
                              <td class="clCouleurGras clValignMiddle clAlignCenter">
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m07_PlusInfo'"/>
                                </xsl:call-template>
                              </td>
                            </tr>
                          </xsl:if>
                          <br />
                        </table>
                        <!-- ********************** partie reponse ***************************-->
                        <xsl:if test ="(/FIBEN/nbReponsesTotales) > 0">
                          <table class="clWidth739 clBorderCell">
                            <xsl:call-template name="shim"/>
                            <tr>
                              <td colspan="4" class="clCouleur2 clWidth600">
                                &#160;
                                <xsl:call-template name="tradlib">
                                  <xsl:with-param name="Lang" select="$Lang"/>
                                  <xsl:with-param name="codeLib" select="'m07_CliSurRep'"/>
                                </xsl:call-template> >>
                              </td>
                              <td class="clWidth139">
                                <a href="#nullepart" onclick="requestStatic('',cstExportRalph,'')">
                                  <img src="{$root}Images/Boutons/Excel.jpg" border="0" alt="lien vers fichier Excel" />
                                </a>
                              </td>
                            </tr>
                            <tr>
                              <td colspan="5">&#160;</td>
                            </tr>

                            <xsl:apply-templates select="/FIBEN/reponses/ReponseFibenDetail">
                              <xsl:with-param name ="nbReponsesAffichees" select ="/FIBEN/nbReponsesAffichees"></xsl:with-param>
                            </xsl:apply-templates>

                          </table>
                        </xsl:if>
                        <table class="clWidth635 clBorderCell">
                          <tr>
                            <td colspan="5">
                              <xsl:call-template name="shim"/>
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </xsl:if>
              </td>
            </tr>
          </xsl:if>
          
        </table>
        <xsl:call-template name="genBasPage"/>        
        
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>

			