﻿Imports System.Xml
Imports System.Diagnostics
Imports BDF.POBI.FIBEN.BAL
Imports Serilog


Partial Class modules_graphes
    Inherits System.Web.UI.Page

    Private Shared ReadOnly Logger As ILogger = Log.Logger.ForContext(Of modules_graphes)

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'Sylvie : dec 2015 - tous modules de meme couleur (comme famille risques actuelle)
        Dim sFamily As String = Constantes.cstFRisk.ToString()
        Dim sModule As String = Request.Form("moduleNumber")
        Dim sXMLResponse As String = Request.Form("GrapheData")

        Dim oXMLData As New XmlDocument

        Try
            If Not String.IsNullOrEmpty(sXMLResponse) Then

                sXMLResponse = Replace(sXMLResponse, "&quot;", """")

                oXMLData.LoadXml(sXMLResponse)
            Else
                Logger.Error("Pas de données pour construire le graphe")
            End If
        Catch ex As Exception
            Throw New ExceptionFiben("modules_graphes.Page_Load(); Flux XML : " & sXMLResponse, ex.Message)
        End Try

        Try
            Dim xslt As New XslTransform(Context)
            'Sylvie : dec 2015 - tous modules de meme couleur (comme famille risques actuelle)
            sFamily = Constantes.cstFRisk.ToString()
            xslt.TransformXMLToGraph(oXMLData, sModule, sFamily)
        Catch ex As Exception
            Throw New ExceptionFiben("modules_graphes.Page_Load(); Transformation du modulue : " & sModule, ex.Message)
        End Try

    End Sub
End Class
