<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="root" select="''"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="moduleTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
		
  <xsl:template match="/">
  <html>
    <head>
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
     <link rel="stylesheet" href="/FIBEN/Ressources/CSS/Commun.css"/>
      <link rel="stylesheet" href="/FIBEN/Ressources/CSS/newhome.css"/>
      <link rel="stylesheet" href="/FIBEN/Ressources/CSS/Risque.css"/>
      <link rel="stylesheet" href="/FIBEN/Ressources/CSS/homepage.css"/>
      <title>Informations sur la segmention historise </title>
    </head>
    <body bgcolor="#ffffff" >
      <table width="635" border="0" cellspacing="0" cellpadding="0">
        <tr align="center">
          <td class="clCouleur2">EXPLICATION DE LA SEGMENTATION</td>
        </tr>        
      </table>
      <img width="635" height="1" vspace="8" src="/FIBEN/Images/risque/shim_bleu.gif"/>     
      <xsl:choose>
        <xsl:when test="(segprec/elementS)='1'">
          <xsl:apply-templates select="segprec/elementS"/>
        </xsl:when>
        <xsl:otherwise >
          <table width="635" border="0" cellspacing="0" cellpadding="0">
            <tr>
              <td>
                <img src="/FIBEN/Images/risque/danger.gif" width="18" height="18" border="0"/>
              </td>
              <td width="612" class="clStyleDescriptif">
                <span>
                  Plus le nombre de croix est important, plus la contribution pse ngativement sur le calcul de
                  la segmentation.
                </span>
              </td>
            </tr>            
          </table>         
          <xsl:apply-templates select="segprec/elementI"/>
          <xsl:apply-templates select="segprec/elementD"/>
          <xsl:apply-templates select="segprec/elementA"/>
          <xsl:apply-templates select="segprec/elementN"/>
          <xsl:apply-templates select="segprec/elementC"/>
          <xsl:apply-templates select="segprec/elementB"/>
        </xsl:otherwise>
      </xsl:choose>

      <img width="635" height="1" vspace="8" src="/FIBEN/Images/risque/shim_bleu.gif"/>

    </body>
  </html>
</xsl:template>

  <xsl:template match="elementS">    
    <table width="635" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td>
              <img src="/FIBEN/Images/risque/danger.gif" width="18" height="18" border="0"/>
            </td>
            <td width="612" class="clStyleDescriptif">
              L'ensemble des variables prsentes permet l'attribution de la segmentation 1, la plus favorable.
            </td>
          </tr>
        </table>
  </xsl:template>

  <xsl:template match="elementI">
    <img width="635" height="1" vspace="8" src="/FIBEN/Images/risque/shim_bleu.gif"/>
    <table width="635" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="100%" class="clTexte" colspan="2"></td>
      </tr>
      <tr>
        <td width="175" class="clCouleur2">
          IMPAYS
        </td>
        <td width="459" class="clGrasFond">
          <xsl:value-of select="."/>
        </td>
      </tr>
    </table>
    <img width="635" height="1" vspace="8" src="/FIBEN/Images/risque/shim_bleu.gif"/>
  </xsl:template>
  
  <xsl:template match="elementD">
    <table width="635" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="175" class="clCouleur2" colspan="2">
          DESCRIPTIF
        </td>
        <td width="459" class="clGrasFond">
          <xsl:value-of select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>
  
  <xsl:template match="elementA">
    <table width="635" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="20">&#160;</td>
        <td width="155" class="clTexte">
          Age de l'entreprise:
        </td>
        <td width="459" class="clTexte">
          <xsl:value-of select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="elementN">
    <table width="635" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="20">&#160;</td>
        <td width="155" class="clTexte">
          Secteur d'activit:
        </td>
        <td width="459" class="clTexte">
          <xsl:value-of select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>
  
  <xsl:template match="elementC">
    <table width="635" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="20">&#160;</td>
        <td width="155" class="clTexte">
          Catgorie juridique:
        </td>
        <td width="459" class="clTexte">
          <xsl:value-of select="."/>
        </td>
      </tr>
    </table>
    <img width="635" height="1" vspace="8" src="/FIBEN/Images/risque/shim_bleu.gif"/>
  </xsl:template>

  <xsl:template match="elementB">
    <table width="635" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="175" class="clCouleur2">
          ENDETTEMENT BANCAIRE
        </td>
        <td width="459" class="clGrasFond">
          <xsl:value-of select="."/>
        </td>
      </tr>
    </table>   
  </xsl:template>         

</xsl:stylesheet>
