<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>

  <xsl:variable name="dictionnaire" select="document('../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>  
  <xsl:template match="/">
    <html>
      <head>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/Commun.css"/>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/homepage.css"/>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/newhome.css"/>
        <title>Informations sur les risques</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      </head>
      <body bgcolor="#ffffff" topmargin="0">
        <table width="635" border="0" cellspacing="0" cellpadding="0">

          <!--Concours bancaires => Concours Individuels et participation en compte collectif-->
          <xsl:apply-templates select="informationrisque/CO/CO1"/>
          <xsl:apply-templates select="informationrisque/CO/CO2"/>
          <xsl:apply-templates select="informationrisque/CC/CC1"/>
          <xsl:apply-templates select="informationrisque/CC/CC2"/>        
          <xsl:apply-templates select="informationrisque/AF/AF1"/>            
          <xsl:apply-templates select="informationrisque/CA/CA1"/> 
          <xsl:apply-templates select="informationrisque/CA/CA2"/>
          <xsl:apply-templates select="informationrisque/CA/CA3"/>
          <xsl:apply-templates select="informationrisque/TETA/TETA1"/>
          <xsl:apply-templates select="informationrisque/TETA/TETA2"/>
          <xsl:apply-templates select="informationrisque/TETA/TETA3"/>
          <xsl:apply-templates select="informationrisque/BM/BM1"/>
          <xsl:apply-templates select="informationrisque/BM/BM2"/>
          <xsl:apply-templates select="informationrisque/BI/BI1"/>
          <xsl:apply-templates select="informationrisque/BI/BI2"/>         
          <xsl:apply-templates select="informationrisque/IT/IT1"/>         
          <xsl:apply-templates select="informationrisque/OC/OC1"/>
          <xsl:apply-templates select="informationrisque/OC/OC2"/>
          <xsl:apply-templates select="informationrisque/OC/OC3"/>
          <xsl:apply-templates select="informationrisque/OD/OD1"/>
          <xsl:apply-templates select="informationrisque/AC/AC1"/>
         
          <!--Concours dclars (CD) par des socits de gestion de portefeuille, entreprise d'assurance, mutuelles, institution de prvoyance-->
          <xsl:apply-templates select="informationrisque/CCCD/CCCD1"/>
          <xsl:apply-templates select="informationrisque/CCCD/CCCD2"/>
          <xsl:apply-templates select="informationrisque/CACD/CACD1"/>
          <xsl:apply-templates select="informationrisque/CACD/CACD2"/>
          <xsl:apply-templates select="informationrisque/TETACD/TETACD1"/>
          <xsl:apply-templates select="informationrisque/TETACD/TETACD2"/>
          <xsl:apply-templates select="informationrisque/BMCD/BMCD1"/>
          <xsl:apply-templates select="informationrisque/BICD/BICD1"/>
          <xsl:apply-templates select="informationrisque/ITCD/ITCD1"/>
          <xsl:apply-templates select="informationrisque/CRCD/CRCD1"/>          
          <xsl:apply-templates select="informationrisque/OCCD/OCCD1"/>
          <xsl:apply-templates select="informationrisque/OCCD/OCCD2"/>          
          <xsl:apply-templates select="informationrisque/ODCD/ODCD1"/>
          <xsl:apply-templates select="informationrisque/ACCD/ACCD1"/>  

        </table>        
      </body>
    </html>
  </xsl:template>
  

 <xsl:template match="CC1">   
     <tr>
       <td class="cltitre3" colspan="3">
         <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
         <br/>
         <div class="clCouleur2" align="center">
           CR&#201;ANCES COMMERCIALES<br/>
         </div>
         <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
       </td>
     </tr>
     <tr>
       <td width="80" class="cltitre5" valign="top" align="center"> CC</td>
       <td width="555" class="cltitre5">
         <xsl:variable name="value" select="."/>
         <xsl:copy-of select="$dictionnaire/CC/mot[@id=$value]"/>
       </td>
     </tr>
     <tr>
       <td width="80" class="cltitre5" height="10"></td>
       <td width="555" class="cltitre5" height="10"></td>
     </tr>  
  </xsl:template>
  

 <xsl:template match="CC2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//CC/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
   </tr>  
  </xsl:template>
  
  <xsl:template match="CO1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          COMPTES ORDINAIRES D&#201;BITEURS<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> CO</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CO/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>   
  </xsl:template>  

 <xsl:template match="CO2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//CO/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
   </tr>
  </xsl:template>
  
  <xsl:template match="CA1">
     <tr>
       <td class="cltitre3" colspan="3">
         <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
         <br/>
         <div class="clCouleur2" align="center">
           AUTRES CR&#201;DIT &#193; COURT TERME
         </div>
         <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
       </td>
     </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> CA</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>
  

 <xsl:template match="CA2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//CA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
   </tr>
  </xsl:template>
  
 <xsl:template match="CA3">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//CA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
   </tr>
  </xsl:template>

<xsl:template match="AF1">
  <tr>
    <td class="cltitre3" colspan="3">
      <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      <br/>
      <div class="clCouleur2" align="center">
        AFFACTURAGE
      </div>
      <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
    </td>
  </tr>
  <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> AF</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/AF/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="TETA1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          MOYEN ET LONG TERME
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> TE+TA</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/TETA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>


  <xsl:template match="TETA2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//TETA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="TETA3">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//TETA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="BM1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DIT-BAILS - MOBILIERS
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> BM</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/BM/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>


  <xsl:template match="BM2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//BM/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="BI1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DIT-BAILS - IMMOBILIERS
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> BI</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/BI/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>


  <xsl:template match="BI2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//BI/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="IT1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          TITRIS&#201;S
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> IT</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/IT/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="OC1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          PARTIE DISPONIBLE DES CR&#201;DITS MOBILISABLES
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> OC</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/OC/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>


  <xsl:template match="OC2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//OC/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="OC3">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//OC/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="OD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DITS DOCUMENTAIRES
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> OD</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/OD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="AC1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          ENGAGEMENTS DE GARANTIE
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> AC</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/AC/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>
  
   <xsl:template match="CCCD1">   
     <tr>
       <td class="cltitre3" colspan="3">
         <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
         <br/>
         <div class="clCouleur2" align="center">
           CR&#201;ANCES COMMERCIALES<br/>
         </div>
         <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
       </td>
     </tr>
     <tr>
       <td width="80" class="cltitre5" valign="top" align="center"> CC</td>
       <td width="555" class="cltitre5">
         <xsl:variable name="value" select="."/>
         <xsl:copy-of select="$dictionnaire/CCCD/mot[@id=$value]"/>
       </td>
     </tr>
     <tr>
       <td width="80" class="cltitre5" height="10"></td>
       <td width="555" class="cltitre5" height="10"></td>
     </tr>  
  </xsl:template>
  

 <xsl:template match="CCCD2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//CCCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
   </tr>  
  </xsl:template>
  
  <xsl:template match="CACD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          AUTRES CR&#201;DITS &#193; COURT TERME<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> CA</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CACD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>   
  </xsl:template>  

 <xsl:template match="CACD2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>      
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//CACD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>     
      <td width="555" class="cltitre5" height="10"></td>
   </tr>
  </xsl:template>

  <xsl:template match="TETACD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          MOYEN ET LONG TERME<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> TE+TA</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/TETACD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="TETACD2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//TETACD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="BMCD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DIT-BAILS - MOBILIERS<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> BM</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/BMCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="BICD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DIT-BAILS - IMMOBILIERS<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> BI</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/BICD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="ITCD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DITS TITRIS&#201;S<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> IT</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/ITCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="CRCD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DITS REPRIS<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> CR</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CRCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="OCCD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          PARTIE DISPONIBLE DES CR&#201;DITS MOBILISABLES<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> OC</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/OCCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="OCCD2">
    <tr>
      <td width="80" class="cltitre5" valign="top">&#160;</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire//OCCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>  

  <xsl:template match="ODCD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          CR&#201;DITS DOCUMENTAIRES<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> OD</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/ODCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="ACCD1">
    <tr>
      <td class="cltitre3" colspan="3">
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
        <br/>
        <div class="clCouleur2" align="center">
          ENGAGEMENTS DE GARANTIE<br/>
        </div>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" valign="top" align="center"> AC</td>
      <td width="555" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/ACCD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="80" class="cltitre5" height="10"></td>
      <td width="555" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>
  
  
</xsl:stylesheet>
