<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>

  <xsl:variable name="dictionnaire" select="document('../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
  <xsl:template match="/">
    <html>
      <head>
        <link rel="stylesheet" href="/inet2/Ressources/CSS/newhome.css"/>
        <link rel="stylesheet" href="/inet2/Ressources/CSS/commun.css"/>
        <title>Informations libell</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      </head>
      <body bgcolor="#ffffff" topmargin="0">
        <table width="450" border="0" cellspacing="0" cellpadding="0" >
          <xsl:choose>
            <xsl:when test="(informationlibelle/CODE/Codeacceptmotif)">
              <xsl:apply-templates select="informationlibelle/CODE/Codeacceptmotif"/>
            </xsl:when>
            <xsl:when test="(informationlibelle/CODE/Segmentation)">
              <xsl:apply-templates select="informationlibelle/CODE/Segmentation"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="informationlibelle/CODE"/>
            </xsl:otherwise>
          </xsl:choose>
        </table>
      </body>
    </html>
  </xsl:template>


  <xsl:template match="Codeacceptmotif">
    <xsl:variable name="value" select="."/>
    <tr valign="middle" align="center">
      <td class="cltitre7" width="400">
        <br/>
        <xsl:copy-of select="$dictionnaire//mot[@id=$value]/text()"/>
        <br/>
      </td>
    </tr>
  </xsl:template>
  
  <xsl:template match="Segmentation">    
        <tr valign="middle" align="center" class="accueil">
          <td class="cltitre7" width="400">
            <br/>
            Pour plus d'infos, consultez le site utilisateur FIBEN
        </td>
        </tr>       
  </xsl:template>
 
  <xsl:template match="CODE">
    <xsl:variable name="value" select="."/>
    <xsl:choose>
      <xsl:when test ="$value = 'LIBCOTEHJ'">
        <tr valign="middle" align="center" class="accueil">
          <td class="cltitre5" width="400">
            <br/>
            Attention: les cotes d'activit H et J antrieures au 11 janvier 2025
          </td>
        </tr>
        <tr valign="middle" align="center" class="accueil">
          <td class="cltitre5" width="400">
            correspondent  l'ancien seuil de cotation. Celui-ci a t relev  1,25 MEUR.
          </td>
        </tr>
        <tr valign="middle" align="center" class="accueil">
          <td class="cltitre5" width="400">
            Pour plus d'infos, consultez le site utilisateur FIBEN
          </td>
        </tr>
        <xsl:copy-of select="$dictionnaire//mot[@id=$value]/text()"/>
      </xsl:when>
      <xsl:otherwise>
        <tr valign="middle" align="center" class="accueil">
          <td class="cltitre5" width="400">
            <br/>

            <xsl:copy-of select="$dictionnaire//ssclasse[@id=$value]/text()"/>
            <br/>
          </td>
        </tr>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


</xsl:stylesheet>
