<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../Ressources/XSL/Commun.xsl"/>
	<xsl:import href="../Ressources/XSL/Graphe_gen.xsl"/>
  <xsl:import href="../Ressources/XSL/Graphe_mOR.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
  <xsl:param name="root" select="''"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="moduleTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>


<xsl:template match="/">
		<html>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident" select="/FIBEN/ident"/>
			</xsl:call-template>
			<body bgcolor="#ffffff" ><a name="ancHaut"></a>
			<table class="mainmodule horizontal-auto" border="0" cellspacing="0" cellpadding="0">
				<tr> 
					<td width="636" class="clCouleur2" valign="top">
						<xsl:call-template name="genEnTete">
							<xsl:with-param name="ident" select="/FIBEN/ident"/>
							<xsl:with-param name="nom" select="/FIBEN/nom"/>
					 		<xsl:with-param name="nomconj" select="/FIBEN/nomconj"/>
							<xsl:with-param name="datexa" select="/FIBEN/datexa"/>  
							<xsl:with-param name="idrenv" select="/FIBEN/idrenv"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr><td width="636" valign="top" /></tr>
				<tr><td width="636" valign="top" /></tr>
        <!-- dans le fichier xml : prsence jusqu' 13 fois la balise <graphe>
        Dans le cas particulier o <ICB01> est prsent dans le flux MVS, la balise <graphe> est
        prsente une seule fois pour le graphe13 (le chemin du fichier graphe.aspx est dtermin
        par le numro de position de cette balise : pour le graphe 13 on appelait graphe1.aspx )-->
        <xsl:choose>
          <xsl:when test="(FIBEN/@GRAPHE mod 13 = 0)">
            <xsl:apply-templates select="FIBEN/graphe" mode="grapheOR"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="FIBEN/graphe" />
          </xsl:otherwise>
        </xsl:choose>
       
				
		  </table>
      <xsl:call-template name="genBasPage"/>  
		</body>
	</html>
</xsl:template>

</xsl:stylesheet>



	