<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../Ressources/XSL/Commun.xsl"/>
	<xsl:import href="../Ressources/XSL/Graphe_gen.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
  <xsl:param name="root" select="''"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="moduleTitle" select="''"/>
	<xsl:param name="nextModule" select="''"/>
	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
	<xsl:param name="valcot" select="/FIBEN/valcot"/>


<xsl:template match="/">
		<html>
			<xsl:call-template name="genHead">
				<xsl:with-param name="ident" select="/FIBEN/ident"/>
			</xsl:call-template>
			<body bgcolor="#ffffff" ><a name="ancHaut"></a>
			<table class="mainmodule horizontal-auto" border="0" cellspacing="0" cellpadding="0">
				<tr> 
					<td width="636" class="clCouleur2" valign="top">
						<table width="635" border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td width="617" align="left" valign="top" class="clCouleur1">
									<br />
									<xsl:value-of disable-output-escaping="yes" select="$dictionnaire/titre[@module=$moddem]"/>

									<xsl:if test="/FIBEN/@GRAPHE"> - Graphique(s)<br />
										<xsl:if test="/FIBEN/typeM30 = 'DIFF30'">
											(Analyse sur groupe consolid)
										</xsl:if>
										<xsl:if test="/FIBEN/typeM30 = 'DIFF30LF'">
											(Analyse sur liens de participation)
										</xsl:if>
									</xsl:if>
								</td>
								<td width="18" align="center" valign="middle">
									<img src="{$root}Images/risque/numero_{/FIBEN/@MODDEM}.gif" width="18" height="18" />
								</td>
							</tr>
						</table>
						<br/>
					<xsl:call-template name="genIdentification">
						<xsl:with-param name="ident" select="/FIBEN/ident"/>
						<xsl:with-param name="nom" select="/FIBEN/nom"/>
						<xsl:with-param name="nomconj" select="/FIBEN/nomconj"/>
						<xsl:with-param name="valcot" select="$valcot"/>
						<xsl:with-param name="datcot" select="/FIBEN/datcot"/>
						<xsl:with-param name="datexa" select="/FIBEN/datexa"/>
						<xsl:with-param name="idrenv" select="/FIBEN/idrenv"/>						
					</xsl:call-template>
					<xsl:if test="$valcot and /FIBEN/@MODDEM!=37 and /FIBEN/@MODDEM!=70 and /FIBEN/@MODDEM!=72 and not(/FIBEN/@GRAPHE)">
						<img src="{$root}Images/Commun/shim.gif" width="545" height="12" border="0" /><a href="#nullePart" onclick="requestBDFInfos('37','','{$familyNumber}','',cstSimpleConfirm);"><img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" border="0" /></a><br/>
					</xsl:if>
					<xsl:apply-templates select="/FIBEN/PERSONNE/IDNOUV"/>
					<xsl:apply-templates select="/FIBEN/PERSONNE/ENTMORT"/>
					<xsl:apply-templates select="/FIBEN/PERSONNE/LIEU"/>
					<xsl:apply-templates select="/FIBEN/RALPH/DEMANDE"/>
					</td>
				</tr>
				<xsl:apply-templates select="FIBEN/graphe"/>
				
		  </table>
      <xsl:call-template name="genBasPage"/>  
		</body>
	</html>
</xsl:template>


</xsl:stylesheet>
