<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
					              xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../Ressources/XSL/Commun.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes" />
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="root" select="''"/>
  <xsl:variable name="dictionnaire" select="document('../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
  <xsl:variable name="dictionnaireUK" select="document('../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>FIBEN</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <script language="JavaScript" src="{$root}Ressources/JavaScript/commun.js">
          <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
        </script>
        <script language="javascript" charset="iso-8859-1" src="{$root}Ressources/JavaScript/newhome.js">
          <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
        </script>
        <link rel="stylesheet" href="{$root}Ressources/CSS/Commun.css"/>
        <link rel="stylesheet" href="{$root}Ressources/CSS/homepage.css"/>
        <link rel="stylesheet" href="{$root}Ressources/CSS/newhome.css"/>
      </head>

      <body bgcolor="#ffffff" >
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root" />
          <xsl:with-param name="type" select="'ralph'" />
        </xsl:call-template>
        <div id="root" class="maincontainer horizontal-auto"  >
          <div class="clBandeauBoutons1 couleurBleu" id="menuModules">
            <ul id="lstBoutonsFamillesStd" class="lstBoutonsFamilles ">
            </ul>
          </div>
          <div id="menuContextuel" class="clBandeauBoutons2 coulBleu arrondi">
            <span class="clMessErreur">
              <xsl:if test="$langage='FR'">
                <xsl:copy-of select="$dictionnaire/mot[@id='U500']"/>
              </xsl:if>
              <xsl:if test="$langage='UK'">
                <xsl:copy-of select="$dictionnaireUK/mot[@id='U500']"/>
              </xsl:if>
            </span>
          </div>
        </div>

        <div id="divMessageErr" class="clHauteurMini  horizontal-auto  clContenuMaster colorBodyNewHome">
          <xsl:apply-templates select="//PBTECH"/>
        </div>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="PBTECH">
    <span class=" cltitre16 clTitreBleu clpositionMessage">
      <xsl:if test="$langage='FR'">
        <xsl:copy-of select="$dictionnaire/mot[@id='MESSUPTECH']"/>
      </xsl:if>
      <xsl:if test="$langage='UK'">
        <xsl:copy-of select="$dictionnaireUK/mot[@id='MESSUPTECH']"/>
      </xsl:if>
      <br /><br />
    </span>
    <div class=" cltitre16 clpositionMessage">
      <xsl:value-of select="."/>
    </div>
  </xsl:template>


</xsl:stylesheet>
