<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'UK'"/>
	
	<xsl:variable name="dictionnaire" select="document('../Ressources/XML/DicoCotationUK.xml')/dictionnaire"/>
  <xsl:variable name="dicolib" select="document('../Ressources/XML/DicoLibelleUK.xml')/dictionnaire"/>
<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" href="/FIBEN/Ressources/CSS/Commun.css"/>
				<link rel="stylesheet" href="/FIBEN/Ressources/CSS/homepage.css"/>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/newhome.css"/>
				<title>Informations gnrales sur la cotation</title>
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
			</head>
			<body bgcolor="#ffffff" topmargin="0">
			<table width="635" border="0" cellspacing="0" cellpadding="0" >
				<xsl:if test="cotation">
				<tr> 
					<td class="cltitre3" colspan="3"><img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/><br/>
						<div class="clCouleur2" align="center">GENERAL INFORMATION ABOUT THE RATING<br/></div>
					      <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
					</td>
				</tr>
				</xsl:if>
	
				
				<xsl:apply-templates select="cotation/CA"/>
				<xsl:apply-templates select="cotation/CC"/>
         <xsl:apply-templates select="cotation/ND"/>
		<!--	<xsl:apply-templates select="cotation/CP"/>    -->	
				<xsl:apply-templates select="cotation/CD"/>
				<xsl:apply-templates select="cotation/CE"/>
			  	
			

			  	<xsl:if test="cotation">
            <xsl:if test="not(cotation/ND)">
			  			<tr> 
							<td colspan="3" class="cltitre5"><img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/><br/>
								<xsl:value-of select="$dicolib/mot[@id='MESSINFO37']"/><br/>
			      				<img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
							</td>
						</tr>
            </xsl:if>
				</xsl:if>
			</table>
		</body>
	</html>
</xsl:template>

<xsl:template match="CA">
	<tr>
		<td class="cltitre5" width="119" valign="top"> Level of activity</td>
		<td class="cltitre5" width="30" align="left" valign="top"><xsl:value-of select="."/></td>
		<td width="486" class="cltitre5"><xsl:variable name="value" select="."/><xsl:copy-of select="$dictionnaire/CA/mot[@id=$value]"/></td>
	</tr>
	<tr> 
		<td height="10" class="cltitre5" ></td>
		<td height="10" class="cltitre5" ></td>
		<td height="10" class="cltitre5"></td>
	</tr>
</xsl:template>

<xsl:template match="CC">
	<tr> 
		<td width="119" class="cltitre5" valign="top"> Credit rating</td>
		<td width="30" class="cltitre5" valign="top" align="left"><xsl:value-of select="."/></td>
		<td width="486" class="cltitre5"><xsl:variable name="value" select="."/><xsl:copy-of select="$dictionnaire/CC/mot[@id=$value]"/></td>
	</tr>
	<tr>
		<td width="119" class="cltitre5" height="10"></td>
		<td width="20" class="cltitre5" align="left" height="10"></td>
		<td width="496" class="cltitre5" height="10"></td>
	</tr>
</xsl:template>
  
  <xsl:template match="ND">
    <tr>
      <td width="250" class="cltitre5" valign="top" align="right"><xsl:value-of select="."/>&#160;:&#160;</td>
      <td width="385" class="cltitre5"><xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/ND/mot[@id=$value]"/></td>
    </tr>
    <tr>
      <td class="cltitre3" colspan="3">
        <br/>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>

  </xsl:template>


<!--xsl:template match="CP">
	<tr>
		<td width="119" class="cltitre3" valign="top"> Cote de paiement</td>
		<td width="20" class="cltitre3" valign="top" align="left"><xsl:value-of select="."/></td>
		<td width="496" class="cltitre3"><xsl:variable name="value" select="."/><xsl:copy-of select="$dictionnaire/CP/mot[@id=$value]"/></td>
	</tr>
</xsl:template-->


<xsl:template match="CD">
	<tr>
		<td width="119" class="cltitre5" valign="top"> Cotation</td>
		<td width="30" class="cltitre5" valign="top" align="center"><xsl:value-of select="."/></td>
		<td width="486" class="cltitre5"><xsl:variable name="value" select="."/><xsl:copy-of select="$dictionnaire/CD/mot[@id=$value]"/></td>
	</tr>
</xsl:template>

<xsl:template match="CE">
	<tr>
		<td width="119" class="cltitre5" valign="top"> Cotation</td>
		<td width="30" class="cltitre5" valign="top" align="center"><xsl:value-of select="."/></td>
		<td width="486" class="cltitre5"><xsl:variable name="value" select="."/><xsl:copy-of select="$dictionnaire/CE/mot[@id=$value]"/></td>
	</tr>
</xsl:template>


</xsl:stylesheet>
