<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>

  <xsl:variable name="dictionnaire" select="document('../Ressources/XML/DicoCotation.xml')/dictionnaire"/>
  <xsl:variable name="dicolib" select="document('../Ressources/XML/DicoLibelle.xml')/dictionnaire"/>
  <xsl:template match="/">
    <html>
      <head>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/Commun.css"/>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/homepage.css"/>
        <link rel="stylesheet" href="/FIBEN/Ressources/CSS/newhome.css"/>
        <title>Informations gnrales sur la cotation</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      </head>
      <body bgcolor="#ffffff" topmargin="0">
        <table width="635" border="0" cellspacing="0" cellpadding="0" >
          <xsl:if test="cotation">
            <tr>
              <td class="cltitre3" colspan="3">
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
                <br/>
                <div class="clCouleur2" align="center">
                  INFORMATIONS GNRALES SUR LA COTATION<br/>
                </div>
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
              </td>
            </tr>
          </xsl:if>   
          <xsl:if test="CM">
            <tr>
              <td class="cltitre3" colspan="3">
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
                <br/>
                <div class="clCouleur2" align="center">
                  INFORMATIONS GNRALES SUR LES CODES MOTIF<br/>
                </div>
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
              </td>
            </tr>
          </xsl:if>
          <xsl:if test="descript">
            <tr>
              <td class="cltitre3" colspan="3">
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
                <br/>
                <div class="clCouleur2" align="center">
                  INFORMATIONS GNRALES SUR LE DESCRIPTEUR<br/>
                </div>
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
              </td>
            </tr>
          </xsl:if>
          <xsl:if test="indiccompl">
            <tr>
              <td class="cltitre3" colspan="3">
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
                <br/>
                <div class="clCouleur2" align="center">
                  INFORMATIONS GNRALES SUR LES INDICATEURS COMPLMENTAIRES<br/>
                </div>
                <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
              </td>
            </tr>
          </xsl:if>



          <xsl:apply-templates select="cotation/CA"/>
          <xsl:apply-templates select="cotation/CC"/>
          <xsl:apply-templates select="cotation/ND"/>
          <!--	<xsl:apply-templates select="cotation/CP"/>    -->
          <xsl:apply-templates select="cotation/CD"/>
          <xsl:apply-templates select="cotation/CE"/>

          <xsl:apply-templates select="CM"/>

          <xsl:apply-templates select="descript/elementB"/>
          <xsl:apply-templates select="descript/elementR"/>
          <xsl:apply-templates select="descript/elementQ"/>
          <xsl:apply-templates select="descript/elementI"/>
          <xsl:apply-templates select="descript/elementD"/>
          <xsl:apply-templates select="descript/elementG"/>
          <xsl:apply-templates select="descript/elementJ"/>
          <xsl:apply-templates select="descript/elementE"/>
          <xsl:apply-templates select="descript/elementS"/>

          <xsl:apply-templates select="indiccompl/IG"/>
          <xsl:apply-templates select="indiccompl/ID"/>
          <xsl:apply-templates select="indiccompl/IS"/>
          <xsl:variable name ="startup" select ="(indiccompl/UP)"> </xsl:variable>
          <xsl:if test ="$startup = '1'">
            
              <tr>
                <td class="cltitre5" width="309" valign="top"> Indicateur start-up</td>
                <td class="cltitre5" width="42" align="left" valign="top">
                  1
                </td>
                <td width="381" class="cltitre5">
                  <xsl:variable name="value" select="'1'"/>
                  <xsl:copy-of select="$dictionnaire/UP/mot[@id=$value]"/>
                </td>
              </tr>
            
           
              <tr>
                <td class="cltitre5" width="309" valign="top"> &#160;</td>
                <td class="cltitre5" width="42" align="left" valign="top">
                  &#160;
                </td>
                <td width="381" class="cltitre5">
                  &#160;&#160;&#160;
                  <xsl:variable name="value" select="'2'"/>
                  <xsl:copy-of select="$dictionnaire/UP/mot[@id=$value]"/>
                </td>
              </tr>
           
              <tr>
                <td class="cltitre5" width="309" valign="top"> &#160;</td>
                <td class="cltitre5" width="42" align="left" valign="top">
                  &#160;
                </td>
                <td width="381" class="cltitre5">
                  &#160;&#160;&#160;
                  <xsl:variable name="value" select="'3'"/>
                  <xsl:copy-of select="$dictionnaire/UP/mot[@id=$value]"/>
                </td>
              </tr>
           
              <tr>
                <td class="cltitre5" width="309" valign="top"> &#160;</td>
                <td class="cltitre5" width="42" align="left" valign="top">
                  &#160;
                </td>
                <td width="381" class="cltitre5">
                  &#160;&#160;&#160;
                  <xsl:variable name="value" select="'4'"/>
                  <xsl:copy-of select="$dictionnaire/UP/mot[@id=$value]"/>
                </td>
              </tr>
          
              <tr>
                <td class="cltitre5" width="309" valign="top"> &#160;</td>
                <td class="cltitre5" width="42" align="left" valign="top">
                  &#160;
                </td>
                <td width="381" class="cltitre5">
                  <xsl:variable name="value" select="'5'"/>
                  <xsl:copy-of select="$dictionnaire/UP/mot[@id=$value]"/>
                </td>
              </tr>
           
          </xsl:if>
         

          <xsl:if test="cotation">
            <xsl:if test="not(cotation/ND)">
              <tr>
                <td colspan="3" class="cltitre5">
                  <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
                  <br/>
                  <xsl:value-of select="$dicolib/mot[@id='MESSINFO37']"/>
                  <br/>
                  <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
                </td>
              </tr>
            </xsl:if>
          </xsl:if>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="CA">
    <tr>
      <td class="cltitre5" width="119" valign="top"> Cote d'activit</td>
      <td class="cltitre5" width="30" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="486" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CA/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td height="10" class="cltitre5" ></td>
      <td height="10" class="cltitre5" ></td>
      <td height="10" class="cltitre5"></td>
    </tr>
  </xsl:template>

  <xsl:template match="CC">
    <tr>
      <td width="119" class="cltitre5" valign="top"> Cote de crdit</td>
      <td width="30" class="cltitre5" valign="top" align="left">
        <xsl:value-of select="."/>
      </td>
      <td width="486" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CC/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="ND">
    <tr>
      <td width="250" class="cltitre5" valign="top" align="right"><xsl:value-of select="."/>&#160;:&#160;</td>
      <td width="385" class="cltitre5"><xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/ND/mot[@id=$value]"/></td>
    </tr>
    <tr>
      <td class="cltitre3" colspan="3">
        <br/>
        <img src="/FIBEN/Images/Commun/shim_bleu.gif" width="635" height="1" vspace="8"/>
      </td>
    </tr>

  </xsl:template>


  <!--xsl:template match="CP">
	<tr>
		<td width="119" class="cltitre5" valign="top"> Cote de paiement</td>
		<td width="20" class="cltitre5" valign="top" align="left"><xsl:value-of select="."/></td>
		<td width="496" class="cltitre5"><xsl:variable name="value" select="."/><xsl:copy-of select="$dictionnaire/CP/mot[@id=$value]"/></td>
	</tr>
</xsl:template-->


  <xsl:template match="CD">
    <tr>
      <td width="119" class="cltitre5" valign="top"> Indicateur</td>
      <td width="30" class="cltitre5" valign="top" align="center">
        <xsl:value-of select="."/>
      </td>
      <td width="486" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CD/mot[@id=$value]"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="CE">
    <tr>
      <td width="119" class="cltitre5" valign="top"> Cotation</td>
      <td width="30" class="cltitre5" valign="top" align="center">
        <xsl:value-of select="."/>
      </td>
      <td width="486" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CE/mot[@id=$value]"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="CM">
    <tr>
      <td width="118" class="cltitre5" valign="top"> Code motif</td>
      <td width="56" class="cltitre5" valign="top" align="center">
        <xsl:value-of select="."/>
      </td>
      <td width="461" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/CM/mot[@id=$value]"/>
      </td>
    </tr>

  </xsl:template>

  <xsl:template match="elementB">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Bilan</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementB/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementR">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Rsultat</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementR/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>
  
   <xsl:template match="elementQ">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Analyse qualitative</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementQ/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementI">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Incident de paiement</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementI/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementD">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Dirigeants</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementD/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementG">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Groupe</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementG/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementJ">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Perte de la moiti du capital social</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementJ/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementE">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Environnement</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementE/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="elementS">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Sanctions</td>
      <td class="cltitre5" width="63" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="505" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/elementS/mot[@id=$value]"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="IG">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Indicateur de groupe</td>
      <td class="cltitre5" width="42" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="381" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/IG/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

  <xsl:template match="ID">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Indicateur de diffusion</td>
      <td class="cltitre5" width="42" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="381" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/ID/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>    
  </xsl:template>

  <xsl:template match="IS">
    <tr>
      <td class="cltitre5" width="309" valign="top"> Indicateur de situation des comptes</td>
      <td class="cltitre5" width="42" align="left" valign="top">
        <xsl:value-of select="."/>
      </td>
      <td width="381" class="cltitre5">
        <xsl:variable name="value" select="."/>
        <xsl:copy-of select="$dictionnaire/IS/mot[@id=$value]"/>
      </td>
    </tr>
    <tr>
      <td width="119" class="cltitre5" height="10"></td>
      <td width="20" class="cltitre5" align="left" height="10"></td>
      <td width="496" class="cltitre5" height="10"></td>
    </tr>
  </xsl:template>

 
  

</xsl:stylesheet>
