﻿Imports System.Xml
Imports System.Xml.Xsl
Imports System.Diagnostics
Imports BDF.POBI.FIBEN.Web.Commun

Partial Class modules_cotation
    Inherits System.Web.UI.Page

    Private Sub TransformXMLToCotation(ByVal oXMLData As XmlDocument)

        Dim oXSLSheet As XslCompiledTransform

        Dim xslt As New XslTransform(Context)

        If Session("sLang") = "FR" Then
            oXSLSheet = xslt.LoadXslCompiledTransform("GenCotationHTML")
        Else
            oXSLSheet = xslt.LoadXslCompiledTransform("GenCotationHTMLUK")
        End If

        'Création du lecteur XML 
        Using vXsltDocumentReader As XmlNodeReader = New XmlNodeReader(oXMLData)

            ' Là où sera enregistré la transformation 
            Dim vStringBuilder As StringBuilder = New StringBuilder()

            ' Paramètre d'écriture du fichier transformé 
            Dim vXmlWriterSettings As XmlWriterSettings = New XmlWriterSettings()
            vXmlWriterSettings.ConformanceLevel = ConformanceLevel.Auto

            Using vXmlWriter As XmlWriter = XmlWriter.Create(vStringBuilder, oXSLSheet.OutputSettings)

                oXSLSheet.Transform(vXsltDocumentReader, Nothing, vXmlWriter, New XmlUrlResolver())

                ' on renvoie la réponse

                'gestion du nom du site si différent de ce qui est codé en dur dans le fichier xsl
                If (Context.Application("sRoot") <> "/FIBEN/") Then
                    Dim nomAppli As String = Mid(Context.Application("sRoot"), 2, Len(Context.Application("sRoot")) - 2)
                    Dim texte As String = vStringBuilder.ToString
                    texte = Replace(texte, "FIBEN", nomAppli)
                    Response.Write(texte)
                Else
                    Response.Write(vStringBuilder.ToString)
                End If
            End Using
        End Using
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Response.Charset = "ISO-8859-1"

        Dim oXMLData As New XmlDocument
        Dim sXMLCotation As String

        sXMLCotation = HttpUtility.HtmlEncode(Request.QueryString("Cotation"))

        If Request.QueryString("Motif") <> "" Then
            sXMLCotation = HttpUtility.HtmlEncode(Request.QueryString("Motif"))
        End If

        If Request.QueryString("Descript") <> "" Then
            sXMLCotation = HttpUtility.HtmlEncode(Request.QueryString("Descript"))
        End If

        If Request.QueryString("Indiccompl") <> "" Then
            sXMLCotation = HttpUtility.HtmlEncode(Request.QueryString("Indiccompl"))
        End If

        Try
            oXMLData.LoadXml(HttpUtility.HtmlDecode(sXMLCotation))

            ' Réalisation de la transformation Xslt
            TransformXMLToCotation(oXMLData)
        Catch ex As XmlException
            Dim err = New Erreur(Of modules_cotation)
            err.CatchError(TypeErreur.ParsingXml, "Erreur technique sur l'affichage de la cotation", ex)
        Catch ex As Exception
            Dim err = New Erreur(Of modules_cotation)
            err.CatchError(TypeErreur.Applicatif, "Erreur technique sur l'affichage de la cotation", ex)
        End Try
    End Sub
End Class
