<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:bdf="http://banque-france.fr/namespace">
	<xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
	<xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
	<xsl:param name="langage" select="'fr'"/>
	<xsl:param name="root" select="'/Fiben/'"/>
	<xsl:param name="familyNumber" select="''"/>
	<xsl:param name="familyName" select="''"/>
	<xsl:param name="familyTitle" select="''"/>
	<xsl:param name="Lang" select="'FR'"/>
	<xsl:param name="nextModule" select="''"/>
 	<xsl:param name="nextId" select="''"/>
	<xsl:param name="nextFamily" select="''"/>
	<xsl:param name="menuHTML1"/>
	<xsl:param name="codeLib" select="''"/>
	<xsl:param name="NonResident" select="''"/>
	<xsl:param name="titleUK" select="''"/>

<xsl:template match="/">
	<html>
    <title>Module SC - Suivi consommation du mois</title>
		<xsl:call-template name="genHead">
			<xsl:with-param name="ident" select="FIBEN/ERREUR | /FIBEN/MODULESC"/>
		</xsl:call-template>		
		<body class="clBodybgcolorWhite">
      <xsl:call-template name="genFondMenu">
        <xsl:with-param name="root" select="$root"/>
        <xsl:with-param name="type" select="'ralph'" />
      </xsl:call-template>
      <xsl:copy-of select="$menuHTML1"/>
      
			<table class="mainmodule horizontal-auto clBorderCell">
        <caption class="visually-hidden">Module SC - Suivi consommation du mois</caption>
				<xsl:call-template name="genLigneConfidentiel"/>
				<xsl:apply-templates select="/FIBEN/ERREUR"/>
				<xsl:if test="not(/FIBEN/ERREUR)">
				<tr> 
					<td class="clWidth14"></td>
					<td colspan="3">
						<table class="clWidth635 clBorderCell" role="presentation">
							<tr>                
                <xsl:if test ="$Lang='UK'">
                <td class="clCouleur1 clWidth617">My FIBEN<br/>
									<img src="{$root}Images/risque/shim_bleu.gif" width="617" height="1" alt=""/><br/>
									Points balance for current month
								</td>
                </xsl:if> 
                <xsl:if test ="$Lang='FR'">                        
                <td class="clCouleur1 clWidth617">FIBEN au quotidien<br/>
									<img src="{$root}Images/risque/shim_bleu.gif" width="617" height="1" alt=""/><br/>
									Suivi consommations du mois en cours
								</td>
                  </xsl:if>                
               <td class="clValignMiddle clAlignCenter clWidth18">
                  <span id="imgNumMod">
                    <xsl:value-of select="$moddem"/>
                  </span>
                </td>
							</tr>
						</table>
					</td>
					<td class="clWidth103"></td>
				</tr>
				<tr> 
					<td class="clWidth14">&#160;</td>
					<td colspan="3"><br/></td>
					<td class="clWidth103">&#160;</td>
				</tr>
				<tr> 
					<td>&#160;</td>
					<td colspan="3"> 
						<table class="clWidth531 clBorderCell">
              <caption class="visually-hidden">Informations du suivi de la consomation</caption>
							<tr> 
							  <td class="clTexte1" colspan="6"><xsl:value-of select="//DENOMB"/></td>
							</tr>
							<tr class="clHeight10"> 
							 <td class="clHeight10"></td>
							 <td class="clHeight10"></td>
							 <td class="clHeight10"></td>
							 <td class="clHeight10"></td>
							  <td class="clTexte" colspan="2">&#160;</td>
							</tr>
              <xsl:if test ="$Lang='UK'">
              <tr> 
							  <th class="clCouleur2 clWidth148 clAlignRight clThNonGras">Bank code </th>
							  <td class="clTexteGras clWidth48">&#160;&#160;<xsl:value-of select="//CODBANQ"/></td>
							  <th class="clCouleur2 clWidth80 clAlignRight clThNonGras">Customer No. </th>
							  <td class="clTexteGras clWidth38">&#160;&#160;<xsl:value-of select="//CODCLT"/>&#160;</td>
							  <th class="clCouleur2 clWidth123 clAlignRight clThNonGras">Total points uses as at:</th>
                <td class="clTexteGras">
                  &#160;&#160;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(//DATCONSO)"/>
                  </xsl:call-template>
                </td>
							</tr>
              </xsl:if>
               <xsl:if test ="$Lang='FR'">
              <tr> 
							  <th class="clCouleur2 clWidth154 clAlignRight clThNonGras">Code banque </th>
							  <td class="clTexteGras clWidth56">&#160;&#160;<xsl:value-of select="//CODBANQ"/></td>
							  <th class="clCouleur2 clWidth71 clAlignRight clThNonGras">Nclient </th>
							  <td class="clTexteGras clWidth39">&#160;&#160;<xsl:value-of select="//CODCLT"/>&#160;</td>
							  <th class="clCouleur2 clWidth107 clAlignRight clThNonGras">Consommation au </th>
                <td class="clTexteGras">
                  &#160;&#160;<xsl:call-template name ="displayDateXsl">
                    <xsl:with-param name ="InputDate" select ="(//DATCONSO)"/>
                  </xsl:call-template>
                </td>
							</tr>
              </xsl:if>   
							<tr> 
							  <td class="clCouleur2">&#160;</td>
							  <td class="clTexte">&#160;</td>
							  <td class="clCouleur2">&#160;</td>
							  <td class="clTexte">&#160;</td>
							  <td class="clTexte" colspan="2">&#160;</td>
							</tr>
							<tr class="clHeight10"> 
							  <td class="clCouleur2">&#160;</td>
							  <td class="clTexte">&#160;</td>
							  <td class="clCouleur2">&#160;</td>
							  <td class="clTexte">&#160;</td>
							  <td class="clTexte" colspan="2">&#160;</td>
							</tr>
							
							<xsl:if test="//TXFORFAI">
								<xsl:if test ="$Lang='UK'">
									<tr> 
									 <td class="clCouleur2 clAlignRight" colspan="5"><span size="3">Discount on <xsl:value-of select="//TFORFAIT"/>&#160;&#160;</span></td>
									 <td class="clGrasFondbd01b clWidth104 clAlignCenter"><span size="3"><xsl:value-of select="//TXFORFAI"/> %</span></td>
								 </tr>
                </xsl:if>
                <xsl:if test ="$Lang='FR'">
									<tr> 
									 <td class="clCouleur2 clAlignRight" colspan="5"><span size="3">Remise du <xsl:value-of select="//TFORFAIT"/>&#160;&#160;</span></td>
									 <td class="clGrasFondbd01b clWidth104 clAlignCenter"><span size="3"><xsl:value-of select="//TXFORFAI"/> %</span></td>
								  </tr>
                </xsl:if>  
							</xsl:if>							
							<tr> 
							  <td class="clCouleur2" colspan="2">&#160;</td>
							  <td class="clTexte clAlignCenter"></td>
							  <td class="clTexte">&#160;</td>
							  <td class="clTexte" colspan="2">&#160;</td>
							</tr>
						</table>
					</td>
					<td>&#160;</td>
				</tr>
  
				<!-- PARTIE TEXTE EXPLICATION -->    
			    <tr> 
					<td>&#160;</td>
					<td colspan="3"><img src="{$root}Images/risque/shim_bleu.gif" width="650" height="1" alt=""/></td>
					<td>&#160;</td>
				</tr>
          <xsl:if test ="$Lang='UK'">
						<tr> 
							<td class="clHeight55">&#160;</td>
							<td class="clcouleur2 clAlignJustify" colspan="3"> "Points balance" shows you how many FIBEN points you have used
                over the month to view different modules (including direct monitoring of FIBEN) and GBI. The total 
                shown is for the previous full working day.<br/>								
                The balance is for information purposes only and does not replace the final invoice.</td>         
							<td colspan="1"></td>
						</tr>
          </xsl:if>
          <xsl:if test ="$Lang='FR'">
           <tr> 
							<td class="clHeight55">&#160;</td>
							<td class="clcouleur2 clAlignJustify" colspan="3"> Le "Suivi consommation" (SC) 
								permet de connatre le cumul des points FIBEN correspondant aux consultations 
								de modules (dont Suivi direct Fiben) et des IGE du mois en cours de votre tablissement. Le total 
								est tabli au dernier jour ouvr prcdent.<br/>
								En aucun cas, ce document ne peut remplacer la facture.</td>
							<td colspan="1"></td>
						</tr>
          </xsl:if>
			   
			    <tr> 
					<td>&#160;</td>
					<td colspan="3"><img src="{$root}Images/risque/shim_bleu.gif" width="650" height="1" alt=""/></td>
					<td>&#160;</td>
			    </tr> 

				<!-- PARTIE FORFAIT -->	
				<tr> 
					<td>&#160;</td>
					<td colspan="3">	
						<table class="clWidth635 clBorderCell">
              <caption class="visually-hidden">Partie forfait</caption>
							<xsl:if test="//TFORFAIT"> 
								<tr>
									<td colspan="5"></td>
								</tr>
                <tr>
                  <td colspan="5"></td>
                </tr>								
								<xsl:if test ="$Lang='UK'">
									<tr>
										<th class="clCouleur2 clWidth418 clAlignLeft clThNonGras"> Points available as part of your subscription : </th>
										<td colspan="4"></td>
									</tr>
                </xsl:if>
                <xsl:if test ="$Lang='FR'">
									<tr>
										<th class="clCouleur2 clWidth418 clAlignLeft clThNonGras"> Points disponibles au titre du forfait : </th>
										<td colspan="4"></td>
									</tr>
                </xsl:if>
                <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>
                <xsl:if test="//PTREPORT">
									  <xsl:if test ="$Lang='UK'">
											<tr>
												<th class="clTexte clAlignLeft clThNonGras">&#160;Points balance carried forward from previous month</th>
												<td/>
												<td class="clTexte clAlignRight"><xsl:value-of select="//PTREPORT"/></td>
												<td colspan="2"></td>
											</tr>
                    </xsl:if>
                    <xsl:if test ="$Lang='FR'">
											<tr>
												<th class="clTexte clAlignLeft clThNonGras">&#160;Points Forfait - report du mois prcdent</th>
												<td/>
												<td class="clTexte clAlignRight"><xsl:value-of select="//PTREPORT"/></td>
												<td colspan="2"></td>
											</tr>
                    </xsl:if>
										<tr>
											<td colspan="5"></td>
										</tr>
										<tr>
											<td colspan="5"></td>
										</tr>
                </xsl:if>
                <xsl:if test="//TFORFAIT">
										<xsl:if test ="$Lang='UK'">
										 <tr>
												<th class="clTexte clAlignLeft clThNonGras">&#160;FIBEN points - <xsl:value-of select="//TFORFAIT"/>for current month</th>
												<td class="clWidth17">&#160;</td>
												<td class="clTexte clWidth78 clAlignRight"><xsl:value-of select="//PTFORFAI"/></td>
												<td class="clWidth31">&#160;</td>
												<td class="clWidth91">&#160;</td>
											</tr>
										</xsl:if>
										<xsl:if test ="$Lang='FR'">
											<tr>
												<th class="clTexte clAlignLeft clThNonGras">&#160;Points FIBEN - <xsl:value-of select="//TFORFAIT"/>du mois en cours</th>
												<td class="clWidth17">&#160;</td>
												<td class="clTexte clWidth78 clAlignRight"><xsl:value-of select="//PTFORFAI"/></td>
												<td class="clWidth31">&#160;</td>
												<td class="clWidth91">&#160;</td>
											</tr>
										</xsl:if>
										<tr>
											<td colspan="5"></td>
										</tr>
										<tr>
											<td colspan="5"></td>
										</tr>
                </xsl:if>
                <xsl:if test ="//TOTPTFOR"> 
									<xsl:if test ="$Lang='UK'">
										<tr>
											 <th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total points available as part of your subscription for current month</span></th>
											 <td>&#160;</td>
											 <td class="clTexte clBorderColorBleu colorBodyNewHome clAlignRight"><span size="3"><xsl:value-of select="//TOTPTFOR"/></span></td>
											 <td>&#160;</td>
											 <td class="clcouleur4">&#160;</td>
										</tr>
									</xsl:if>
									<xsl:if test ="$Lang='FR'">
										<tr>
											 <th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total Points Forfait disponibles du mois en cours</span></th>
											 <td>&#160;</td>
											 <td class="clTexte clBorderColorBleu colorBodyNewHome clAlignRight"><span size="3"><xsl:value-of select="//TOTPTFOR"/></span></td>
											 <td>&#160;</td>
											 <td class="clcouleur4">&#160;</td>
										</tr>
									</xsl:if>
									<tr>
										<td colspan="5"></td>
									</tr>
									<tr>
										<td colspan="5"></td>
									</tr>
                </xsl:if>
							</xsl:if>   
    
							<!-- PARTIE CONSOMMATION MENSUELLE -->
							<xsl:if test="//TOTPTCF">
                <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>
                <xsl:if test ="$Lang='UK'">
									<tr>
										<th class="clCouleur2 clAlignLeft clThNonGras"> Points used over the month :</th>
										<td colspan="4"></td>
									</tr>
                </xsl:if>
                <xsl:if test ="$Lang='FR'">
									<tr>
										<th class="clCouleur2 clAlignLeft clThNonGras"> Consommation mensuelle (en points) :</th>
										<td colspan="4"></td>
									</tr>
                </xsl:if>
                <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>
								<xsl:if test="//PTCM">
									 <xsl:if test ="$Lang='UK'">
										<tr>
											<th class="clTexte clAlignLeft clThNonGras">&#160;Points used for modules since the start of the month</th>
											<td >&#160;</td>
											<td class="clTexte clAlignRight"><xsl:value-of select="//PTCM"/></td>
											<td>&#160;</td>
											<td class="clAlignCenter">&#160;</td>
										</tr>
									</xsl:if>
									 <xsl:if test ="$Lang='FR'">
											<tr>
												<th class="clTexte clAlignLeft clThNonGras">&#160;Points consomms au titre des modules depuis le dbut du mois</th>
												<td >&#160;</td>
												<td class="clTexte clAlignRight"><xsl:value-of select="//PTCM"/></td>
												<td>&#160;</td>
												 <td class="clAlignCenter">&#160;</td>
											</tr>
										</xsl:if>
										<tr>
											<td colspan="5"></td>
										</tr>
										<tr>
											<td colspan="5"></td>
										</tr>
								</xsl:if>
						  
								<xsl:if test="//PTCIGE">
                 <xsl:if test ="$Lang='UK'">
									<tr>
										<th class="clTexte clAlignLeft clThNonGras">&#160;Points used for IGE since the start of the month </th>
										<td>&#160;</td>
										<td class="clTexte clAlignRight"><xsl:value-of select="//PTCIGE"/></td>
										<td colspan="2"></td>
									</tr>
                </xsl:if>
									<xsl:if test ="$Lang='FR'">
										<tr>
											<th class="clTexte clAlignLeft clThNonGras">&#160;Points consomms au titre des IGE depuis le dbut du mois </th>
											<td>&#160;</td>
											<td class="clTexte clAlignRight"><xsl:value-of select="//PTCIGE"/></td>
											<td colspan="2"></td>
										</tr>
									</xsl:if>
									<tr>
										<td colspan="5"></td>
									</tr>
									<tr>
										<td colspan="5"></td>
									</tr>
              </xsl:if>
                <xsl:if test ="//TOTPTCF"> 
                 <xsl:if test ="$Lang='UK'">
										<tr>
											<th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total number of points used</span></th>
											<td>&#160;</td>
											<td class="clTexte colorBodyNewHome clAlignRight"><span size="3"><xsl:value-of select="//TOTPTCF"/></span></td>
											<td>&#160;</td>
											<td></td>
										</tr>
									</xsl:if>
									<xsl:if test ="$Lang='FR'">
										<tr>
											<th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total Points consomms</span></th>
											<td>&#160;</td>
											<td class="clTexte colorBodyNewHome clAlignRight"><span size="3"><xsl:value-of select="//TOTPTCF"/></span></td>
											<td>&#160;</td>
											<td></td>
									 </tr>
									</xsl:if>
									<tr>
										<td colspan="5"></td>
									</tr>
									<tr>
										<td colspan="5"></td>
									</tr>
                </xsl:if>
              </xsl:if>							
							
							<!-- PARTIE CONSOMMATION ENTRANT DANS LE FORFAIT --> 
							<xsl:if test="//PTCFOR">
                <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>
                <xsl:if test ="$Lang='UK'">
									<tr>
										<th class="clCouleur2 clAlignLeft clThNonGras"> Points included in your subscription since the start of the month :</th>
										<td colspan="4"></td>
									</tr>
                </xsl:if>
                <xsl:if test ="$Lang='FR'">
									<tr>
										<th class="clCouleur2 clAlignLeft clThNonGras"> Consommation entrant dans le forfait depuis le dbut du mois (en points) :</th>
										<td colspan="4"></td>
									</tr>
                </xsl:if>
                <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>             
                <xsl:if test="//TXDISPO">
                  <xsl:if test ="$Lang='UK'">
										<tr>
												<th class="clTexte clAlignLeft clThNonGras">
													<span size="3">&#160;Share available</span>
												</th>
												<td>&#160;</td>
												<td class="clTexte clAlignRight">
													<span size="3">
														<xsl:value-of select="//TXDISPO"/> %
													</span>
												</td>
												<td colspan="2"></td>
										</tr>
									</xsl:if>
									<xsl:if test ="$Lang='FR'">
									<tr>
											<th class="clTexte clAlignLeft clThNonGras">
												<span size="3">&#160;Taux disponible</span>
											</th>
											<td>&#160;</td>
											<td class="clTexte clAlignRight">
												<span size="3">
													<xsl:value-of select="//TXDISPO"/> %
												</span>
											</td>
											<td colspan="2"></td>
										</tr>
									</xsl:if>
                  <tr>
                    <td colspan="5"></td>
                  </tr>
                  <tr>
                    <td colspan="5"></td>
                  </tr>
                </xsl:if>
                <xsl:if test ="//PTCFOR">
                <xsl:if test ="$Lang='UK'">
									<tr>
										<th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total points included in your subscription </span></th>
										<td>&#160;</td>
										<td class="clTexte clAlignRight"><span size="3"><xsl:value-of select="//PTCFOR"/></span></td>
										<td>&#160;</td>							    
									</tr>
                </xsl:if>
									<xsl:if test ="$Lang='FR'">
										<tr>
											<th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total Points consomms dans le Forfait </span></th>
											<td>&#160;</td>
											<td class="clTexte clAlignRight"><span size="3"><xsl:value-of select="//PTCFOR"/></span></td>
											<td>&#160;</td>							    
										</tr>
									</xsl:if>
                  <tr>
                    <td colspan="5"></td>
                  </tr>
                  <tr>
                    <td colspan="5"></td>
                  </tr>
                </xsl:if>
								<xsl:if test="//PTCAUDF"> 
                  <xsl:if test ="$Lang='UK'">
											<tr>
												<th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total points not included in your subscription</span></th>
												<td>&#160;</td>
												<td class="clTexte clAlignRight"><span size="3"><xsl:value-of select="//PTCAUDF"/></span></td>
												<td colspan="2"></td>
											</tr>
									</xsl:if>
									<xsl:if test ="$Lang='FR'">
											<tr>
												<th class="clTexte clAlignLeft clThNonGras"><span size="3">&#160;Total Points consomms au-del du Forfait</span></th>
												<td>&#160;</td>
												<td class="clTexte clAlignRight"><span size="3"><xsl:value-of select="//PTCAUDF"/></span></td>
												<td colspan="2"></td>
											</tr>
									</xsl:if>		
                    <tr>
											<td colspan="5"></td>
										</tr>
										<tr>
											<td colspan="5"></td>
										</tr>
								</xsl:if>
               
              </xsl:if> 
  
							<!-- PARTIE CONSOMMATION HORS FORFAIT -->
							<xsl:if test="//PTCHF">
                 <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>
                <xsl:if test ="$Lang='UK'">
                  <tr>
                    <th class="clCouleur2 clAlignLeft clThNonGras"> Points not included in your subscription since the start of the month :</th>
                    <td colspan="4"></td>
                  </tr>                  
                </xsl:if>
                <xsl:if test ="$Lang='FR'">
                  <tr>
                    <th class="clCouleur2 clAlignLeft clThNonGras"> Consommation hors forfait depuis le dbut du mois (en points) :</th>
                    <td colspan="4"></td>
                  </tr>                 
                </xsl:if>
                <tr>
                  <td class="clCouleur2 clHeight10" colspan="5"></td>
                </tr>
                <tr>
                  <td colspan="5"></td>
                </tr>                
										<xsl:if test ="$Lang='UK'">
                      <tr>
											<th class="clTexte clAlignLeft clThNonGras">
												<span size="3">&#160;Total points not included in your subscription </span>
											</th>
                      <td>&#160;</td>
                      <td class="clTexte clAlignRight">
                        <span size="3">
                          <xsl:value-of select="//PTCHF"/>
                        </span>
                      </td>
                      <td>&#160;</td>
                      <td></td>
                      </tr>                         
										</xsl:if>
										<xsl:if test ="$Lang='FR'">
                      <tr>
                      <th class="clTexte clAlignLeft clThNonGras">
												<span size="3">&#160;Total Points consomms hors Forfait </span>
											</th>
                      <td>&#160;</td>
											<td class="clTexte clAlignRight"><span size="3"><xsl:value-of select="//PTCHF"/></span></td>
											<td>&#160;</td>
											<td></td>
											</tr>											
										</xsl:if>
											<tr>
												<td class="clCouleur2 clHeight10" colspan="5"></td>
											</tr>
											<tr>
												<td colspan="5"></td>
											</tr>
									</xsl:if>                   
							
            
              <!-- Partie top 5 modules les plus consults. Affichage si presence de consommations mensuelle-->
              <xsl:if test="//CONSMENS12">
									<xsl:if test="//TOP5">
                    <tr>
                      <td class="clCouleur2 clHeight10" colspan="5"></td>
                    </tr>
										<tr>
											<td colspan="5">
												<img src="{$root}Images/risque/shim_bleu.gif" width="648" height="1" alt=""/>
											</td>
										</tr>
										<tr>
											<td colspan="5">&#160;</td>
										</tr>
										<br/>
										<tr>
											<table class="clWidth635 clBorderCell">
												<caption class="visually-hidden">Partie top 5 modules les plus consults</caption>
                        <xsl:if test ="$Lang='UK'">
													<tr>
														<th class="clCouleur2 clAlignCenter clThNonGras" colspan="5">Top 5 modules viewed (number of views)</th>
													</tr>
                        </xsl:if>
                        <xsl:if test ="$Lang='FR'">
													<tr>
														<th class="clCouleur2 clAlignCenter clThNonGras" colspan="5">Top 5 des modules les plus consults (en nombre de consultations)</th>
													</tr>
                        </xsl:if>
												<tr>
													<td class="clCouleur2 clAlignLeft clHeight20" colspan="5">&#160;</td>
												</tr>
												<tr>
													<xsl:apply-templates select="//TOP5"/>
												</tr>
                        <tr>
													<td colspan="5">&#160;</td>
												</tr>
												<tr>
												<!-- partie graphe Consommation mensuelle sur 12 mois-->										
													<xsl:call-template name="GrapheConsoMensuel"/>									
											 </tr>	
										</table>
									</tr>
								</xsl:if>															
							</xsl:if>
            
            </table>
					</td>
				</tr>          
				</xsl:if>
			</table>
      <xsl:call-template name="genBasPage"/>
		</body>
	</html>
</xsl:template>

  <xsl:template match="TOP5">
    <tr>
      <td class="clTexte clWidth191 clAlignRight clBoxSizing">MODULE&#160;</td>      
      <td class="clTexte clAlignLeft clWidth17 clBoxSizing">
        <xsl:value-of select="NOMMOD"/>
      </td>     
      <td class="clTexte clAlignLeft clThNonGras clWidth274 clBoxSizing">&#160;INTERNET</td> 
      <td class="clTexte clAlignRight clWidth20 clBoxSizing">
        <xsl:value-of select="NBRCONS"/>
      </td>	
      <td class="clWidth133">&#160;
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="GrapheConsoMensuel">   
    <table class="clWidth635 clBorderCellpadding2" role="presentation">
      <tr>
        <td colspan="5">
          <img src="{$root}Images/risque/shim_bleu.gif" width="645" height="1" alt=""/>
        </td>
      </tr>
      <tr>
        <td colspan="5"/>
      </tr>
      <tr>
        <td colspan="5"/>
      </tr>
      <br/>
        <xsl:if test ="$Lang='UK'">
					<tr>
						<th class="clCouleur2 clThNonGras clWidth635 clAlignCenter" colspan="5">
              <br/>
							Change in use of modules and remote transmission services (excluding RRR) 
						</th>
					</tr>
					<tr>
						<th class="clCouleur2 clThNonGras clWidth635 clAlignCenter" colspan="5">
							in number of FIBEN 
							<br/>
						</th>
					</tr>
				</xsl:if>
				<xsl:if test ="$Lang='FR'">
					<tr>
						<th class="clCouleur2 clThNonGras clWidth635 clAlignCenter" colspan="5">
              <br/>
							volution de la consommation de modules et de services de tldiffusion (hors CRR)
						</th>
					</tr>
					<tr>
						<th class="clCouleur2 clThNonGras clWidth635 clAlignCenter" colspan="5">
							en nombre de points FIBEN
							<br/>
						</th>
					</tr>
				</xsl:if>
      
      <tr>
        <td colspan="5">&#160;</td>
      </tr>
      <tr>
        <td colspan="5">&#160;</td>
      </tr>

      <tr>
        <td class="clWidth635">
          <xsl:element name="img">
            <xsl:attribute name="src">
              MSC/Graphiques/graphe1.aspx?module=SC&amp;s1v1=<xsl:value-of select="//CONSMENS12/NBPOINTS1"/>&amp;s1v2=<xsl:value-of select="//CONSMENS12/NBPOINTS2"/>&amp;s1v3=<xsl:value-of select="//CONSMENS12/NBPOINTS3"/>&amp;s1v4=<xsl:value-of select="//CONSMENS12/NBPOINTS4"/>&amp;s1v5=<xsl:value-of select="//CONSMENS12/NBPOINTS5"/>&amp;s1v6=<xsl:value-of select="//CONSMENS12/NBPOINTS6"/>&amp;s1v7=<xsl:value-of select="//CONSMENS12/NBPOINTS7"/>&amp;s1v8=<xsl:value-of select="//CONSMENS12/NBPOINTS8"/>&amp;s1v9=<xsl:value-of select="//CONSMENS12/NBPOINTS9"/>&amp;s1v10=<xsl:value-of select="//CONSMENS12/NBPOINTS10"/>&amp;s1v11=<xsl:value-of select="//CONSMENS12/NBPOINTS11"/>&amp;s1v12=<xsl:value-of select="//CONSMENS12/NBPOINTS12"/>&amp;ab1=<xsl:value-of select="//CONSMENS12/MOIS1"/>&amp;ab2=<xsl:value-of select="//CONSMENS12/MOIS2"/>&amp;ab3=<xsl:value-of select="//CONSMENS12/MOIS3"/>&amp;ab4=<xsl:value-of select="//CONSMENS12/MOIS4"/>&amp;ab5=<xsl:value-of select="//CONSMENS12/MOIS5"/>&amp;ab6=<xsl:value-of select="//CONSMENS12/MOIS6"/>&amp;ab7=<xsl:value-of select="//CONSMENS12/MOIS7"/>&amp;ab8=<xsl:value-of select="//CONSMENS12/MOIS8"/>&amp;ab9=<xsl:value-of select="//CONSMENS12/MOIS9"/>&amp;ab10=<xsl:value-of select="//CONSMENS12/MOIS10"/>&amp;ab11=<xsl:value-of select="//CONSMENS12/MOIS11"/>&amp;ab12=<xsl:value-of select="//CONSMENS12/MOIS12"/>
            </xsl:attribute>
          </xsl:element>
        </td>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>
