﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bdf="http://banque-france.fr/namespace">
  <xsl:import href="../../Ressources/XSL/Commun.xsl"/>
  <xsl:import href="../../Ressources/XSL/commun_transfo.xsl"/>
  <xsl:output method="html" version="1.1" encoding="ISO-8859-1" indent="yes"/>
  <xsl:param name="langage" select="'fr'"/>
  <xsl:param name="root" select="'/Fiben/'"/>
  <xsl:param name="familyNumber" select="''"/>
  <xsl:param name="familyName" select="''"/>
  <xsl:param name="familyTitle" select="''"/>
  <xsl:param name="nextModule" select="''"/>
  <xsl:param name="nextId" select="''"/>
  <xsl:param name="nextFamily" select="''"/>
  <xsl:param name="menuHTML1"/>
  <xsl:param name="Lang" select="'FR'"/>
  <xsl:param name="codeLib" select="''"/>
  <xsl:param name="NonResident" select="''"/>
  <xsl:param name="titleUK" select="''"/>
  <xsl:variable name="isFirstAndLastDI" select="count(FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESSOCIAUX/SOC64/DONNEESINDIVIDUELLESAN)=1"/>
  <xsl:variable name="hasSectorielle" select="count(FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESSOCIAUX/SOC64/DONNEESSECTORIELLES/INFOSECTORIELLES)=1"/>
  <xsl:variable name="isOnlyOneCC" select="count(/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/CHIFFRESCONSO | /FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/CHIFFRESCONSOIFRS)=1"/>
  <!--Essai-->
  <!--TEMPLATE PRINCIPAL-->
  <xsl:template match="/">
    <html lang="fr">
      <title>Module AN - Dossier Analyse</title>
      <xsl:call-template name="genHead">
        <xsl:with-param name="ident" select="FIBEN/ERREUR/IDENT | /FIBEN/PERSONNE/MODULEAN/*//IDENTS"/>
      </xsl:call-template>
      <body class="clBodybgcolorWhite">
        <xsl:call-template name="genFondMenu">
          <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:copy-of select="$menuHTML1"/>
        <table class="mainmodule horizontal-auto clBorderCell">
          <caption class="visually-hidden">Module AN - Dossier Analyse</caption>
          <xsl:call-template name="genLigneConfidentiel"/>
          <xsl:apply-templates select="/FIBEN/ERREUR"/>
          <xsl:if test="not(/FIBEN/ERREUR)">
            <tr>
              <td class="clWidth14"/>
              <td class="clCouleur2 clWidth739 clValingTop" colspan="3">
                <xsl:call-template name="genEnTete">
                  <xsl:with-param name="ident" select="/FIBEN/PERSONNE/MODULEAN/*//IDENTS"/>
                  <xsl:with-param name="nom">
                    <xsl:if test="//EJ/DENOM">
                      <xsl:value-of select="//EJ/DENOM"/>
                    </xsl:if>
                  </xsl:with-param>
                  <xsl:with-param name="valcot" select="//INFOCOTATIONEJ/VALCOT"/>
                  <xsl:with-param name="datcot" select="//INFOCOTATIONEJ/DATCOT"/>
                  <xsl:with-param name="datexa" select="//INFOCOTATIONEJ/DATEXA"/>
                </xsl:call-template>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/IST/ISTAN" mode="genLib"/>
                <xsl:apply-templates select="//INFOJURIDIQUES"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/IEC01" mode="DisplayMAN"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESAN"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOTATIONEJ"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOASSOCIES"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOPARTICIPATIONS"/>
                <table class="clBorderCell clWidthMax" role="presentation">
                  <tr class="clHeight0">
                    <td class="clWidth20"/>
                    <td class="clWidth110"/>
                    <td class="clWidth125"/>
                    <td class="clWidth130"/>
                    <td class="clWidth125"/>
                    <td class="clWidth125"/>
                  </tr>
                </table>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOEVMEVJAN"/>
                <xsl:call-template name="shim"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOIMPAYESRESUM"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORELBANC"/>
                <!--<xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOSCORE"/>-->
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/EJ"/>
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/STECONSO" mode="genLib"/>
              </td>
              <td class="clWidth103 clAlignRight"/>
            </tr>
          </xsl:if>
        </table>
        <xsl:call-template name="genBasPage"/>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="ISTAN" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2 clWidthMax">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
    </table>
    <!--xsl:call-template name="shim"/-->
    <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/IST/EJ"/>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- ***********************************  bloc INFORMATIONS JURIDIQUES ***************************************************************************************************************-->
  <!--********************************************************************************************************************************************************************-->
  <xsl:template match="INFOJURIDIQUES">
    <a name="ancJurid"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_InfJur'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Informations juridiques</caption>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_CatJur'"/>
          </xsl:call-template>
        </th>
        <td class="clFond" colspan="3">
          &#160;<xsl:value-of select="CODECAT"/>&#160;&#160;&#160;<xsl:value-of select="CATJUR"/>
        </td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_ActBDF'"/>
          </xsl:call-template>
        </th>
        <td class="clTexte" colspan="3">
          &#160;<xsl:value-of select="ACTBDF"/>&#160;&#160;
          <xsl:if test="$Lang = 'UK'">
            <xsl:call-template name="tradLibNaf">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codelib" select="ACTBDF"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="$Lang = 'FR'">
            <xsl:value-of select="LIBACT"/>
          </xsl:if>
        </td>
      </tr>
      <xsl:apply-templates select="//INFOJURIDIQUES/CODNAF"/>
      <xsl:apply-templates select="p2051DA"/>
      <xsl:apply-templates select="ENSEIGNE"/>
      <xsl:if test="not(p2051DA) and not(ENSEIGNE) and DATCRE">
        <tr>
          <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clTexte clWidth305">&#160;</td>
          <xsl:apply-templates select="DATCRE"/>
        </tr>
      </xsl:if>
      <xsl:apply-templates select="SIGLE"/>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="//INFOJURIDIQUES/CODNAF">
    <tr>
      <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m27_CodeNaf'"/>
        </xsl:call-template>
      </th>
      <td class="clFond" colspan="3">
        &#160;<xsl:value-of select="//INFOJURIDIQUES/CODNAF"/>&#160;&#160;
        <xsl:if test="$Lang = 'FR'">
          <xsl:value-of select="//INFOJURIDIQUES/LIBNAF"/>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="p2051DA">
    <tr>
      <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m27_Cap'"/>
        </xsl:call-template>
      </th>
      <xsl:if test="../CODNAF">
        <td class="clTexte clWidth305">
          <xsl:if test="@ETAT">
            &#160;<xsl:value-of select="@ETAT"/>
          </xsl:if>
          <xsl:if test="not(@ETAT)">
            &#160;<xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(.)"/>
            </xsl:call-template>&#160;<img height="9" src="{$root}images/Commun/euro_symb_noir.png" width="8"/>
          </xsl:if>
          <xsl:if test="../DATAG">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_au'"/>
            </xsl:call-template>&#160;
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(../DATAG)"/>
            </xsl:call-template>
          </xsl:if>
        </td>
        <xsl:apply-templates select="../DATCRE"/>
        <xsl:if test="not(../DATCRE) and ../SIGLE[1]">
          <xsl:call-template name="SIGLEclTexte">
            <xsl:with-param name="titre">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="sigle" select="../SIGLE[1]"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
      <xsl:if test="not(../CODNAF)">
        <td class="clFond clWidth305">
          <xsl:if test="@ETAT">
            &#160;<xsl:value-of select="@ETAT"/>
          </xsl:if>
          <xsl:if test="not(@ETAT)">
            &#160;<xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(.)"/>
            </xsl:call-template>&#160;<img height="9" src="{$root}images/Commun/euro_symb_noir.png" width="8"/>
          </xsl:if>
          <xsl:if test="../DATAG">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_au'"/>
            </xsl:call-template>&#160;
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(../DATAG)"/>
            </xsl:call-template>
          </xsl:if>
        </td>
        <xsl:apply-templates select="../DATCRE"/>
        <xsl:if test="not(../DATCRE) and ../SIGLE[1]">
          <xsl:call-template name="SIGLEclFond">
            <xsl:with-param name="titre">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="sigle" select="../SIGLE[1]"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
    </tr>
  </xsl:template>
  <xsl:template match="ENSEIGNE">
    <tr>
      <xsl:if test="position()=1">
        <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Enseig'"/>
          </xsl:call-template>
        </th>
        <xsl:if test="(../CODNAF and ../p2051DA) or (not(../CODNAF) and not(../p2051DA))">
          <td class="clFond">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA)">
            <xsl:apply-templates select="../DATCRE"/>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE))and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
        <xsl:if test="(../CODNAF and not(../p2051DA)) or (not(../CODNAF) and ../p2051DA)">
          <td class="clTexte clWidth305">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA)">
            <xsl:apply-templates select="../DATCRE"/>
            <xsl:if test="not(../DATCRE)">
              <td class="clTexte clWidth200">&#160;</td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
      </xsl:if>
      <xsl:if test="position()=2">
        <td class="clCouleur2 clWidth130">&#160;</td>
        <xsl:if test="(../CODNAF and ../p2051DA) or (not(../CODNAF) and not(../p2051DA))">
          <td class="clTexte clWidth305">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA) and ../DATCRE and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[3]">
            <xsl:call-template name="SIGLEclTexte">
              <xsl:with-param name="sigle" select="../SIGLE[3]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
        <xsl:if test="(../CODNAF and not(../p2051DA)) or (not(../CODNAF) and ../p2051DA)">
          <td class="clFond clWidth305">
            &#160;<xsl:value-of select="."/>
          </td>
          <xsl:if test="not(../p2051DA) and ../DATCRE and ../SIGLE[1]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="titre">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="Lang" select="$Lang"/>
                  <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="sigle" select="../SIGLE[1]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="((not(../p2051DA) and not(../DATCRE))or(../p2051DA and ../DATCRE)) and ../SIGLE[2]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="sigle" select="../SIGLE[2]"/>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="../p2051DA and not(../DATCRE) and ../SIGLE[3]">
            <xsl:call-template name="SIGLEclFond">
              <xsl:with-param name="sigle" select="../SIGLE[3]"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
      </xsl:if>
    </tr>
  </xsl:template>
  <xsl:template match="DATCRE">
    <th class="clCouleur2 clWidth120 clThNonGras">
      &#160;
      <xsl:call-template name="tradlib">
        <xsl:with-param name="Lang" select="$Lang"/>
        <xsl:with-param name="codeLib" select="'m27_DatCre'"/>
      </xsl:call-template>
    </th>
    <xsl:if test="../CODNAF">
      <td class="clTexte clWidth80">
        &#160;<xsl:call-template name="displayDateXsl">
          <xsl:with-param name="InputDate" select="(.)"/>
        </xsl:call-template>
      </td>
    </xsl:if>
    <xsl:if test="not(../CODNAF)">
      <td class="clFond clWidth80">
        &#160;<xsl:call-template name="displayDateXsl">
          <xsl:with-param name="InputDate" select="(.)"/>
        </xsl:call-template>
      </td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="SIGLE">
    <xsl:if test="position()=1">
      <xsl:if test="(../DATCRE and not(../ENSEIGNE))or(not(../p2051DA) and count(../ENSEIGNE)=1 and ../DATCRE)">
        <tr>
          <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clWidth305">&#160;</td>
          <th class="clCouleur2 clWidth120 clThNonGras">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
            </xsl:call-template>
          </th>
          <xsl:if test="../CODNAF">
            <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
            <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="not(../DATCRE) and not(../ENSEIGNE) and not (../p2051DA)">
        <tr>
          <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120 clThNonGras">
            &#160;
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Sigle'"/>
            </xsl:call-template>
          </td>
          <xsl:if test="../CODNAF">
            <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
            <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=2">
      <xsl:if test="(not(../DATCRE) and not(../ENSEIGNE))or(not(../ENSEIGNE[2]) and not(../DATCRE)and not(../p2051DA))">
        <tr>
          <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">&#160;</td>
          <xsl:if test="../CODNAF">
            <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
            <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="(not(../p2051DA) and count(../ENSEIGNE)!=0 and ../DATCRE) or (not(../ENSEIGNE) and ../DATCRE) or (count(../ENSEIGNE)=1 and ../DATCRE and ../p2051DA)">
        <tr>
          <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">&#160;</td>
          <xsl:if test="../CODNAF">
            <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="not(../CODNAF)">
            <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=3">
      <xsl:if test="not(../ENSEIGNE[2] and ../p2051DA and not(../DATCRE))">
        <tr>
          <td class="clCouleur2 clWidth130">&#160;</td>
          <td class="clWidth305">&#160;</td>
          <td class="clCouleur2 clWidth120">&#160;</td>
          <xsl:if test="(../CODNAF and ../DATCRE) or (not(../CODNAF) and not(../p2051DA) and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and not(../DATCRE))">
            <td class="clFond clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
          <xsl:if test="(../CODNAF and ../p2051DA and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and ../DATCRE) or (not(../p2051DA) and not(../CODNAF) and ../DATCRE ) or (not(../DATCRE) and not(../p2051DA) and ../CODNAF)">
            <td class="clTexte clWidth80">
              &#160;<xsl:value-of select="."/>
            </td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=4">
      <tr>
        <td class="clCouleur2 clWidth130">&#160;</td>
        <td class="clWidth305">&#160;</td>
        <td class="clCouleur2 clWidth120">&#160;</td>
        <xsl:if test="(../CODNAF and ../DATCRE) or (not(../CODNAF) and not(../p2051DA) and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and not(../DATCRE))">
          <td class="clTexte clWidth80">
            &#160;<xsl:value-of select="."/>
          </td>
        </xsl:if>
        <xsl:if test="(../CODNAF and ../p2051DA and not(../DATCRE)) or (../p2051DA and not(../CODNAF) and ../DATCRE) or (not(../p2051DA) and not(../CODNAF) and ../DATCRE ) or (not(../DATCRE) and not(../p2051DA) and ../CODNAF)">
          <td class="clFond clWidth80">
            &#160;<xsl:value-of select="."/>
          </td>
        </xsl:if>
      </tr>
    </xsl:if>
  </xsl:template>
  <xsl:template name="SIGLEclFond">
    <xsl:param name="titre"/>
    <xsl:param name="sigle"/>
    <td class="clCouleur2 clWidth120">
      &#160;<xsl:value-of select="$titre"/>
    </td>
    <td class="clFond clWidth80">
      &#160;<xsl:value-of select="$sigle"/>
    </td>
  </xsl:template>
  <xsl:template name="SIGLEclTexte">
    <xsl:param name="titre"/>
    <xsl:param name="sigle"/>
    <td class="clCouleur2 clWidth120">
      &#160;<xsl:value-of select="$titre"/>
    </td>
    <td class="clTexte clWidth80">
      &#160;<xsl:value-of select="$sigle"/>
    </td>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- ***********************************  bloc COMPTE SOCIAUX, COMPTES CONSOLIDEES ***************************************************************************************************************-->
  <!--********************************************************************************************************************************************************************-->
  <xsl:template match="INFOCOMPTABLESAN">
    <a name="ancSociaux"/>
    <xsl:if test="CHIFRSOCAN/BIL02">
      <xsl:apply-templates select="CHIFRCONSAN/BILCONSOAN"/>
      <xsl:if test="not(CHIFRCONSAN/BILCONSOAN)">
        <table class="clBorderCell clWidth739" role="presentation">
          <tr class="clAlignCenter">
            <td class="clWidth19">&#160;</td>
            <td class="clCouleurGras clWidth597">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
              </xsl:call-template>
            </td>
            <td class="clWidth19">
            </td>
            <td class="clWidth103 clAlignRight"/>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br/>
      </xsl:if>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clTexte">
            <span class="clCouleur2">
              <xsl:call-template name="traduction">
                <xsl:with-param name="code" select="'BIL02'"/>
              </xsl:call-template>
            </span>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <xsl:if test="CHIFRSOCAN/BIL01S">
      <xsl:apply-templates select="CHIFRCONSAN/BILCONSOAN"/>
      <xsl:if test="not(CHIFRCONSAN/BILCONSOAN)">
        <table class="clBorderCell clWidth739" role="presentation">
          <tr class="clAlignCenter">
            <td class="clWidth19">&#160;</td>
            <td class="clCouleurGras clWidth597">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
              </xsl:call-template>
            </td>
            <td class="clWidth19">
            </td>
            <td class="clWidth103 clAlignRight"/>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br/>
      </xsl:if>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clTexte">
            <span class="clCouleur2">
              <xsl:call-template name="traduction">
                <xsl:with-param name="code" select="'BIL01S'"/>
              </xsl:call-template>
            </span>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
    <xsl:if test="not(CHIFRSOCAN/BIL02) and not(CHIFRSOCAN/BIL01S) ">
      <xsl:apply-templates select="CHIFRSOCAN/BILANAN[last()]"/>
    </xsl:if>
    <xsl:if test="not(CHIFRCONSAN/BIL01C) and not(CHIFRSOCAN/BIL02) and not(CHIFRSOCAN/BIL01S)and not(CHIFRSOCAN/BILANAN)">
      <xsl:apply-templates select="CHIFRCONSAN/BILCONSOAN[last()]"/>
    </xsl:if>
    <xsl:if test="CHIFRCONSAN/BIL01C">
      <xsl:if test="not(CHIFRSOCAN/BILANAN) and not(CHIFRSOCAN/BIL01S) and not(CHIFRSOCAN/BIL02)">
        <table class="clBorderCell clWidth739" role="presentation">
          <tr class="clAlignCenter">
            <td class="clWidth19">&#160;</td>
            <td class="clCouleurGras clWidth597">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
              </xsl:call-template>
            </td>
            <td class="clWidth19">

            </td>
            <td class="clWidth103 clAlignRight"/>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br/>
      </xsl:if>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clTexte">
            <span class="clCouleur2">
              <xsl:call-template name="traduction">
                <xsl:with-param name="code" select="'BIL01C'"/>
              </xsl:call-template>
            </span>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="BILANAN">
    <table class="clBorderCell clWidth739" role="presentation">
      <tr class="clAlignCenter">
        <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clWidth597">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
          </xsl:call-template>
        </td>
        <td class="clWidth19">

        </td>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:if test="//CHIFRCONSAN/BILCONSOAN">
      <table class="clWidth635 clBorderCell clHeight125">
        <caption class="visually-hidden">Chiffres clés</caption>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComSoc'"/>
            </xsl:call-template>
          </th>
          <td colspan="{count(../BILANAN)}">
            &#160;
          </td>
          <td class="clWidth15 clHeight125 clValignBottom clAlignMiddle " rowspan="10">
            <img height="125" src="{$root}images/risque/shim_bleu.gif" width="1" alt=""/>
          </td>
          <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComCon'"/>
            </xsl:call-template>
          </th>
          <td colspan="{count(//CHIFRCONSAN/BILCONSOAN)}">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
          <td class="clHeight5" colspan="4"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/@DATCLOT" mode="chifcles"/>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/@DATCLOT" mode="chifcles"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/@DUREEEX" mode="chifcles"/>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/@DUREEEX" mode="chifcles"/>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
          <td class="clHeight5" colspan="4"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth85 clHeight15 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_CA'"/>
            </xsl:call-template>
            (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>)
          </th>
          <td class="clCouleur2 clWidth65 clHeight15">&#160;</td>
          <td class="clFond clHeight15" colspan="{count(../BILANAN)}">&#160;</td>
          <th class="clCouleur2 clWidth140 clHeight15 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_CAGRP'"/>
            </xsl:call-template>
            (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>)
          </th>
          <td colspan="{count(//CHIFRCONSAN/BILCONSOAN)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clCouleur2"/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/p2052FL1"/>
          <td class="clWidth39"/>
          <th class="clCouleur2 clWidth101 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/pCACONS1"/>
        </tr>
        <tr>
          <td/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Export'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/p2052FK"/>
          <td/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Etranger'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/p2010AD"/>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
          <td class="clHeight5" colspan="4"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/p2058YP1"/>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/pEFFECT1"/>
        </tr>
        <xsl:if test="../DATDOC">
          <xsl:if test="not($NonResident='NR')">
            <tr>
              <td colspan="10" class="clAlignCenter">
              </td>
            </tr>
          </xsl:if>
        </xsl:if>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
    <xsl:if test="not(//CHIFRCONSAN/BILCONSOAN)">
      <table class="clWidth635 clHeight125 clBorderCell">
        <caption class="visually-hidden">Chiffres clés</caption>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComSoc'"/>
            </xsl:call-template>
          </th>
          <td colspan="4">
            &#160;
          </td>
        </tr>
        <tr>
          <td colspan="6" class="clHeight5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/@DATCLOT" mode="chifcles"/>
          <td width="{75-25*count(//BILANAN)}%" colspan="{3-count(//BILANAN)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/@DUREEEX" mode="chifcles"/>
          <td colspan="{3-count(//BILANAN)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td colspan="6" class="clHeight5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth85 clHeight15 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_CA'"/>
            </xsl:call-template>
            (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>)
          </th>
          <td class="clCouleur2 clWidth65 clHeight15">&#160;</td>
          <td class="clFond clHeight15" colspan="4">&#160;</td>
        </tr>
        <tr>
          <td class="clCouleur2"/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/p2052FL1|../BILANAN/p209101"/>
          <td colspan="{3-count(//BILANAN)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Export'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/p2052FK"/>
          <td colspan="{3-count(//BILANAN)}" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="6"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="../BILANAN/p2058YP1"/>
          <td colspan="{3-count(//BILANAN)}" class="clFond">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="BILCONSOAN">
    <xsl:if test="position()=last()">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr class="clAlignCenter">
          <td class="clWidth19">&#160;</td>
          <td class="clCouleurGras clWidth597">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ChiCle'"/>
            </xsl:call-template>
          </td>
          <td class="clWidth19">

          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clHeight125 clBorderCell">
        <caption class="visually-hidden">Chiffres clés</caption>
        <tr>
          <th class="clCouleur2 clWidth140 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_ComCon'"/>
            </xsl:call-template>
          </th>
          <td colspan="3">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_DatClo'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/@DATCLOT" mode="chifcles"/>
          <td width="{80-40*count(//CHIFRCONSAN/BILCONSOAN)}%" class="clFond">&#160;</td>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Duree'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/@DUREEEX" mode="chifcles"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth140 clHeight15 clAlignLeft clThNonGras" colspan="2">
            CA Groupe (M<img height="9" src="{$root}images/risque/euro_symb_bleu.gif" width="8"/>)
          </th>
          <td colspan="3" class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth39"/>
          <th class="clCouleur2 clWidth101 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Net'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/pCACONS1"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td/>
          <th class="clCouleur2 clAlignLeft clThNonGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Etranger'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/p2010AD"/>
          <td class="clFond">&#160;</td>
        </tr>
        <tr>
          <td class="clHeight5" colspan="5"/>
        </tr>
        <tr>
          <th class="clCouleur2 clAlignLeft clThNonGras" colspan="2">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_Effectif'"/>
            </xsl:call-template>
          </th>
          <xsl:apply-templates select="//CHIFRCONSAN/BILCONSOAN/pEFFECT1"/>
          <td class="clFond">&#160;</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="p2052FL1|p209101|p2052FK|pCACONS1|p2010AD">
    <xsl:if test="@ETAT">
      <td class="clFond clAlignRight">
        &#160;<xsl:value-of select="@ETAT"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <td class="clFond clAlignRight">
        &#160;<xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="p2058YP1|pEFFECT1">
    <xsl:if test="@ETAT">
      <td class="clFond clAlignRight">
        &#160;<xsl:value-of select="@ETAT"/>&#160;
      </td>
    </xsl:if>
    <xsl:if test="not(@ETAT)">
      <td class="clFond clAlignRight">
        &#160;<xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DATCLOT|@DUREEEX" mode="chifcles">
    <td class="clFond clAlignRight">
      <xsl:if test="$Lang='FR'">
        &#160;<xsl:call-template name="displayDateXsl">
          <xsl:with-param name="InputDate" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
      <xsl:if test="$Lang='UK'">
        &#160;<xsl:call-template name="displayDateUKXsl">
          <xsl:with-param name="InputDate" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- ***********************************  bloc LA COTATION BANQUE DE FRANCE***************************************************************************************************************-->
  <!--********************************************************************************************************************************************************************-->
  <xsl:template match="INFOCOTATIONEJ">
    <a name="ancCotation"/>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr class="clAlignCenter">
        <td class="clWidth19"> </td>
        <td class="clCouleurGras clWidth597"> LA COTATION BANQUE DE FRANCE</td>
        <td class="clWidth19"/>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <xsl:choose>
      <xsl:when test="VALCOT = 'ND'">
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="cltitre5 clWidth635 clAlignCenter">
              Cotation Non Disponible.
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <xsl:if test="//COTPREC">
          <xsl:apply-templates select="COTPREC"/>
          <xsl:call-template name="shim"/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <table class="clWidth635 clBorderCell">
          <caption class="visually-hidden">LA COTATION BANQUE DE FRANCE</caption>
          <tr>
            <th class="clCouleur2 clWidth69 clAlignLeft clThNonGras">Cotation :</th>
            <xsl:if test="DATEXA">
              <td class="clFond clWidth218">
                &#160;<xsl:value-of select="VALCOT"/>
              </td>
              <th class="clCouleur2 clWidth105 clHeight18 clAlignCenter clThNonGras">depuis le</th>
              <td class="clFond clWidth69">
                &#160;<xsl:call-template name="displayDateXsl">
                  <xsl:with-param name="InputDate" select="(DATCOT)"/>
                </xsl:call-template>
              </td>
              <th class="clCouleur2 clWidth101 clHeight18 clAlignCenter clThNonGras">actualisée le</th>
              <td class="clFond clWidth69 clHeight18">
                &#160;<xsl:call-template name="displayDateXsl">
                  <xsl:with-param name="InputDate" select="(DATEXA)"/>
                </xsl:call-template>
              </td>
            </xsl:if>
            <xsl:if test="not(DATEXA)">
              <td class="clFond clWidth392">
                &#160;<xsl:value-of select="VALCOT"/>
              </td>
              <th class="clCouleur2 clWidth105 clHeight18 clAlignCenter clThNonGras">depuis le</th>
              <td class="clFond clWidth69">
                &#160;<xsl:call-template name="displayDateXsl">
                  <xsl:with-param name="InputDate" select="(DATCOT)"/>
                </xsl:call-template>
              </td>
            </xsl:if>
          </tr>
        </table>
        <xsl:apply-templates select="DATBILS"/>
        <xsl:apply-templates select="DATBILC"/>
        <xsl:apply-templates select="COTPREC"/>
        <xsl:if test="//INFLUENCANTE or //TETEDEGROUPE">
          <xsl:call-template name="shim"/>
          <table class="clWidth635 clBorderCell">
            <caption class="visually-hidden">données sur l'entité influencante ou tête de groupe</caption>
            <xsl:apply-templates select="//INFLUENCANTE"/>
            <xsl:apply-templates select="//TETEDEGROUPE"/>
          </table>
        </xsl:if>
        <xsl:if test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL06|/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL07|/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL08|/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL09">
          <xsl:call-template name="shim"/>
          <table class="clWidth635 clBorderCell" role="presentation">
            <tr>
              <td class="clCouleur2">
                <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL06|/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL07|/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL08|/FIBEN/PERSONNE/MODULEAN/DIFFAN/BIL09"/>
              </td>
            </tr>
          </table>
        </xsl:if>
        <xsl:if test="not(//IEC01)">
          <div class="clBreakPage"/>
          <xsl:if test="//MEJ/MEJIG|//MEJ/MEJIS|//MEJ/MEJID|//MEJ/MEJUP">
            <xsl:call-template name="shim"/>
            <table class="clWidth635 clBorderCell" role="presentation">
              <tr>
                <td class="clCouleurGras">
                  <div class="clAlignCenter">
                    <xsl:call-template name="tradlib">
                      <xsl:with-param name="Lang" select="$Lang"/>
                      <xsl:with-param name="codeLib" select="'m37_Caract'"/>
                    </xsl:call-template>
                    <br/>
                  </div>
                </td>
              </tr>
            </table>
            <xsl:call-template name="shim"/>
            <xsl:if test="//MEJ/MEJIG|//MEJ/MEJIS|//MEJ/MEJID">
              <table class="clWidth635 clBorderCell">
                <xsl:apply-templates select="//MEJIG/*" mode="displayLib"/>
                <xsl:apply-templates select="//MEJIS/*" mode="displayLib"/>
                <xsl:apply-templates select="//MEJID/*" mode="displayLib"/>
              </table>
            </xsl:if>
            <xsl:if test="//MEJ/MEJUP">
              <!-- affichage d'un infobulle-->
              <table class="clTexte" title="Se distingue pour la Banque de France par 3 caractéristiques: &#013;
                          - Fort potentiel de croissance &#013;
                          - Usage ou création d'une &#013;
                            technologie nouvelle &#013;
                          - Besoin de financement souvent &#013;
                            assuré par des levées de fonds &#013;Pour plus d'informations, consultez le site utilisateur FIBEN">
                <td class="clWidth122"/>
                <td class="clWidth290">- Analyse tenant compte du modèle de croissance des</td>
                <td class="clWidth223 clSousLigner">start-up</td>
              </table>
            </xsl:if>
          </xsl:if>
        </xsl:if>
        <xsl:call-template name="shim"/>
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="clCouleurGras">
              <div class="clAlignCenter">
                <xsl:call-template name="tradlib">
                  <xsl:with-param name="codeLib" select="'m37_Explititre'"/>
                </xsl:call-template>
                <br/>
              </div>
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <!-- appel template de la cote d'activité -->
        <xsl:apply-templates select="//MPMCA"/>
        <!-- appel template de la cote de crédit -->
        <xsl:call-template name="coteDeCredit"/>
        <xsl:if test="//DESCRIPTEUR">
          <xsl:call-template name="TableauBRIDGJES"/>
        </xsl:if>
        <!--</xsl:if>-->
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="INFLUENCANTE">
    <tr>
      <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="Lang" select="$Lang"/>
          <xsl:with-param name="codeLib" select="'m37_EntInf'"/>
        </xsl:call-template>
      </th>
      <td class="clFond clWidth80">
        <xsl:call-template name="displaySirenXsl">
          <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
        </xsl:call-template>
      </td>
      <td class="clFond" colspan="5">
        &#160;<xsl:value-of select="EJ/DENOM"/>
      </td>
    </tr>
    <xsl:if test="not($NonResident='NR')">
      <tr>
        <td class="clWidth130 clHeight14"/>
        <td class="clWidth80 clHeight14"/>
        <td class="clWidth426 clHeight14 clValignMiddle clAlignRight" colspan="5">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="$NonResident='NR'">
      <tr>
        <td class="clWidth130 clHeight14"/>
        <td class="clWidth80 clHeight14"/>
        <td class="clWidth426 clHeight14 clValignMiddle clAlignRight" colspan="5">&#160;</td>
      </tr>
    </xsl:if>
  </xsl:template>
  <xsl:template match="TETEDEGROUPE">
    <tr>
      <th class="clCouleur2 clWidth130 clHeight14 clAlignLeft clThNonGras">
        <xsl:call-template name="tradlib">
          <xsl:with-param name="codeLib" select="'m37_TetGro'"/>
        </xsl:call-template>
      </th>
      <td class="clFond clWidth80 clHeight14">
        <xsl:call-template name="displaySirenXsl">
          <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clHeight14" colspan="5">
        &#160;<xsl:value-of select="EJ/DENOM"/>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="IG01|IG02|IG03|IS02|IS06|IS09|IS10|BIL06|BIL07|BIL08|BIL09" mode="displayLib">
    <tr>
      <td class="clWidth130"/>
      <td class="clTexte clWidth505">
        - <xsl:apply-templates select="."/>
      </td>
    </tr>
  </xsl:template>
  <!--Cote d'activité-->
  <xsl:template match="MPMCA">
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Explication de la cotation d'activité</caption>
      <tr>
        <th class="clCouleurGras clWidth635 clAlignCenter clBoxSizing" colspan="4">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_CotAct'"/>
          </xsl:call-template>
        </th>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth35 clAlignRight clBoxSizing">
          &#160;<xsl:value-of select="substring(//INFOCOTATIONEJ/VALCOT,1,1)"/>&#160;:&#160;
        </td>
        <xsl:apply-templates select="//CA00|CA01|CA02|CA03|CA04|CA05|CA06|CA07|CA08|CA09|CA10|CA11|CA12|CA13|CA14" mode="displayLib"/>
        <th class="clCouleur2 clWidth75 clAlignLeft clThNonGras clBoxSizing">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Attribuee'"/>
          </xsl:call-template>
        </th>
        <td class="clTexte clWidth80 clBoxSizing">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(//DATCA)"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <!--Cote de crédit-->
  <xsl:template name="coteDeCredit">
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Explication de la cotation de crédit</caption>
      <tr>
        <th class="clCouleurGras clWidth635 clAlignCenter clBoxSizing" colspan="2">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_CotCre'"/>
          </xsl:call-template>
        </th>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth35 clAlignRight clBoxSizing">
          &#160;<xsl:value-of select="substring(//INFOCOTATIONEJ/VALCOT,2,3)"/>&#160;:&#160;
        </td>
        <xsl:apply-templates select="//CC01|//MG1P|//MG1|//MG1M|//MG2P|//MG2|//MG2M|//MG3P|//MG3|//MG3M|//MG4P|//MG4|//MG4M|//MG5P|//MG5|//MG5M|//MG6P|//MG6|//MG6M|//MG7|//MG8|//MGP" mode="displayLib"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth470 clBoxSizing">&#160;</td>
        <th class="clCouleur2 clWidth75 clAlignLeft clThNonGras clBoxSizing">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Attribuee'"/>
          </xsl:call-template>          
        </th>
        <td class="clTexte clWidth80 clBoxSizing">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(//DATCC)"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="CA00|CA01|CA02|CA03|CA04|CA05|CA06|CA07|CA08|CA09|CA10|CA11|CA12|CA13|CA14" mode="displayLib">
    <td class="clTexte clWidth435 clAlignLeft clBoxSizing">
      <xsl:apply-templates select="."/>
    </td>
  </xsl:template>
  <xsl:template match="CC01|MG1P|MG1|MG1M|MG2P|MG2|MG2M|MG3P|MG3|MG3M|MG4P|MG4|MG4M|MG5P|MG5|MG5M|MG6P|MG6|MG6M|MG7|MG8|MGP" mode="displayLib">
    <td class="clGrasFond clWidth600">
      <xsl:apply-templates select="."/>
    </td>
  </xsl:template>
  <xsl:template name="TableauBRIDGJES">
    <table class="clWidth635 clBorderCell">
      <xsl:choose>
        <xsl:when test="//COTECC">
          <caption class="visually-hidden">EXPLICATION DE LA COTE DE CREDIT</caption>
          <tr>
            <th class="clCouleurGras clWidth635 clHeight14 clAlignCenter">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_ExpCotcre'"/>
              </xsl:call-template>
            </th>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <caption class="visually-hidden">EXPLICATION DE L'INDICATEUR</caption>
          <tr>
            <th class="clCouleurGras clWidth635 clHeight14 clAlignCenter">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Expindtitre'"/>
              </xsl:call-template>
            </th>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <tr>
        <td class="clCouleur2 clWidth635">&#160;</td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCellpadding2 clTableauExpli">
      <caption class="visually-hidden">EXPLICATION DE LA COTE DE CREDIT</caption>
      <tr>
        <th class="clCouleur2Border clWidth260 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Elementan'"/>
          </xsl:call-template>
        </th>
        <th class="clCouleur2Border clWidth260 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_Observ'"/>
          </xsl:call-template>
        </th>
        <th class="clCouleur2Border clWidth115 clAlignCenter">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_ElementDet'"/>
          </xsl:call-template>
        </th>
      </tr>
      <xsl:variable name="ElemIDetermin" select="//ELEMI/@DETERMIN"/>
      <xsl:variable name="ElemIValeur" select="//ELEMI/@VALEUR"/>
      <xsl:variable name="ElemIMessage" select="//ELEMI/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemIDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
                <xsl:if test="($ElemIValeur = '1') or ($ElemIValeur = '3') or ($ElemIValeur ='5')">
                  <xsl:if test="not($NonResident='NR')">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('29','','2','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 29 (Incidents effets)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemIMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemIDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
                <xsl:if test="($ElemIValeur = '1') or ($ElemIValeur = '3') or ($ElemIValeur ='5')">
                  <xsl:if test="not($NonResident='NR')">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('29','','2','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 29 (incidents effets)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemIMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemIMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurI'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemDDetermin" select="//ELEMD/@DETERMIN"/>
      <xsl:variable name="ElemDValeur" select="//ELEMD/@VALEUR"/>
      <xsl:variable name="ElemDMessage" select="//ELEMD/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemDDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemDValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('51','','3','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '2'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('56','','3','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '3'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('51|56|','','3','',cstMultipleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants) ou Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemDMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemDDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemDValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('51','','3','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '2'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('56','','3','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                  <xsl:if test="$ElemDValeur = '3'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('51|56|','','3','',cstMultipleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 51 (Dirigeants) ou Module 56 (Fonctions de direction)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemDMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemDMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurD'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemGDetermin" select="//ELEMG/@DETERMIN"/>
      <xsl:variable name="ElemGValeur" select="//ELEMG/@VALEUR"/>
      <xsl:variable name="ElemGMessage" select="//ELEMG/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemGDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemGMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemGDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemGMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemGMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurG'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemJDetermin" select="//ELEMJ/@DETERMIN"/>
      <xsl:variable name="ElemJValeur" select="//ELEMJ/@VALEUR"/>
      <xsl:variable name="ElemJMessage" select="//ELEMJ/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemJDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemJMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemJDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemJMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemJMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurJ'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="ElemSDetermin" select="//ELEMS/@DETERMIN"/>
      <xsl:variable name="ElemSValeur" select="//ELEMS/@VALEUR"/>
      <xsl:variable name="ElemSMessage" select="//ELEMS/@MESSAGE"/>
      <xsl:choose>
        <xsl:when test="$ElemSDetermin = 'N'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlanc clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemSValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('45','','3','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 45 (Jugements)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemSMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Non'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:when test="$ElemSDetermin = 'O'">
          <tr>
            <td class="clTableauCelBlanc clValignTop clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelBlancGras clWidth260 clAlignLeft">
              <xsl:if test="$Lang = 'FR'">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
                <xsl:if test="not($NonResident='NR')">
                  <xsl:if test="$ElemSValeur = '1'">
                    <br/>
                    <br/>
                    <a href="#nullePart" onclick="requestBDFInfos('45','','3','',cstSimpleConfirm);" class="clCouleur2">
                      Pour plus de renseignement :&#160;
                      <u>
                        Module 45 (Jugements)
                      </u>
                    </a>
                  </xsl:if>
                </xsl:if>
              </xsl:if>
              <xsl:if test="$Lang = ''">
                <xsl:value-of select="$dictionnaire/mot[@id=$ElemSMessage]"/>
              </xsl:if>
              <xsl:if test="$Lang = 'UK'">
                <xsl:value-of select="$dictionnaireUK/mot[@id=$ElemSMessage]"/>
              </xsl:if>
            </td>
            <td class="clTableauCelBlanc clWidth115 clAlignCenter">
              &#160;<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_Oui'"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td class="clTableauCelGris clvalign clWidth260 clAlignLeft">
              <xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m37_DescripteurS'"/>
              </xsl:call-template>
            </td>
            <td class="clTableauCelGris clWidth260 clAlignLeft">
              &#160;
            </td>
            <td class="clTableauCelGris clWidth115 clAlignCenter">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
      <tr>
        <td class="clCouleur2 clWidth260 clAlignLeft">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m37_DateMaj'"/>
          </xsl:call-template>&#160;
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(//DESCRIPTEUR/DATEDESC)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth260">
          &#160;
        </td>
        <td class="clWidth115">
          &#160;
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- ***********************************  bloc dirigeants ***************************************************************************************************************-->
  <!--********************************************************************************************************************************************************************-->
  <!-- l'arborescence XML a était modifié le 18/08/2008 -->
  <xsl:template match="INFODIRIGEANTS">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS/DIRIGEANTS">
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS/DIRIGEANTS/NBDIRIGEANTDO"/>
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS/DIRIGEANTS/DIRIGEANT"/>
      <xsl:if test="not((//INFODIRIGEANTS/DIRIGEANTS/SUITE) or (//INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ))">
        <xsl:call-template name="shim"/>
      </xsl:if>
    </xsl:if>
    <xsl:if test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS/DIRIGEANTSCESSES">
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS/DIRIGEANTSCESSES/NBDIRIGEANTCESSEDO"/>
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFODIRIGEANTS/DIRIGEANTSCESSES/DIRIGEANTCESSE"/>
      <!--<xsl:apply-templates select="SUITE" />  le template suite est supprimer car il y a deux fois suite au même niveau-->
      <!-- le plus d'infos est donc rajouté à la fin des templates DIRIGEANT ET DIRIGEANTCESSE -->
      <!--<xsl:call-template name="shim"/>-->
      <xsl:if test="not(//INFODIRIGEANTS/DIRIGEANTSCESSES/SUITE)">
        <xsl:call-template name="shim"/>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template match="NBDIRIGEANTDO">
    <a name="Dirigeants"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE (<xsl:value-of select="."/>)<br/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="DIRIGEANT">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">DIRIGEANT(S) ACTIF(S) DE L'ENTREPRISE</caption>
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <tr>
        <xsl:if test="EJ/DENOM">
          <td class="clTexteGras" colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EJ/DENOM)">
          <td class="clTexteGras" colspan="2">
            &#160;<xsl:call-template name="displayInLowerCaseXsl">
              <xsl:with-param name="InputStringNom" select="(PP/IDENTITE/NOM)"/>
              <xsl:with-param name="InputStringPrenom" select="(PP/IDENTITE/PRENOM)"/>
            </xsl:call-template>
          </td>
          <xsl:if test="PP/IDENTITE/NOMCONJ">
            <td class="clCouleur2" colspan="3">
              &#160;Nom marital&#160;&#160;&#160;<span class="clTexte">
                <xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
              </span>
            </td>
          </xsl:if>
          <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
            <td class="clWidth54">&#160;</td>
            <td colspan="2">&#160;</td>
          </xsl:if>
        </xsl:if>
      </tr>
      <xsl:if test="EJ">
        <xsl:variable name="ident" select="EJ/IDENTS"/>
        <xsl:if test="not (FONCTCOT/SEGMENT)">
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
                <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth166"/>
              <th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth315" colspan="3"/>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexteGras clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="FONCTCOT/SEGMENT">
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clFond clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
                <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth81"/>
              <th class="clCouleur2 clWidth145 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clFond clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clFond clWidth315" colspan="3"/>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexteGras clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:if>
      </xsl:if>
      <xsl:if test="PP">
        <xsl:variable name="ident" select="PP/IDENTC"/>
        <tr>
          <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
          <td class="clFond clWidth255">
            &#160;<xsl:value-of select="PP/IDENTC"/>
          </td>
          <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <td class="clFond clWidth166"/>
            <th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Indicateur</th>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
              <td class="clFond clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
              <td class="clFond clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="(FONCTCOT/VALCOT='NS')">
            <td class="clFond clWidth315" colspan="3"/>
          </xsl:if>
        </tr>
        <xsl:choose>
          <xsl:when test="FONCTCOT/AUTRFDEI">
            <tr>
              <td class="clTexte clValignMiddle clAlignLeft" colspan="4">
                &#160;Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
              </td>
              <xsl:if test="not(FONCTCOT/VALCOT='NS')">
                <td class="clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullePart" onclick="requestBDFInfos('56','','1','{$ident}',cstSimpleConfirm);">
                    <img src="{$root}Images/Commun/clignotant2.gif" width="84" border="0" alt="plus d'infos"/>
                  </a>
                </td>
              </xsl:if>
            </tr>
          </xsl:when>
          <xsl:otherwise>
            <tr>
              <td class="clTexteGras clAlignLeft" colspan="4">
                &#160;
              </td>
              <td class="clWidth92">
                &#160;
              </td>
            </tr>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <xsl:call-template name="shim"/>
    </table>
    <xsl:if test="position() mod 9 = 0">
      <div class="clBreakPage"/>
    </xsl:if>
    <xsl:if test="position() = last()">
      <xsl:if test="//INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ">
        <xsl:call-template name="shim"/>
        <xsl:apply-templates select="//INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ"/>
        <xsl:call-template name="shim"/>
      </xsl:if>
      <xsl:if test="not(//INFODIRIGEANTS/DIRIGEANTS/AUTRFDEJ)">
        <xsl:if test="//INFODIRIGEANTS/DIRIGEANTS/SUITE">
          <xsl:call-template name="shim"/>
          <table class="clWidth635 clBorderCell">
            <tr>
              <td class="clCouleur2 clWidth530 clHeight14" colspan="4"/>
              <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('51','','1','{/FIBEN/PERSONNE/MODULEAN/EJ/IDENTS}',cstSimpleConfirm);">
                  <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
                </a>
              </td>
            </tr>
          </table>
          <xsl:call-template name="shim"/>
        </xsl:if>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template match="AUTRFDEJ">
    <table class="clWidth635 clBorderCell clCouleur2" role="presentation">
      <tr>
        <td class="clAlignLeft clWidth522">
          <br/> « Le(s) responsable(s) légal(aux) de cette entreprise détienne(nt) d&#039;autres fonctions de représentant(s) légal(aux)»
        </td>
        <td class="clWidth103 clAlignRight">
          <a href="#nullepart" onclick="requestBDFInfos('51','','','',cstSimpleConfirm);">
            <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
          </a>
        </td>
      </tr>
    </table>
    <!--<xsl:call-template name="shim"/>-->
  </xsl:template>
  <xsl:template match="NBDIRIGEANTCESSEDO">
    <a name="ancCesse"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          DIRIGEANT(S) DE L'ENTREPRISE AYANT CESS&#201; SON(LEUR) ACTIVIT&#201; (<xsl:value-of select="."/>)<br/>
          <!--<xsl:call-template name="shim"/>-->
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="DIRIGEANTCESSE">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">DIRIGEANT(S) DE L'ENTREPRISE AYANT CESSÉ SON(LEUR) ACTIVITÉ</caption>
      <tr>
        <td class="clGrasFond" colspan="2">
          <xsl:apply-templates select="FONCTCOT"/>
        </td>
        <xsl:if test="FONCTCOT/DATFONCT">
          <th class="clFond clAlignRight clThNonGras" colspan="2"> Depuis le :</th>
          <td class="clFond clWidth90 clAlignRight">
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(FONCTCOT/DATFONCT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/DATFONCT)">
          <td colspan="2" class="clFond">&#160;</td>
          <td class="clFond clWidth90">&#160;</td>
        </xsl:if>
        <xsl:if test="position() mod 3 = 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td class="clWidth103 clAlignRight" rowspan="3">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <xsl:apply-templates select="CESSATION"/>
      <tr>
        <xsl:if test="EJ/DENOM">
          <td class="clGrasFond" colspan="5">
            &#160;<xsl:value-of select="EJ/DENOM"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EJ/DENOM)">
          <td class="clGrasFond" colspan="2">
            &#160;<xsl:call-template name="displayInLowerCaseXsl">
              <xsl:with-param name="InputStringNom" select="(PP/IDENTITE/NOM)"/>
              <xsl:with-param name="InputStringPrenom" select="(PP/IDENTITE/PRENOM)"/>
            </xsl:call-template>
          </td>
          <xsl:if test="PP/IDENTITE/NOMCONJ">
            <td colspan="3">
              <table class="clWidthMax clBorderCell">
                <th class="clCouleur2 clWidth77 clAlignLeft clThNonGras">&#160;Nom marital</th>
                <td class="clFond clAlignLeft" colspan="2">
                  &#160;
                  <xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
                </td>
              </table>
            </td>
          </xsl:if>
          <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
            <td class="clFond clWidth54">&#160;</td>
            <td colspan="2" class="clFond">&#160;</td>
          </xsl:if>
        </xsl:if>
      </tr>
      <xsl:if test="EJ">
        <xsl:variable name="ident" select="EJ/IDENTS"/>
        <xsl:if test="FONCTCOT/SEGMENT">
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clTexte clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
                <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <td class="clTexte clWidth81"/>
              <th class="clCouleur2 clWidth145 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="FONCTCOT/SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clTexte" colspan="3"/>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexte clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="not(FONCTCOT/SEGMENT)">
          <tr>
            <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
            <td class="clTexte clWidth255">
              &#160;<xsl:call-template name="displaySirenXsl">
                <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
              </xsl:call-template>
            </td>
            <xsl:if test="not(FONCTCOT/VALCOT='NS')">
              <td class="clTexte clWidth166"/>
              <th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test="not(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(FONCTCOT/VALCOT='ND')">
                <td class="clTexte clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                    <u>
                      <xsl:value-of select="FONCTCOT/VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='NS')">
              <td class="clTexte" colspan="3"/>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexte clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth92">
              &#160;
            </td>
          </tr>
        </xsl:if>
      </xsl:if>
      <xsl:if test="PP">
        <xsl:variable name="ident" select="PP/IDENTC"/>
        <tr>
          <th class="clCouleur2 clWidth59 clAlignLeft clValignMiddle clThNonGras">&#160;Identifiant</th>
          <td class="clTexte clWidth255">
            &#160;<xsl:value-of select="PP/IDENTC"/>
          </td>
          <xsl:if test="not(FONCTCOT/VALCOT='NS')">
            <td class="clTexte clWidth166"/>
            <th class="clCouleur2 clWidth60 clAlignLeft clThNonGras">&#160;Indicateur</th>
            <xsl:if test="not(FONCTCOT/VALCOT='ND')">
              <td class="clTexte clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotation,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(FONCTCOT/VALCOT='ND')">
              <td class="clTexte clWidth89 clValignMiddle clAlignRight">
                &#160;<a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{FONCTCOT/VALCOT}',cstCotationNonDif,'{$ident}')">
                  <u>
                    <xsl:value-of select="FONCTCOT/VALCOT"/>
                  </u>
                </a>
              </td>
            </xsl:if>
          </xsl:if>
          <xsl:if test="(FONCTCOT/VALCOT='NS')">
            <td class="clTexte"/>
          </xsl:if>
        </tr>
        <xsl:choose>
          <xsl:when test="FONCTCOT/AUTRFDEI">
            <tr>
              <td class="clTexte clValignMiddle clAlignLeft" colspan="4">
                &#160;Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
              </td>
              <xsl:if test="not(FONCTCOT/VALCOT='NS')">
                <td class="clWidth89 clValignMiddle clAlignRight">
                  &#160;<a href="#nullePart" onclick="requestBDFInfos('56','','1','{$ident}',cstSimpleConfirm);">
                    <img src="{$root}Images/Commun/clignotant2.gif" width="84" border="0" alt="plus d'infos"/>
                  </a>
                </td>
              </xsl:if>
            </tr>
          </xsl:when>
          <xsl:otherwise>
            <tr>
              <td class="clTexte clAlignLeft" colspan="4">
                &#160;
              </td>
              <td class="clWidth92">
                &#160;
              </td>
            </tr>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <xsl:call-template name="shim"/>
    </table>
    <xsl:if test="position() = last()">
      <xsl:if test="//INFODIRIGEANTS/DIRIGEANTSCESSES/SUITE">
        <xsl:call-template name="shim"/>
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="clCouleur2 clWidth530 clHeight14" colspan="4"/>
            <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
              <a href="#nullepart" onClick="requestBDFInfos('51','','1','{/FIBEN/PERSONNE/MODULEAN/EJ/IDENTS}',cstSimpleConfirm);">
                <img src="{$root}images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
              </a>
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
      </xsl:if>
      <xsl:if test="position() mod 10 = 0">
        <div class="clBreakPage"/>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template match="CESSATION">
    <tr>
      <td class="clTexte" colspan="2">
        &#160;<xsl:call-template name="traduction">
          <xsl:with-param name="code" select="@COCESS"/>
        </xsl:call-template>
      </td>
      <xsl:if test="@DATCESS != ''">
        <th class="clTexte clAlignRight clThNonGras" colspan="2"> Cess&#233;(e) depuis le :</th>
        <td class="clTexte clAlignRight clWidth90">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(@DATCESS)"/>
          </xsl:call-template>
        </td>
      </xsl:if>
      <xsl:if test="not(@DATCESS)">
        <td colspan="2" class="clFond">&#160;</td>
        <td class="clTexte clWidth90">&#160;</td>
      </xsl:if>
    </tr>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!--*********************************    Bloc associe(s)    *************************************************************************************-->
  <!--********************************************************************************************************************************************************************-->
  <xsl:template match="INFOASSOCIES">
    <xsl:apply-templates select="NBASSOCIEDO"/>
    <xsl:apply-templates select="ASSOCIE"/>
  </xsl:template>
  <xsl:template match="NBASSOCIEDO">
    <a name="ancAssocies"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth631" colspan="7">
          PRINCIPAL(AUX) ASSOCIE(S) (<xsl:value-of select="."/>)
        </td>
        <td/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="ASSOCIE">
    <xsl:apply-templates select="CAPITAL">
      <xsl:with-param name="indice" select="position()"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="ASSOCSPE|ASSOCPP|ASSOCEJ"/>
  </xsl:template>
  <xsl:template match="CAPITAL">
    <xsl:param name="indice"/>
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">Principal(aux) associé(s). Pourcentage de capital détenu</caption>
      <tr>
        <th class="clCouleur2 clWidth121 clAlignLeft clThNonGras">&#160;Pourcentage détenu</th>
        <td class="clFond clWidth114">
          &#160;<xsl:value-of select="POURCENTAGE"/>
        </td>
        <td class="clFond clWidth57">&#160;</td>
        <td class="clFond clWidth171 clAlignRight">&#160;</td>
        <xsl:if test="DATDET">
          <th class="clFond clWidth60 clAlignRight clThNonGras">&#160;Depuis le</th>
          <td class="clFond clWidth89 clAlignRight">
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(DATDET)"/>
            </xsl:call-template>&#160;
          </td>
        </xsl:if>
        <xsl:if test="not(DATDET)">
          <td class="clFond clWidth60 clAlignRight">&#160;</td>
          <td class="clFond clWidth89 clAlignRight">&#160;</td>
        </xsl:if>
        <xsl:if test="$indice mod 3 = 0">
          <td class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
            </a>
          </td>
        </xsl:if>
        <xsl:if test="$indice mod 3 != 0">
          <td class="clWidth103 clAlignRight">
            &#160;
          </td>
        </xsl:if>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="ASSOCSPE">
    <table class="clWidth636 clBorderCell">
      <caption class="visually-hidden">Associé(s) spécial(aux)</caption>
      <tr class="clAlignLeft clValignMiddle">
        <td colspan="2" class="clGras">
          &#160;<xsl:value-of select="DENOM"/>
        </td>
        <td class="clWidth57"/>
        <td colspan="3"/>
      </tr>
      <tr>
        <td colspan="4">
          &#160;
        </td>
        <td class="clWidth95">
          &#160;
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="ASSOCPP">
    <table class="clWidth636 clBorderCell">
      <caption class="visually-hidden">Associé personne physique</caption>
      <tr>
        <td colspan="2" class="clGras">
          &#160;<xsl:call-template name="displayInLowerCaseXsl">
            <xsl:with-param name="InputStringNom" select="(PP/IDENTITE/NOM)"/>
            <xsl:with-param name="InputStringPrenom" select="(PP/IDENTITE/PRENOM)"/>
          </xsl:call-template>
        </td>
        <xsl:if test="PP/IDENTITE/NOMCONJ">
          <th class="clCouleur2 clWidth77 clAlignLeft clThNonGras">&#160;Nom marital</th>
          <td class="clTexte" colspan="3">
            &#160;<xsl:value-of select="PP/IDENTITE/NOMCONJ"/>
          </td>
        </xsl:if>
        <xsl:if test="not(PP/IDENTITE/NOMCONJ)">
          <td class="clCouleur2 clWidth57">&#160;</td>
          <td class="clTexte" colspan="3">&#160;</td>
        </xsl:if>
      </tr>
      <xsl:choose>
        <xsl:when test="AUTRFDEI">
          <tr class="clValignMiddle">
            <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
            <td class="clFond clWidth182 clAlignLeft">
              &#160;<xsl:value-of select="PP/IDENTC"/>
            </td>
            <xsl:if test="not(VALCOT='NS')">
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|56|','','1','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(VALCOT='NS')">
              <td class="clFond clWidth80"/>
              <td class="clFond clWidth118"/>
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexte clAlignLeft" colspan="4">
              &#160;Présence d&#039;autre(s) fonction(s) de représentant(s) légal(aux) exercée(s)
            </td>
            <td class="clWidth95">
              &#160;
            </td>
          </tr>
        </xsl:when>
        <xsl:otherwise>
          <tr class="clValignMiddle">
            <th class="clCouleur2 clWidth130 clAlignLeft clThNonGras">&#160;Identifiant </th>
            <td class="clFond clWidth182 clAlignLeft">
              &#160;<xsl:value-of select="PP/IDENTC"/>
            </td>
            <xsl:if test="not(VALCOT='NS')">
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Indicateur</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clFond clWidth118 clAlignLeft">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{PP/IDENTC}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','1','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
            <xsl:if test="(VALCOT='NS')">
              <td class="clFond clWidth80"/>
              <td class="clFond clWidth118"/>
              <td class="clFond clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27','','1','{PP/IDENTC}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:if>
          </tr>
          <tr>
            <td class="clTexteGras clAlignLeft" colspan="4">
              &#160;
            </td>
            <td class="clWidth95">
              &#160;
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="ASSOCEJ">
    <table class="clWidth636 clBorderCell">
      <caption class="visually-hidden">Associé entité juridique</caption>
      <tr>
        <td colspan="3" class="clGras">
          &#160;<xsl:value-of select="EJ/DENOM"/>
        </td>
        <td class="clCouleur2 clWidth114" colspan="3"/>
      </tr>
      <tr>
        <td class="clFond clAlignLeft" colspan="6">
          &#160;<xsl:value-of select="LOCALI"/>
        </td>
      </tr>
    </table>
    <xsl:if test="SEGMENT">
      <table class="clWidth636 clBorderCell">
        <tr class="clAlignLeft clValignMiddle">
          <th class="clCouleur2 clWidth121 clHeight16 clAlignLeft clThNonGras">&#160;Identifiant </th>
          <td class="clTexte clWidth114 clAlignLeft">
            &#160;<xsl:call-template name="displaySirenXsl">
              <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
            </xsl:call-template>
          </td>
          <td class="clTexte" colspan="2"/>
          <xsl:variable name="locali" select="LOCALI"/>
          <xsl:choose>
            <!--Test si le début de la localité est un code postal -> Résident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth145 clAlignLeft clThNonGras">&#160;Cotation | Segmentation</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clTexte clWidth89 clAlignRight">
                  <a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clTexte clWidth89 clAlignRight">
                  <a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <td class="clWidth145 clAlignLeft">&#160;</td>
              <td class="clWidth89 clAlignRight">
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;
                  <u>
                    <xsl:value-of select="SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td colspan="4">
            &#160;
          </td>
          <td class="clWidth95">
            &#160;
          </td>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test="not (SEGMENT)">
      <table class="clWidth636 clBorderCell">
        <tr class="clAlignLeft clValignMiddle">
          <th class="clCouleur2 clWidth130 clHeight16 clAlignLeft clThNonGras">&#160;Identifiant </th>
          <td class="clTexte clWidth182 clAlignLeft">
            &#160;<xsl:call-template name="displaySirenXsl">
              <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
            </xsl:call-template>
          </td>
          <td class="clTexte" colspan="2"/>
          <xsl:variable name="locali" select="LOCALI"/>
          <xsl:choose>
            <!--Test si le début de la localité est un code postal -> Résident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth80 clAlignLeft clThNonGras">&#160;Cotation</th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clTexte clWidth118 clAlignLeft">
                  <a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clTexte clWidth118 clAlignLeft">
                  <a href="#nullepart" class="clTexte" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <td class="clTexte clWidth95 clAlignRight">
                <a href="#nullepart" onClick="requestBDFInfos('27|37|53|','','{$familyNumber}','{EJ/IDENTS}',cstMultipleConfirm);">
                  <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" title="Plus d'infos" alt="Plus d'infos" border="0"/>
                </a>
              </td>
            </xsl:when>
            <xsl:otherwise>
              <td class="clWidth60 clAlignLeft">&#160;</td>
              <td class="clWidth89 clAlignRight"/>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td colspan="4">
            &#160;
          </td>
          <td class="clWidth95">
            &#160;
          </td>
        </tr>
      </table>
    </xsl:if>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!--*********************************    Bloc participations    *************************************************************************************-->
  <!--************************************************************************************************************************************************************-->
  <xsl:template match="INFOPARTICIPATIONS">
    <xsl:apply-templates select="NBPARTICIPATIONDO"/>
    <xsl:apply-templates select="PARTICIPATION"/>
  </xsl:template>
  <xsl:template match="NBPARTICIPATIONDO">
    <div class="clBreakPage"/>
    <a name="ancParticipation"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">PRINCIPALE(S) PARTICIPATION(S)</caption>
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          PRINCIPALE(S) PARTICIPATION(S) (<xsl:value-of select="."/>)
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="PARTICIPATION">    
    <xsl:call-template name="CAPITALP">
      <xsl:with-param name="indice" select="position()"/>
    </xsl:call-template>
    <tr>
      <td class="clGras" colspan="6">
        &#160;<xsl:value-of select="EJ/DENOM"/>
      </td>
    </tr>
    <tr class="clAlignLeft clValignMiddle">
      <th class="clCouleur2 clWidth125 clAlignLeft clThNonGras">&#160;Identifiant</th>
      <td class="clFond clWidth117 clAlignLeft">
        &#160;<xsl:call-template name="displaySirenXsl">
          <xsl:with-param name="InputSiren" select="(EJ/IDENTS)"/>
        </xsl:call-template>
      </td>
      <td class="clFond clWidth155">
        &#160;<xsl:value-of select="LOCALI"/>
      </td>
      <xsl:choose>
        <xsl:when test="SEGMENT">
          <xsl:variable name="locali" select="LOCALI"/>
          <xsl:choose>
            <!--Test si le début de la localité est un code postal -> Résident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth141 clAlignRight clThNonGras">Cotation | Segmentation </th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clFond clWidth91 clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clFond clWidth91 clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                  <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                    &#160;|&#160;
                    <u>
                      <xsl:value-of select="SEGMENT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <td class="clWidth141 clAlignRight"/>
              <td class="clWidth91 clAlignRight">
                <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('segmentation',cstSegment);">
                  &#160;|&#160;
                  <u>
                    <xsl:value-of select="SEGMENT"/>
                  </u>
                </a>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="locali" select="LOCALI"/>
          <xsl:choose>
            <!--Test si le début de la localité est un code postal -> Résident ou non-->
            <xsl:when test="(number(substring(LOCALI,0,5)) or ($locali='MC MONACO'))">
              <th class="clCouleur2 clWidth141 clAlignRight clThNonGras">Cotation </th>
              <xsl:if test="not(VALCOT='ND')">
                <td class="clFond clWidth91 clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotation,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
              <xsl:if test="(VALCOT='ND')">
                <td class="clFond clWidth91 clAlignRight">
                  &#160;<a href="#nullepart" class="clFond" onclick="requestVariousInfos('{VALCOT}',cstCotationNonDif,'{EJ/IDENTS}');">
                    <u>
                      <xsl:value-of select="VALCOT"/>
                    </u>
                  </a>
                </td>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <td class="clWidth141 clAlignRight"/>
              <td class="clWidth91 clAlignRight"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
    <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
    <xsl:if test="position() = last()">
      <xsl:if test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOPARTICIPATIONS/SUITEP">
        <table class="clWidth635 clBorderCell" role="presentation">
          <tr>
            <td class="clCouleur2 clWidth530 clHeight14" colspan="4"/>
            <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
              <a href="#nullepart" onClick="requestBDFInfos('53','','1','{/FIBEN/PERSONNE/MODULEAN/EJ/IDENTS}',cstSimpleConfirm);">
                <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
              </a>
            </td>
          </tr>
        </table>
      </xsl:if>
    </xsl:if>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template name="CAPITALP">
    <xsl:param name="indice"/>
    <xsl:variable name="actbdf" select="ACTBDF"/>
    <xsl:text disable-output-escaping="yes">&lt;table width=&quot;739&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
    <tr>
      <th class="clCouleur2 clWidth125 clAlignLeft clThNonGras">&#160;Pourcentage détenu</th>
      <td class="clFond clWidth117">
        &#160;<xsl:value-of select="CAPITAL/POURCENTAGE"/>
      </td>
      <xsl:if test="CAPITAL/DATDET">
        <td class="clFond clWidth141">
          &#160;Depuis le&#160;<xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(CAPITAL/DATDET)"/>
          </xsl:call-template>
        </td>
      </xsl:if>
      <xsl:if test="not(CAPITAL/DATDET)">
        <td class="clFond clWidth60 clAlignRight">&#160;</td>
        <td class="clFond clWidth156 clAlignRight">&#160;</td>
      </xsl:if>
      <th class="clCouleur2 clWidth155 clAlignRight clThNonGras">&#160;Activité BDF&#160;</th>
      <td class="clFond clWidth91 clAlignRight">
        <a href="#nullepart" class="clTexte" onclick="requestInfosLibelle('{$actbdf}',cstWordingNew)">
          <u>
            <xsl:value-of select="ACTBDF"/>
          </u>
        </a>
      </td>
      <xsl:if test="$indice mod 3 = 0">
        <td class="clWidth110 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </xsl:if>
      <xsl:if test="$indice mod 3 != 0">
        <td class="clWidth110 clAlignRight">
          &#160;
        </td>
      </xsl:if>
    </tr>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- *********************************    Bloc EVENEMENT MARQUANT, DERNIER JUGEMENT ************************************************************************************-->
  <!-- ************************************************************************************************************************************************************-->
  <xsl:template match="INFOEVMEVJAN">
    <a name="ancEffet"/>
    <xsl:if test="EVMARQ or JUGEMENTS/JUGEMENT/EVJUD">
      <table class="clBorderCell clWidth739" role="presentation">
        <tr class="clAlignCenter">
          <td colspan="6" class="clCouleurGras">
            ÉVÉNEMENT(S) MARQUANT(S) ET JUDICIAIRE (S)
            <br/>
          </td>
          <td class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
            </a>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
    <xsl:apply-templates select="EVMARQ"/>
    <xsl:apply-templates select="IEVJ01" mode="genMessage"/>
    <xsl:if test="JUGEMENTS/JUGEMENT/EVJUD">
      <table class="clBorderCell clWidth739">
        <caption class="visually-hidden">Dernier(s) jugement(s)</caption>
        <tr>
          <td class="clCouleur2 clWidth255" colspan="6">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'mAN_DerJug'"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <xsl:apply-templates select="JUGEMENTS/JUGEMENT/EVJUD"/>
    </xsl:if>
    <xsl:apply-templates select="JUGEMENTS/PEVJANT" mode="genMessage"/>
  </xsl:template>
  <xsl:template match="EVMARQ">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;739&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th class="clCouleur2 clWidth255 clAlignLeft clThNonGras" colspan="6">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_DerEve'"/>
          </xsl:call-template>
        </th>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth20 clAlignLeft clThNonGras">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Le'"/>
          </xsl:call-template>
        </th>
        <td class="clFond clWidth110">
          &#160;<xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(DATEVM)"/>
          </xsl:call-template>&#160;
        </td>
        <xsl:if test="EVMDO">
          <td class="clFond" colspan="2">
            <xsl:apply-templates select="EVMDO"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EVMDO)">
          <td class="clFond clWidth518" colspan="3">
            <xsl:apply-templates select="EVMC|EVMCD|EVMCI|EVMD|EVMDC|EVMDO|EVME|EVMJ|EVMJM|EVMM|EVMR|EVMS|EVMV"/>
          </td>
        </xsl:if>
        <xsl:apply-templates select="IDENTS" mode="clFond"/>
        <td class="clWidth90 clAlignRight">
        </td>
      </tr>
      <xsl:call-template name="savoirSirenAbsorbant"/>
      <xsl:if test="count(//EVMARQ)=1">
        <!-- Mise en place d'un trait de fin de tableau dans le cas ou il n'y a que 1 événement marquant -->
        <tr>
          <td class="clTexte" colspan="8">
            <xsl:call-template name="shim"/>
          </td>
        </tr>
        <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      </xsl:if>
    </xsl:if>
    <xsl:if test="position()=2">
      <!-- Mise en place d'un trait de séparation entre les 2événements marquant-->
      <tr>
        <td class="clTexte" colspan="8">
          <xsl:call-template name="shim"/>
        </td>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth20">
          <xsl:call-template name="tradlib">
            <xsl:with-param name="Lang" select="$Lang"/>
            <xsl:with-param name="codeLib" select="'m27_Le'"/>
          </xsl:call-template>
        </td>
        <td class="clFond clWidth110">
          &#160;<xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(DATEVM)"/>
          </xsl:call-template>&#160;
        </td>
        <xsl:if test="EVMDO">
          <td class="clFond" colspan="2">
            <xsl:apply-templates select="EVMDO"/>
          </td>
        </xsl:if>
        <xsl:if test="not(EVMDO)">
          <td class="clFond clWidth518" colspan="3">
            <xsl:apply-templates select="EVMC|EVMCD|EVMCI|EVMD|EVMDC|EVMDO|EVME|EVMJ|EVMJM|EVMM|EVMR|EVMS|EVMV"/>
          </td>
        </xsl:if>
        <xsl:apply-templates select="IDENTS" mode="clFond"/>
        <td class="clWidth90 clAlignRight">

        </td>
      </tr>
      <xsl:call-template name="savoirSirenAbsorbant"/>
      <!-- Mise en place d'un trait de fin de tableau dans le cas ou il y a 2 événements marquants -->
      <tr>
        <td class="clTexte" colspan="8">
          <xsl:call-template name="shim"/>
        </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <xsl:template name="savoirSirenAbsorbant">
    <xsl:if test="IDENTS">
      <xsl:if test="not($NonResident='NR')">
        <tr>
          <td class="clWidth20">&#160;</td>
          <td class="clWidth110">&#160;</td>
          <td class="clWidth125">&#160;</td>
          <td class="clWidth130">&#160;</td>
          <td class="clWidth125 clHeight12">
            <a href="#nullepart" onclick="requestBDFInfos('27','','1','{IDENTS[1]}',cstSimpleConfirm);">
              <img align="middle" border="0" height="12" name="ev1" src="{$root}images/Commun/clignotant2.gif" width="85" alt="plus d'infos"/>
            </a>
          </td>
          <xsl:if test="IDENTS[2]">
            <td class="clWidth125 clHeight12">
              <a href="#nullepart" onclick="requestBDFInfos('27','','1','{IDENTS[2]}',cstSimpleConfirm);">
                <img align="middle" border="0" height="12" name="ev2" src="{$root}images/Commun/clignotant2.gif" width="85" alt="plus d'infos"/>
              </a>
            </td>
          </xsl:if>
          <xsl:if test="not(IDENTS[2])">
            <td class="clWidth125 clHeight12">&#160;</td>
          </xsl:if>
        </tr>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template match="EVMARQ/IDENTS" mode="clFond">
    <td class="clFond clWidth125">
      <xsl:call-template name="displaySirenXsl">
        <xsl:with-param name="InputSiren" select="(.)"/>
      </xsl:call-template>
    </td>
    <xsl:if test="position()=1 and position()=last()">
      <td class="clFond clWidth125">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="EVMARQ/IDENTS" mode="clTexte">
    <td class="clTexte clWidth125">
      <xsl:call-template name="displaySirenXsl">
        <xsl:with-param name="InputSiren" select="(.)"/>
      </xsl:call-template>
    </td>
    <xsl:if test="position()=1 and position()=last()">
      <td class="clTexte clWidth125">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="JUGEMENTS/JUGEMENT/EVJUD">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">Evènement(s) marquant(s) </caption>
      <tr>
        <td colspan="6" class="clGrasFond">
          <xsl:apply-templates select="EVJAM|EVJAP|EVJCM|EVJCP|EVJCT|EVJCV|EVJDM|EVJDU|EVJEM|EVJFM|EVJFP|EVJGA|EVJGD|EVJGO|EVJGR|EVJHC|EVJHM|EVJIA|EVJIC|EVJIG|EVJIM|EVJIP|EVJIT|EVJLB|EVJLG|EVJLJ|EVJLM|EVJPA|EVJPC|EVJPM|EVJPO|EVJPV|EVJRC|EVJRD|EVJRG|EVJRJ|EVJRL|EVJRM|EVJRP|EVJRR|EVJRS|EVJSM|EVJAC|EVJCR|EVJOS|EVJOB|EVJPS|EVJRPS|EVJOD|EVJOT|EVJOP|EVJPT|EVJRT|EVJMC"/>
        </td>
        <xsl:if test="position() mod 3 = 0">
          <td rowspan="13" class="clWidth103 clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
            </a>
          </td>
        </xsl:if>
        <xsl:if test="position() mod 3 != 0">
          <td rowspan="13" class="clWidth103 clAlignRight">
            &#160;
          </td>
        </xsl:if>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth30 clAlignLeft clThNonGras">&#160;Le</th>
        <td class="clTexte clWidth90">
          &#160;<xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(DATEVJ)"/>
          </xsl:call-template>
        </td>
        <th class="clCouleur2 clWidth120 clAlignRight clThNonGras">
          <xsl:if test="DATECHJUG">
            Jusqu'au&#160;&#160;
          </xsl:if>
        </th>
        <td class="clTexte clWidth108">
          &#160;
          <xsl:if test="DATECHJUG">
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(DATECHJUG)"/>
            </xsl:call-template>
          </xsl:if>
        </td>
        <xsl:if test="../TRIBU">
          <th class="clCouleur2 clWidth100 clAlignLeft clThNonGras">&#160;Tribunal</th>
          <td class="clTexte clWidth187">
            &#160;<xsl:value-of select="../TRIBU"/>
          </td>
        </xsl:if>
        <xsl:if test="not(../TRIBU)">
          <td class="clCouleur2 clWidth100">&#160;</td>
          <td class="clTexte clWidth187">&#160;</td>
        </xsl:if>
      </tr>
      <xsl:if test="not(DATECHJUG)">
        <tr>
          <xsl:if test="/FIBEN/PERSONNE/MODULEAN/*//IDENTC">
            <td class="clAlignRight" colspan="6">
            </td>
          </xsl:if>
          <xsl:if test="not(/FIBEN/PERSONNE/MODULEAN/*//IDENTC)">
            <td class="clAlignRight" colspan="6">

            </td>
          </xsl:if>
        </tr>
      </xsl:if>
      <xsl:if test="not(position()=1)">
        <xsl:call-template name="shim"/>
      </xsl:if>
    </table>
  </xsl:template>
  <xsl:template match="PEVJANT" mode="genMessage">
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignLeft">
        <td class="clCouleur2 clWidthMax">
          <xsl:apply-templates select="."/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="IEVJ01" mode="genMessage">
    <table class="clBorderCell clWidth739" role="presentation">
      <xsl:apply-templates select="."/>
      <br/>
    </table>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- *********************************    Bloc INCIDENTS DE PAIEMENT ************************************************************************************-->
  <!-- ************************************************************************************************************************************************************-->
  <xsl:template match="INFOIMPAYESRESUM">
    <a name="ancIPE"/>
    <xsl:if test="not(CIP01)">
      <div class="clBreakPage"/>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth635 clAlignCenter">
            INCIDENTS DE PAIEMENT
            SUR EFFETS DE COMMERCE
          </td>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test="CIP01">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clTexte">
            <span class="clCouleur2">
              <xsl:apply-templates select="CIP01"/>
            </span>
          </td>
        </tr>
      </table>
    </xsl:if>
    <xsl:apply-templates select="IPERESUME"/>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="IPERESUME">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth19">&#160;</td>
        <td class="clCouleur2b clWidth597 clAlignCenter">
          SITUATION RÉSUMÉE SUR 15 MOIS&#160;(en
          <xsl:call-template name="displayUnitXsl">
            <xsl:with-param name="InputUnit" select="(./@UNITE)"/>
          </xsl:call-template>
          euros)
        </td>
        <td class="clWidth19">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">Incidents de paiement sur effets de commerce. Situation résumée sur 15 mois</caption>
      <tr>
        <td class="clCouleur2 clValignTop clWidth110 clAlignRight">&#160;</td>
        <th colspan="2" class="clCouleur2 clWidth210 clAlignRight clThNonGras">
          Incapacité
          de payer&#160;&#160;&#160;&#160;&#160;&#160;
        </th>
        <th colspan="2" class="clCouleur2 clWidth210 clAlignRight clThNonGras">
          Contestation de
          créance&#160;&#160;&#160;
        </th>
        <td class="clCouleur2 clWidth105 clAlignRight clValignTop">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth110 clAlignRight clThNonGras">Mois&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Nombre&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Montant&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Nombre&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clHeight17 clThNonGras">Montant&#160;</th>
        <th class="clCouleur2 clWidth105 clAlignRight clThNonGras">Total&#160;</th>
      </tr>
      <xsl:apply-templates select="SITRESM"/>
      <xsl:apply-templates select="SITREST"/>
    </table>
    <!--<div class="clBreakPage"/>-->
  </xsl:template>
  <xsl:template match="SITRESM">
    <tr class="clAlignRight">
      <xsl:if test="position() mod 2 = 0">
        <td class="clTexte clWidth110">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(MOISREF)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(NBIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(MTIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(NBCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexte clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(MTCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clTexteGras clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(MTMIPE)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:if>
      <xsl:if test="position() mod 2 != 0">
        <td class="clFond clWidth110">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(MOISREF)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(NBIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(MTIP)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(NBCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(MTCC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clGrasFond clWidth105">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(MTMIPE)"/>
          </xsl:call-template>&#160;
        </td>
      </xsl:if>
    </tr>
  </xsl:template>
  <xsl:template match="SITREST">
    <tr class="clAlignRight">
      <td class="clTexte clWidth110">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="clTexte clWidth105">&#160;</td>
      <td class="t3b clWidth105">&#160;</td>
    </tr>
    <tr class="clAlignRight">
      <td class="clCouleur2 clWidth110">Total&#160;</td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(TOTNBIP)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(TOTMTIP)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(TOTNBCC)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(TOTMTCC)"/>
        </xsl:call-template>&#160;
      </td>
      <td class="clGrasFond clWidth105">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(TOTSEIPE)"/>
        </xsl:call-template>&#160;
      </td>
    </tr>
  </xsl:template>
  <!--********************************************************************************************************************************************************************-->
  <!-- *********************************    Bloc CONCOURS BANCAIRES- SOURCES DE FINANCEMENT************************************************************************************-->
  <!-- ************************************************************************************************************************************************************-->
  <xsl:template match="INFORISQUESAN">
    <a name="ancConcours"/>
    <xsl:choose>
      <xsl:when test="ICB10">
        <table class="clBorderCell clWidth739" role="presentation">
          <tr>
            <td class="clCouleur2 clWidth635">
              <xsl:value-of select="($dictionnaire/mot[@id='ICB10'])"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
      </xsl:when>
      <xsl:otherwise>
        <!--<div class="clBreakPage"></div>-->
        <table class="clBorderCell clWidth739" role="presentation">
          <tr class="clAlignCenter">
            <td class="clCouleurGras clWidth602">SOURCES DE FINANCEMENT (EN MILLIERS D'EUROS)</td>
            <td class="clWidth34"> </td>
            <td class="clWidth103 clAlignRight">
              <a href="#ancHaut">
                <img src="{$root}images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
              </a>
            </td>
          </tr>
        </table>
        <xsl:call-template name="shim"/>
        <br/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/DATCENTR"/>        
        <xsl:if test="not(/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB01)">
          <table class="clBorderCell clWidth739" role="presentation">
            <tr class="clAlignCenter">
              <td class="clCouleurGras clWidth602">CONCOURS BANCAIRES</td>
              <td class="clWidth34"> </td>
              <td class="clWidth103 clAlignRight">
                <a href="#ancHaut">
                  <img src="{$root}images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
                </a>
              </td>
            </tr>
          </table>
          <xsl:call-template name="shim"/>
        </xsl:if>
        <!-- appel des différentes parties des risques-->
        <xsl:if test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CBEURO">
          <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CBEURO"/>
        </xsl:if>
        <xsl:choose>
          <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB05">
            <xsl:call-template name="ICB05"/>
            <xsl:call-template name="shim"/>
          </xsl:when>
          <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB01">
            <xsl:call-template name="ICB01"/>
            <xsl:call-template name="shim"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB04">
                <xsl:call-template name="CUMULCB"/>
                <xsl:call-template name="ICB04"/>
                <xsl:call-template name="shim"/>
              </xsl:when>
              <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB03">
                <xsl:call-template name="ICB03"/>
                <xsl:call-template name="shim"/>
                <xsl:call-template name="CUMULCBC"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="CUMULCB"/>
                <xsl:call-template name="CUMULCBC"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB06">
            <xsl:call-template name="ICB06"/>
            <xsl:call-template name="shim"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="CUMULCIFP"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB07">
            <xsl:call-template name="ICB07"/>
            <xsl:call-template name="shim"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB09">
                <!-- Cas particulier pas de concours bancaire individuels mais présence de concours collectif : il faut mettre le titre -->
                <!--<xsl:if test ="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB09">-->
                <table class="clBorderCell clWidth739" role="presentation">
                  <tr class="clAlignCenter">
                    <td class="clCouleur2 clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
                    <td class="clAlignRight clWidth104">&#160;</td>
                  </tr>
                  <tr class="clAlignCenter">
                    <td class="clCouleur2 clWidth635"> D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
                    <td class="clAlignRight clWidth104">&#160;</td>
                  </tr>
                </table>
                <xsl:call-template name="shim"/>
                <br/>
                <!--</xsl:if>-->
                <xsl:call-template name="ICB09"/>
                <xsl:call-template name="shim"/>
                <xsl:call-template name="CUMULCOAC"/>
              </xsl:when>
              <xsl:when test="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/ICB08">
                <xsl:call-template name="CUMULCOA"/>
                <xsl:call-template name="ICB08"/>
                <xsl:call-template name="shim"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="CUMULCOA"/>
                <xsl:call-template name="CUMULCOAC"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="DATCENTR">
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth200 clHeight12 clAlignLeft clThNonGras">&#160;DERNIÈRE CENTRALISATION AU</th>
        <td class="clFond clWidth182 clHeight12">
          <div class="clAlignRight">
            &#160;<xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(.)"/>
            </xsl:call-template>
          </div>
        </td>
        <td class="clCouleur2 clWidth253 clHeight12 clAlignCenter">
          <div class="clAlignRight">&#160;&#160;(en milliers d'euros)</div>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  
  <xsl:template match="CBEURO">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth400 clHeight12">&#160;PRESENCE DE CONCOURS BANCAIRES EUROPEENS </td>
        <td class="clCouleur2 clWidth235 clHeight12">
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clCouleur2 clWidth635">
          <br/>
          <div class="clAlignLeft">
            &#160;Pour obtenir le détail de l'endettement européen de cette entreprise, vous pouvez contacter le pôle "produits" &#160;du Service Central des Risques par mail : <a href="mailto:4072-produits-ut@banque-france.fr"/>4072-produits-ut@banque-france.fr
          </div>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
  <!-- ***************** Les messages diffusions des risques  *******************************************-->
  <xsl:template name="ICB01">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB01'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB03">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB03'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB04">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB04'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB05">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB05'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB06">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB06'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB07">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB07'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB08">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB08'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="ICB09">
    <table class="clBorderCell clWidth635" role="presentation">
      <tr>
        <td class="clCouleur2 clWidth635">
          <xsl:value-of select="($dictionnaire/mot[@id='ICB09'])"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
  <!-- ***************** Concours bancaires individuels ou collectifs *******************************************-->
  <!-- ***************** Concours bancaires individuels *******************************************-->
  <!--DÉTAILS DES CREDITS-->
  <xsl:template name="CUMULCB">
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">DÉTAILS DES CONCOURS INDIVIDUELS</caption>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS INDIVIDUELS</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCB/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCB/MTCODCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCB/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCB/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCB/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCB/MTCC"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="CUMULCB/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"/>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
      </tr>
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne*</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT COURT-->
  <xsl:template match="CUMULCB/MTCODCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>
      <tr class="clHeight30">
        <th class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight clThNonGras">
          Cptes ordinaires<br/>débiteurs<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CO',cstInforisques)">
            <u>
              (CO)
            </u>
          </a>
        </th>
        <td class="clWidth4"/>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CC',cstInforisques)">
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth5"/>
        <th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Affacturage<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AF',cstInforisques)">
            <u>
              (AF)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits à<br/>court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CA',cstInforisques)">
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"/>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"/>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCCCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTAFCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCODCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTAFCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT MOYEN ET LONG TERME-->
  <xsl:template match="CUMULCB/MTCMLT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10" colspan="9"/>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras" rowspan="2">
          Moyen
          <br/> et long terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETA',cstInforisques)">
            <u>
              (TE+TA)
            </u>
          </a>
          <br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th colspan="3" class="clCouleur2 clValignMiddle clAlignCenter clThNonGras" nowrap="true">Crédits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Titrisés<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('IT',cstInforisques)">
            <u>
              (IT)
            </u>
          </a>
          <br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers  <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BM',cstInforisques)">
            <u>
              (BM)
            </u>
          </a>
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BI',cstInforisques)">
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth158"/>
        <td class="clItalic clWidth104"/>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- CREDIT MOBILISABLE -->
  <xsl:template match="CUMULCB/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td colspan="5" class="clCouleur2 clHeight25 clWidth270 clAlignCenter clValignMiddle" nowrap="true">CREDITS MOBILISABLES </td>
        <td class="clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables <br/>
          [VIII]=[VI]+[VII]
        </th>
        <td rowspan="2" class="clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)">
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth93 clValignMiddle clAlignCenter clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          TITRES&#160;<br/>
          DE CREANCES<br/>
          NEGOCIABLES<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('IE',cstInforisques)" >
            <u>
              (IE)
            </u>
          </a>
        </th>
        <td class="clWidth114 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth94 clAlignRight clValignMiddle clThNonGras">
          Partie disponible<br/>des crédits<br/>mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)">
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"/>
        <th class="clCouleur2 clWidth80 clAlignRight clValignMiddle clThNonGras">
          Crédits<br/>documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)">
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clValignBottom clAlignCenter ">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth76 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
        <td class="clWidth4 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114 clAlignRight clBoxSizing"></td>
      </tr>
      <tr>
        <td class="clFond clWidth94 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth80 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth76 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth58 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTIE)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic clWidth114"/>
      </tr>
      <tr>
        <td class="clItalic clWidth94"/>
        <td class="clItalic clWidth10 clAlignCenter"/>
        <td class="clItalic clWidth80"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth76"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth93"/>
        <td class="clItalic clWidth114"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth94 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"/>
        <td class="clFond clWidth80 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth76 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth93 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCB/MTIE)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="12">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- ***************** Concours bancaires collectifs *******************************************-->
  <!--DÉTAILS DES CREDITS-->
  <xsl:template name="CUMULCBC">
    <div class="clBreakPage"/>
    <table class="clWidth635 clBorderCell">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          D&#201;TAILS DES PARTICIPATIONS EN COMPTE COLLECTIF
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCBC/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCBC/MTCODCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCBC/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCBC/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCBC/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCBC/MTCC"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="CUMULCBC/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"/>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
      </tr>
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne*</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT COURT-->
  <xsl:template match="CUMULCBC/MTCODCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>
      <tr class="clHeight30">
        <th class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight clThNonGras">
          Cptes ordinaires<br/>débiteurs<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CO',cstInforisques)">
            <u>
              (CO)
            </u>
          </a>
        </th>
        <td class="clWidth4"/>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CC',cstInforisques)">
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth5"/>
        <th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Affacturage<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AF',cstInforisques)">
            <u>
              (AF)
            </u>
          </a>
        </th>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits à<br/>court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CA',cstInforisques)">
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"/>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"/>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCCCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTAFCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCODCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTAFCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT MOYEN ET LONG TERME-->
  <xsl:template match="CUMULCBC/MTCMLT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10"
				    colspan="9"/>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras"
				   rowspan="2">
          Moyen
          <br/> et long terme<br/>
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('TETA',cstInforisques)">
            <u>
              (TE+TA)
            </u>
          </a>
          <br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
        </td>
        <th colspan="3"
				    class="clCouleur2 clValignMiddle clAlignCenter clThNonGras"
				    nowrap="true">Crédits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
        </td>
        <th rowspan="2"
				    class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Titrisés<br/>
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('IT',cstInforisques)">
            <u>
              (IT)
            </u>
          </a>
          <br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
        </td>
        <th rowspan="2"
				    class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras"
				    nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif"
						     width="18"
						     height="18"
						     border="0"
						     name="Image112"
						     alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
        </td>
        <th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BM',cstInforisques)">
            <u>
              (BM)
            </u>
          </a>
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart"
					   class="clTexte"
					   onclick="requestInfosRisques('BI',cstInforisques)">
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif"
					     width="1"
					     height="40"
					     vspace="0"
					     alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif"
					     width="1"
					     height="5"
					     vspace="0"
					     alt=""/>
        </td>
        <td class="clItalic clWidth158"/>
        <td class="clItalic clWidth104"/>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- CREDIT MOBILISABLE -->
  <xsl:template match="CUMULCBC/MTCC">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">CREDITS MOBILISABLES </th>
        <td class="clWidth4 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth94 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables <br/>
          [VIII]=[VI]+[VII]
        </th>
        <td rowspan="2" class="clWidth4 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth94 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)">
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth104 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth113 clAlignRight clValignMiddle clThNonGras">
          Partie disponible<br/>des crédits<br/>mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)">
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"/>
        <th class="clCouleur2 clWidth114 clAlignRight clValignMiddle clThNonGras">
          Crédits<br/>documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)">
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth5 clValignBottom clAlignCenter ">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>
        <td class="clWidth4 clValignBottom clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth104"/>
      </tr>
      <tr>
        <td class="clFond clWidth113 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth114 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth94 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clValignBottom clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth94 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic clWidth104"/>
      </tr>
      <tr>
        <td class="clItalic clWidth113"/>
        <td class="clItalic clWidth10 clAlignCenter"/>
        <td class="clItalic clWidth114"/>
        <td class="clItalic clWidth5 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth94"/>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth94"/>
        <td class="clItalic clWidth104"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth113 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"/>
        <td class="clFond clWidth114 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth94 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth94 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCBC/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth104"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-->
  <!-- *****************Concours déclarés par des intermédiaires en financement participatif *******************************************-->
  <xsl:template name="CUMULCIFP">
    <table class="clBorderCell clWidth739">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">CONCOURS DES INTERMEDIAIRES</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">EN FINANCEMENT PARTICIPATIF</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCIFP/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCIFP/MTCD"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="CUMULCIFP/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight5"/>
      </tr>
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne*</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <xsl:template match="CUMULCIFP/MTCD">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"/>
      </tr>
      <tr class="clHeight25">
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Durée &#60;= à 1 an
        </th>
        <td class="clWidth4"/>
        <td class="clCouleur2 clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth5"/>
        <th class="clCouleur2 clValignTop clWidth100 clAlignRight clThNonGras">
          Durée &#62; à 1 an
        </th>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <td class="clCouleur2 clValignTop clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="25" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total
        </th>
        <td class="clWidth106 clAlignRight"/>
      </tr>
      <tr class="clHeight5">
        <td class="clItalic" colspan="7"/>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"/>
      </tr>
      <tr class="clHeight15">
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTLD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCIFP/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCIFP/MTLD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCIFP/MTTOT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
  <!-- **************Concours déclarés par des sociétés de gestion de portefeuille et des entreprises d’assurance, mutuelles et institutions de prévoyance *******************************************-->
  <!-- ***************** Concours bancaires individuels *******************************************-->
  <!--DÉTAILS DES CREDITS-->
  <xsl:template name="CUMULCOA">
    <!-- titre du tableau -->
    <table class="clBorderCell clWidth739">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">CONCOURS D&#201;CLAR&#201;S PAR DES SOCI&#201;T&#201;S DE GESTION DE PORTEFEUILLE ET DES ENTREPRISES</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D'ASSURANCE, MUTUELLES ET INSTITUTIONS DE PR&#201;VOYANCE</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES CONCOURS INDIVIDUELS</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOA/MTCCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOA/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOA/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOA/MTCC"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="CUMULCOA/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"/>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
      </tr>
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne*</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT COURT-->
  <xsl:template match="CUMULCOA/MTCCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>
      <tr class="clHeight30">
        <td class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth4"/>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CCCD',cstInforisques)">
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth5"/>
        <td class="clCouleur2 clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits<br/>à court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CACD',cstInforisques)">
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"/>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"/>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">&#160;</td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT MOYEN ET LONG TERME-->
  <xsl:template match="CUMULCOA/MTCMLT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10" colspan="9"/>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras" rowspan="2">
          Moyen
          <br/> et long terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETACD',cstInforisques)">
            <u>
              (TE+TA)
            </u>
          </a>
          <br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th colspan="3" class="clCouleur2 clValignMiddle clAlignCenter clThNonGras" nowrap="true">Crédits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('ITCD',cstInforisques)">
            <u>
              (IT
            </u>
          </a>
          - Crédits<br/>Titrisés+
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CRCD',cstInforisques)">
            <u>
              CR
            </u>
          </a>
          <br/>- Crédits Repris)<br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BMCD',cstInforisques)">
            <u>
              (BM)
            </u>
          </a>
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BICD',cstInforisques)">
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth158"/>
        <td class="clItalic clWidth104"/>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOA/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- CREDIT MOBILISABLE -->
  <xsl:template match="CUMULCOA/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>

        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter"/>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth114"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOA/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
    <!-- ***************** Concours bancaires collectifs *******************************************-->
  <!--DÉTAILS DES CREDITS-->
  <xsl:template name="CUMULCOAC">
    <!-- titre du tableau -->
    <table class="clBorderCell clWidth739">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth635">D&#201;TAILS DES PARTICIPATIONS EN COMPTE COLLECTIF</td>
        <td class="clAlignRight clWidth104">&#160;</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOAC/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOAC/MTCCCT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOAC/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOAC/MTCMLT"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clBorderCell clWidth739">
      <tr>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOAC/@MOISREF"/>
        <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORISQUESAN/RISQUES/CUMULCOAC/MTCC"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell">
      <tr>
        <td class="clItalic">* Moyenne des crédits sur les 13 derniers mois</td>
      </tr>
    </table>
    <br/>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="CUMULCOAC/@MOISREF">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;45&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight20"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight25"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth65 clHeight45"/>
      </tr>
      <tr>
        <td class="clItalic clValignBottom clWidth65 clAlignCenter clHeight5"/>
      </tr>
      <tr>
        <td class="clFond clWidth65 clAlignRight clHeight15">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(.)"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clAlignRight clHeight15"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <th class="clFond clWidth65 clAlignRight clHeight15">
          <b>Moyenne*</b>
        </th>
      </tr>
      <tr>
        <td class="clItalic clWidth65 clHeight1">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT COURT-->
  <xsl:template match="CUMULCOAC/MTCCCT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight20 clWidth580 clAlignCenter clThNonGras" nowrap="true">CREDITS MOBILISES</th>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th colspan="9" class="clCouleur2 clValignTop clHeight25 clAlignCenter clThNonGras" nowrap="true">Court terme</th>
      </tr>
      <tr class="clHeight30">
        <td class="clCouleur2 clValignTop clHeight30 clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clWidth4"/>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Créances<br/>commerciales<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CCCD',cstInforisques)">
            <u>
              (CC)
            </u>
          </a>
        </th>
        <td class="clWidth5"/>
        <td class="clCouleur2 clValignTop clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clCouleur2 clWidth7">&#160;</td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Autres crédits<br/>à court terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CACD',cstInforisques)">
            <u>
              (CA)
            </u>
          </a>
        </th>
        <td class="clCouleur2b clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="45" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clValignTop clWidth110 clAlignRight clThNonGras">
          Total court terme <br/>[I]
        </th>
        <td class="clWidth106 clAlignRight"/>
      </tr>
      <tr>
        <td class="clItalic" colspan="7"/>
        <td class="clItalic clValignBottom clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic" colspan="2"/>
      </tr>
      <tr>
        <td class="clFond clWidth110 clAlignRight">&#160;</td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">&#160;</td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTACCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBCT)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5 clAlignRight">&#160;</td>
        <td class="clItalic clWidth100 clAlignRight">&#160;</td>
        <td class="clItalic clWidth7 clAlignRight">&#160;</td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clItalic clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth110 clAlignRight">&#160;</td>
        <td class="clWidth106"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth110 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth4 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTCCCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth100 clAlignRight">
          &#160;
        </td>
        <td class="clFond clWidth7 clAlignRight">&#160;</td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTACCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth12 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth110 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTCBCT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160; </td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!--CREDIT MOYEN ET LONG TERME-->
  <xsl:template match="CUMULCOAC/MTCMLT">
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <td class="clWidth580 clHeight10" colspan="9"/>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth103 clValignMiddle clAlignRight clThNonGras" rowspan="2">
          Moyen
          <br/> et long terme<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('TETACD',cstInforisques)">
            <u>
              (TE+TA)
            </u>
          </a>
          <br/>[II]
        </th>
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th colspan="3" class="clCouleur2 clValignMiddle clAlignCenter clThNonGras" nowrap="true">Crédits-bails </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2  clWidth74 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('ITCD',cstInforisques)">
            <u>
              (IT
            </u>
          </a>
          - Crédits<br/>Titrisés+
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('CRCD',cstInforisques)">
            <u>
              CR
            </u>
          </a>
          <br/>- Crédits Repris)<br/>[V]
        </th>
        <td class="clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth158 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total <br/>
          des crédits mobilisés [VI]<br/>[I]+[II]+[III]+[IV]+[V]
        </th>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr class="clHeight25">
        <td class="clWidth10 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth104 clValignMiddle clAlignRight clThNonGras">
          Mobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BMCD',cstInforisques)">
            <u>
              (BM)
            </u>
          </a>
          <br/>[III]
        </th>
        <td class="clCouleur2 clWidth5 clAlignRight">&#160;</td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Immobiliers
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('BICD',cstInforisques)">
            <u>
              (BI)
            </u>
          </a>
          <br/>[IV]
        </th>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td class="clWidth4 clAlignCenter">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="40" vspace="0" alt=""/>
        </td>
        <td>&#160;</td>
      </tr>
      <tr>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic"/>
        <td class="clItalic clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic"/>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="5" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth158"/>
        <td class="clItalic clWidth104"/>
      </tr>
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBM)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth5">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTCBI)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTITR)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <xsl:call-template name="displayNumberXsl">
            <xsl:with-param name="InputStringNumber" select="(../MTTOT6)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clItalic">&#160;</td>
      </tr>
      <tr>
        <td class="clItalic clWidth103 clAlignRight">&#160;</td>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth104 clAlignRight">&#160;</td>
        <td class="clItalic clWidth5">&#160;</td>
        <td class="clItalic clWidth108 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth74 clAlignRight">&#160;</td>
        <td class="clItalic clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clAlignRight">&#160;</td>
        <td/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth103 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTCMLT)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth104 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTCBM)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth5 clAlignRight">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTCBI)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth74 clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTTITR)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth4 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clAlignRight">
          <b>
            <xsl:call-template name="displayNumberXsl">
              <xsl:with-param name="InputStringNumber" select="(../../MOYCOAC/MTTOT6)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td/>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- CREDIT MOBILISABLE -->
  <xsl:template match="CUMULCOAC/MTCC">
    <!--<div class="clBreakPage"></div>-->
    <xsl:if test="position()=1">
      <xsl:text disable-output-escaping="yes">&lt;td width=&quot;739&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</xsl:text>
      <tr>
        <th colspan="5" class="clCouleur2 clHeight25 clWidth344 clAlignCenter clValignMiddle clThNonGras" nowrap="true">
          CREDITS MOBILISABLES
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="22" vspace="0" alt=""/>
        </td>
        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          Total<br/>
          crédits mobilisés<br/>
          et mobilisables<br/>
          [VIII]=[VI]+[VII]
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom" rowspan="2">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="91"  vspace="0" alt=""/>
        </td>

        <th rowspan="2" class="clCouleur2 clWidth108 clValignMiddle clAlignRight clThNonGras" nowrap="true">
          <a name="credit_eg"></a>
          ENGAGEMENTS<br/>
          DE GARANTIE<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('AC',cstInforisques)" >
            <u>
              (AC)
            </u>
          </a>
          <br/>
        </th>
        <td class="clWidth114 clAlignRight">&#160;</td>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Partie disponible des crédits mobilisables<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OC',cstInforisques)" >
            <u>
              (OC)
            </u>
          </a>
        </th>
        <td class="clWidth10"></td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">
          Crédits documentaires<br/>
          <a href="#nullepart" class="clTexte" onclick="requestInfosRisques('OD',cstInforisques)" >
            <u>
              (OD)
            </u>
          </a>
        </th>
        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70"  vspace="0" alt=""/>
        </td>
        <th class="clCouleur2 clWidth108 clAlignRight clValignMiddle clThNonGras">Total crédits mobilisables [VII]</th>


        <td class="clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}images/risque/shim_bleu.gif" width="1" height="70" vspace="0" alt=""/>
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(.)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10">&#160;</td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTCD)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT7)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTTOT8)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter clValignBottom">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <xsl:call-template name ="displayNumberXsl">
            <xsl:with-param name ="InputStringNumber" select ="(../MTAC)"/>
          </xsl:call-template>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter"/>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clItalic clWidth108"/>
        <td class="clItalic clWidth114"/>
      </tr>
    </xsl:if>
    <xsl:if test="position()=last()">
      <tr>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter"></td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTCD)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT7)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTTOT8)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clFond clWidth10 clAlignCenter">
          <img src="{$root}Images/risque/shim_bleu.gif" width="1" height="15" vspace="0" alt=""/>
        </td>
        <td class="clFond clWidth108 clAlignRight">
          <b>
            <xsl:call-template name ="displayNumberXsl">
              <xsl:with-param name ="InputStringNumber" select ="(../../MOYCOAC/MTAC)"/>
            </xsl:call-template>
          </b>&#160;
        </td>
        <td class="clWidth114"></td>
      </tr>
      <tr>
        <td class="clItalic clHeight1" colspan="10">&#160;</td>
      </tr>
      <xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
    </xsl:if>
  </xsl:template>
  <!-- *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* -->
  <!--********************************************************************************************************************************************************************-->
  <!--********************************************************************************************************************************************************************-->
  <!--**************************  RELATIONS BANCAIRES      ****************************************************-->
  <xsl:template match="INFORELBANC">
    <a name="ancRelbanc"/>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">
          LISTE DES RELATIONS BANCAIRES (<xsl:value-of select="NBRELBAN"/>)
        </td>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clBorderCell clWidth739">
      <caption class="visually-hidden">LISTE DES RELATIONS BANCAIRES</caption>
      <tr>
        <td class="clCouleur2 clWidth24 clAlignRight"/>
        <th class="clCouleur2 clWidth66 clAlignLeft clThNonGras">Banque</th>
        <th class="clCouleur2 clWidth79 clAlignLeft clThNonGras">Guichet</th>
        <th class="clCouleur2 clWidth304 clAlignLeft clThNonGras">Libellé de l'établissement bancaire </th>
        <th class="clCouleur2 clWidth162 clAlignCenter clThNonGras">Date de mise à jour</th>
        <td class="clWidth104"> &#160;</td>
      </tr>
      <xsl:apply-templates select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFORELBANC/RELBAN"/>
    </table>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="RELBAN">
    <xsl:if test="position() mod 2 != 0">
      <tr>
        <td class="clFond clWidth24">&#160;</td>
        <td class="clFond clWidth66">
          <xsl:value-of select="COBAN"/>
        </td>
        <td class="clFond clWidth79">
          <xsl:value-of select="COGUI"/>
        </td>
        <td class="clFond clWidth304">
          <xsl:value-of select="LIBBAN"/>
        </td>
        <td class="clFond clWidth162 clAlignCenter">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(DATMAJ)"/>
          </xsl:call-template>
        </td>
        <td class="clAlignRight">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position() mod 2 = 0">
      <tr>
        <td class="clTexte clWidth24 clAlignRight"/>
        <td class="clTexte clWidth66">
          <xsl:value-of select="COBAN"/>
        </td>
        <td class="clTexte clWidth79">
          <xsl:value-of select="COGUI"/>
        </td>
        <td class="clTexte clWidth304">
          <xsl:value-of select="LIBBAN"/>
        </td>
        <td class="clTexte clWidth162 clAlignCenter">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(DATMAJ)"/>
          </xsl:call-template>
        </td>
        <td class="clAlignRight">&#160;</td>
      </tr>
    </xsl:if>
    <xsl:if test="position() = last()">
      <xsl:if test="//INFORELBANC/SUITE">
        <tr>
          <td colspan="5">
            <table class="clWidth635 clBorderCell" role="presentation">
              <tr>
                <td class="clCouleur2 clWidth530 clHeight14" colspan="4"/>
                <td class="clWidth105 clHeight14 clValignMiddle clAlignRight">
                  <a href="#nullepart" onClick="requestBDFInfos('40','','1','{EJ/IDENTS}',cstSimpleConfirm);">
                    <img src="../images/Commun/clignotant2.gif" width="85" height="12" border="0" align="absbottom" alt="plus d'infos"/>
                  </a>
                </td>
              </tr>
            </table>
          </td>
          <td/>
        </tr>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <!--*********************************************************************************************************************-->
  <xsl:template match="INFOCOMPTABLESDETAIL">
    <a name="ancDonneesCompt"/>
    <div class="clBreakPage"/>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr>
        <td class="clWidth19"> </td>
        <td class="clCouleurGras clWidth597 clAlignCenter"> DONNÉES COMPTABLES</td>
        <td class="clWidth19">&#160;</td>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" name="Image112" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:apply-templates select="COMPTESSOCIAUX"/>
    <xsl:apply-templates select="COMPTESCONSO"/>
    <xsl:call-template name="shim"/>
  </xsl:template>
  <xsl:template match="COMPTESSOCIAUX">
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">COMPTES SOCIAUX</caption>
      <tr class="clAlignCenter">
        <td class="clCouleurGras"> COMPTES SOCIAUX</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras clBoxSizing">&#160;Documents comptables</th>
        <th class="clCouleur2 clAlignRight clThNonGras clBoxSizing" colspan="2">
          &#160;&#160;(exprimés en
          <xsl:call-template name="displayUnitXsl">
            <xsl:with-param name="InputUnit" select="(./@UNITE)"/>
          </xsl:call-template>
          euros)
        </th>
      </tr>
      <xsl:if test="SOC60/@REGFIS">
        <tr>
          <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras clBoxSizing">&#160;Régime fiscal</th>
          <td class="clFond clWidth300 clBoxSizing">
            &#160;<xsl:value-of select="SOC60/@REGFIS"/>
          </td>
          <td class="clFond clWidth185 clBoxSizing">&#160;</td>
        </tr>
        <tr>
          <td class="clWidth105 clHeight14 clBoxSizing"/>
          <td class="clWidth300 clHeight14 clBoxSizing"/>
          <td class="clWidth185 clHeight14 clBoxSizing"/>
        </tr>
      </xsl:if>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:apply-templates select="SOC60"/>
    <xsl:call-template name="SIG"/>
    <xsl:apply-templates select="SOC64"/>
  </xsl:template>
  <xsl:template match="SOC60">
    <!-- Date de clôture + Durée + Total du bilan  -->
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">COMPTES SOCIAUX</caption>
      <tr>
        <th class="clCouleur2 clHeight14  clAlignLeft clThNonGras clBoxSizing">&#160;Date de clôture</th>
        <xsl:apply-templates select="../SOC60/BILAN60AN/@DATCLOT" mode="m60"/>
      </tr>
      <tr>
        <th class="clCouleur2 clHeight14 clAlignLeft clThNonGras clBoxSizing">&#160;Durée</th>
        <xsl:apply-templates select="../SOC60/BILAN60AN/@DUREEEX" mode="m60"/>
      </tr>
      <tr>
        <td class="clHeight14 clBoxSizing" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clHeight14 clAlignLeft clThNonGras clBoxSizing">&#160;Total du bilan</th>
        <xsl:apply-templates select="./BILAN60AN/pK00035" mode="w120etendu">
          <xsl:with-param name="bold">Gras</xsl:with-param>
        </xsl:apply-templates>
      </tr>
    </table>
    <!-- ACTIF BRUT  -->
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">ACTIF BRUT DU DERNIER EXERCICE</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <xsl:apply-templates select="ACTIFBRUT"/>
    <xsl:call-template name="BILAN60AN"/>
  </xsl:template>
      
  <xsl:template match="ACTIFBRUT">
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Actif brut du dernier exercice</caption>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
      <td class="clGrasFond clAlignCenter" colspan="3">
        <xsl:call-template name ="displayDateXsl">
          <xsl:with-param name ="InputDate" select ="(../ACTIFBRUT/@DATCLOT)"/>
        </xsl:call-template>&#160;
      </td>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr class="clCouleur2 clHeight15"> 
			<th class="clWidth275 clAlignLeft clThNonGras">&#160;ACTIF</th>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Brut</div></th>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Amortissements/</div></th>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Net</div></th>
		</tr>
		<tr class="clCouleur2 clHeight15"> 
			<td class="clWidth395" colspan="2"></td>
			<th class="clWidth120"><div class="clAlignRight clThNonGras">Provisions</div></th>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Capital souscrit non appelé</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050AA" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/p2050AA" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Actif immobilisé</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BJ"  mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BK" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00001" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight2" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Immobilisations incorporelles</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00003" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00004" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00005" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Immobilisations corporelles</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00009" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00010" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00011" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Immobilisations financières</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00013" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00014" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00015" mode="w120seul"/>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Actif circulant</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00355"  mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/pK00055" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00021" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight2" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Dt Stocks</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00142" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/pK00358" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00026" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Avances et acomptes versés</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BV" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BW" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00027" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Clients</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BX" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BY" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00028" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres créances</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050BZ" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CA" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00030" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Valeurs mobilières de placement</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CD" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CE" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00032" mode="w120seul"/>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Disponibilités</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CF" mode="w120seul"/>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CG" mode="w120seul"/>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00033" mode="w120seul"/>
		</tr>
		<tr> 
			<td class="clCouleur2 clWidth275 clHeight15">&#160;</td>
			<td class="clFond clWidth120 clHeight15">&#160;</td>
			<td class="clFond clWidth120 clHeight15">&#160;</td>
			<td class="clFond clWidth120 clHeight15">&#160;</td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Autres postes</th>
			<xsl:apply-templates select="../ACTIFBRUT/pK00357" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CI" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00359" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
		<tr> 
			<td class="clHeight10" colspan="4"></td>
		</tr>
		<tr> 
			<th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Total</th>
			<xsl:apply-templates select="../ACTIFBRUT/p2050CO" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../ACTIFBRUT/p20501A" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="../BILAN60AN[position()=last()]/pK00035" mode="w120seul">
				<xsl:with-param name="bold">Gras</xsl:with-param>
			</xsl:apply-templates>
		</tr>
	</table>
</xsl:template>

 <xsl:template name="BILAN60AN">
  <xsl:call-template name="shim"/>
    <div class="clBreakPage"/>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras clWidth615">BILAN SYNTHÉTIQUE</td>
        <td class="clWidth19">&#160;</td>
        <td class="clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
	<table class="clWidth635 clBorderCell">
    <caption class="visually-hidden">Bilan synthétique</caption>
		<tr>
<!-- ****************************************************************************************************************************************************************************
			 table pour l'ACTIF
 *************************************************************************************************************************************************************************** -->
			<td class="clWidth307 clValignTop">
				<table class="clWidth307 clBorderCell">
          <caption class="visually-hidden">Bilan synthétique - partie actif</caption>
					 <tr>
              <th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
              <xsl:apply-templates select="BILAN60AN/@DATCLOT" mode="bilsyn"/>
            </tr>
					<tr>
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clAlignCenter clThNonGras">&#160;ACTIF</th>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Cap. sous. non appelé</th>
							<xsl:apply-templates select="BILAN60AN/p2050AA" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Actif immobilisé</th>
							<xsl:apply-templates select="BILAN60AN/pK00001" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;Immob. incorp.</th>
							<xsl:apply-templates select="BILAN60AN/pK00005" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;Immob. corporelles</th>
							<xsl:apply-templates select="BILAN60AN/pK00011" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;Immob. financières</th>
							<xsl:apply-templates select="BILAN60AN/pK00015" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Actif circulant</th>
							<xsl:apply-templates select="BILAN60AN/pK00021" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dt Stocks</th>
							<xsl:apply-templates select="BILAN60AN/pK00026" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Av. acptes versés</th>
							<xsl:apply-templates select="BILAN60AN/pK00027" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Clients</th>
							<xsl:apply-templates select="BILAN60AN/pK00028" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres créances</th>
							<xsl:apply-templates select="BILAN60AN/pK00030" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Valeurs mob. plact.</th>
							<xsl:apply-templates select="BILAN60AN/pK00032" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Disponibilités</th>
							<xsl:apply-templates select="BILAN60AN//pK00033" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Autres postes</th>
							<xsl:apply-templates select="BILAN60AN/pK00359" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Total</th>
							<xsl:apply-templates select="BILAN60AN/pK00035"  mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
				</table>
			</td>
		<!-- ****************************************************************************************************************************************************************************
		 	barre verticale de séparation ACTIF/PASSIF
		 *************************************************************************************************************************************************************************** -->
			<td class="clWidth21 clAlignCenter clValignBottom">
				<xsl:call-template name="svim" /><br />
			</td>		
		<!-- ****************************************************************************************************************************************************************************
			 table pour le PASSIF
			*************************************************************************************************************************************************************************** -->
			<td class="clWidth307 clValignTop">
				<table class="clWidth307 clBorderCell">
          <caption class="visually-hidden">Bilan synthétique - partie passif</caption>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
						<xsl:apply-templates select="BILAN60AN/@DATCLOT" mode="bilsyn"/>	
					</tr>
					<tr>
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clAlignCenter clThNonGras">&#160;PASSIF</th>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
						<td class="clWidth58"></td>
					</tr>
					<tr>
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Capitaux propres</th>
							<xsl:apply-templates select="BILAN60AN/p2051DL" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dt capital social</th>
							<xsl:apply-templates select="BILAN60AN/p2051DA" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Résult. exercice</th>
							<xsl:apply-templates select="BILAN60AN/p2051DI" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Provisions régl.</th>
							<xsl:apply-templates select="BILAN60AN/p2051DK" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Autres fonds propres</th>
							<xsl:apply-templates select="BILAN60AN/p2051DO" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Prov. risq. et charges</th>
							<xsl:apply-templates select="BILAN60AN/p2051DR" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dettes</th>
							<xsl:apply-templates select="BILAN60AN/pK00041" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight2" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Dt Dettes étab. crédit</th>
							<xsl:apply-templates select="BILAN60AN/p2051DU" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;CBC et s. créd.</th>
							<xsl:apply-templates select="BILAN60AN/p2051EH" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Autres dettes fin.</th>
							<xsl:apply-templates select="BILAN60AN/pK00360" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Av.acptes reçus</th>
							<xsl:apply-templates select="BILAN60AN/p2051DW" mode="w58etendu"/>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;Fournisseurs</th>
							<xsl:apply-templates select="BILAN60AN/p2051DX" mode="w58etendu"/>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Autres postes</th>
							<xsl:apply-templates select="BILAN60AN/pK00361" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
					<tr> 
						<td class="clHeight10" colspan="4"></td>
					</tr>
					<tr> 
						<th class="clCouleur2 clWidth133 clHeight14 clAlignLeft clThNonGras">&#160;Total</th>
							<xsl:apply-templates select="BILAN60AN/p2051EE" mode="w58etendu">
								<xsl:with-param name="bold">Gras</xsl:with-param>
							</xsl:apply-templates>
					</tr>
				</table>
			</td>
		</tr >
	</table>	
</xsl:template>
      
  <xsl:template match="@DATCLOT" mode="bilsyn">
    <td class="clGrasFond clWidth58 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template> &#160;
    </td>
    <xsl:if test="position()=last() and position()=2">
      <td class="clGrasFond clWidth58 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="pK00003|pK00004|pK00005|pK00009|pK00010|pK00011|pK00013|pK00014|pK00015|pK00142|pK00358|pK00026|p2050BV|p2050BW|pK00027|p2050BX|p2050BY|pK00028|p2050BZ|p2050CA|pK00030|p2050CD|p2050CE|pK00032|p2050CF|p2050CG|pK00033|p2051DA|p2051DI|p2051DK|p2051DU|p2051EH|pK00360|p2051DW|p2051DX|p2050CP|p2050CR|p2051EG|p2058YS|pK00048|pK00050|p2050AA|p2050BJ|p2050BK|pK00001|pK00355|pK00055|pK00021|pK00357|p2050CI|pK00359|p2050CO|p20501A|pK00035|p2051DL|p2051DO|p2051DR|pK00041|pK00361|p2051EE" mode="w120seul">
    <xsl:param name="bold"/>
    <td class="cl{$bold}Fond clWidth120 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
  </xsl:template>
  <xsl:template match="pK00003|pK00004|pK00005|pK00009|pK00010|pK00011|pK00013|pK00014|pK00015|pK00142|pK00358|pK00026|p2050BV|p2050BW|pK00027|p2050BX|p2050BY|pK00028|p2050BZ|p2050CA|pK00030|p2050CD|p2050CE|pK00032|p2050CF|p2050CG|pK00033|p2051DA|p2051DI|p2051DK|p2051DU|p2051EH|pK00360|p2051DW|p2051DX|p2050CP|p2050CR|p2051EG|p2058YS|pK00048|pK00050|p2050AA|p2050BJ|p2050BK|pK00001|pK00355|pK00055|pK00021|pK00357|p2050CI|pK00359|p2050CO|p20501A|pK00035|p2051DL|p2051DO|p2051DR|pK00041|pK00361|p2051EE" mode="w58etendu">
    <xsl:param name="bold"/>
    <td class="cl{$bold}Fond clWidth58 clAlignRight clBoxSizing">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="cl{$bold}Fond clWidth58 clAlignRight clBoxSizing">&#160;</td>
      <td class="cl{$bold}Fond clWidth58 clAlignRight clBoxSizing">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="cl{$bold}Fond clWidth58 clAlignRight clBoxSizing">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="p2050CP|p2050CR|p2051EG|p2058YS|pK00048|pK00050|pK00035" mode="w120etendu">
    <xsl:param name="bold"/>
    <td class="cl{$bold}Fond clWidth120 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
      <td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="cl{$bold}Fond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template name="svim">
    <xsl:element name="img">
      <xsl:attribute name="alt"/>
      <xsl:attribute name="width">1</xsl:attribute>
      <xsl:attribute name="height">303</xsl:attribute>
      <xsl:attribute name="vspace">8</xsl:attribute>
      <xsl:attribute name="src">
        <xsl:value-of select="$root"/>Images/risque/shim_bleu.gif
      </xsl:attribute>
    </xsl:element>
  </xsl:template>
  <xsl:template name="SIG">
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras">SOLDES INTERMÉDIAIRES DE GESTION</td>
        <td class="clWidth19">
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">SOLDES INTERMÉDIAIRES DE GESTION</caption>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Date de clôture</th>
        <xsl:apply-templates select="SIG/@DATCLOT" mode="sig"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Durée</th>
        <xsl:apply-templates select="SIG/@DUREEEX" mode="sig"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Chiffre d'affaires</th>
        <xsl:apply-templates select="SIG/p2052FL"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;Opérations de commission</th>
        <xsl:apply-templates select="SIG/pK00061"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight14 clAlignLeft clThNonGras">&#160;EFFECTIFS MOYENS</th>
        <xsl:apply-templates select="SIG/p2058YP"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Ventes de marchandises</th>
        <xsl:apply-templates select="SIG/p2052FC"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;- Coût d'achat des marchandises vendues</th>
        <xsl:apply-templates select="SIG/pK00062"/>
      </tr>
      <tr>
        <td class="clHeight2" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;= MARGE COMMERCIALE</th>
        <xsl:apply-templates select="SIG/pK00063" mode="Gras"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Marge commerciale</th>
        <xsl:apply-templates select="SIG/pK00063"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;+ Production de l'exercice</th>
        <xsl:apply-templates select="SIG/pK00065"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;- Consommation de l'exercice</th>
        <xsl:apply-templates select="SIG/pK00067"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;Dont Achats de matières prem. et approv.</th>
        <xsl:apply-templates select="SIG/p2052FU"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;Dont Redevances de crédit-bail</th>
        <xsl:apply-templates select="SIG/pK00052"/>
      </tr>
      <tr>
        <td class="clHeight2" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;= VALEUR AJOUTÉE</th>
        <xsl:apply-templates select="SIG/pK00068" mode="Gras"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Valeur ajoutée</th>
        <xsl:apply-templates select="SIG/pK00068"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  Charges de personnel</th>
        <xsl:apply-templates select="SIG/pK00073"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  Excédent brut d'exploitation</th>
        <xsl:apply-templates select="SIG/pK00075"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;Dont Dotations aux amort. et provisions</th>
        <xsl:apply-templates select="SIG/pK00077"/>
      </tr>
      <tr>
        <td class="clHeight2" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  RÉSULTAT D'EXPLOITATION</th>
        <xsl:apply-templates select="SIG/pK00078" mode="Gras"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Résultat d'exploitation</th>
        <xsl:apply-templates select="SIG/pK00078"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  Produits financiers</th>
        <xsl:apply-templates select="SIG/p2052GP"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  Charges financières</th>
        <xsl:apply-templates select="SIG/p2052GU"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;&#160;&#160;&#160;&#160;&#160;Dont int. et charges assimilées</th>
        <xsl:apply-templates select="SIG/p2052GR"/>
      </tr>
      <tr>
        <td class="clHeight2" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  RÉSULTAT COURANT AVANT IMPÔT</th>
        <xsl:apply-templates select="SIG/pK00083" mode="Gras"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Résultat courant avant impôt</th>
        <xsl:apply-templates select="SIG/pK00083"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  Résultat exceptionnel</th>
        <xsl:apply-templates select="SIG/pK00085"/>
      </tr>
      <tr>
        <td class="clHeight2" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;  RÉSULTAT DE L'EXERCICE</th>
        <xsl:apply-templates select="SIG/p2053HN" mode="Gras"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Capacité d'autofinancement</th>
        <xsl:apply-templates select="SIG/pK00218" mode="Gras"/>
      </tr>
      <tr>
        <td class="clHeight10" colspan="4"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth275 clHeight15 clAlignLeft clThNonGras">&#160;Autofinancement</th>
        <xsl:apply-templates select="SIG/pK00220" mode="Gras"/>
      </tr>
    </table>
    <xsl:if test="SOC64">
      <xsl:call-template name="shim"/>
    </xsl:if>
    <div class="clBreakPage"/>
  </xsl:template>
  <xsl:template match="p2052FL|pK00061|pK00061B|p2058YP|p2052FC|pK00062|pK00063|pK00065|pK00067|p2052FU|pK00052|pK00068|pK00073|pK00075|pK00077|pK00078|p2052GP|p2052GU|p2052GR|pK00083|pK00085">
    <td class="clFond clWidth120 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="pK00063|pK00068|pK00078|pK00083|p2053HN|pK00218|pK00220" mode="Gras">
    <td class="clGrasFond clWidth120 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DATCLOT" mode="sig">
    <td class="clGrasFond clWidth120 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DUREEEX" mode="sig">
    <td class="clFond clWidth120 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DATCLOT" mode="m60">
    <xsl:param name="width" select="120"/>
    <td class="clGrasFond clWidth120 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
      <td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clGrasFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DUREEEX" mode="m60">
    <xsl:param name="width" select="120"/>
    <td class="clFond clWidth120 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
    <xsl:if test="position()=last() and position()=2">
      <td class="clFond clWidth120 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="SOC64">
    <div class="clBreakPage"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clWidth19">&#160;</td>
        <td class="clCouleurGras clWidth597 clAlignCenter">PRINCIPAUX RATIOS INDIVIDUELS ET SECTORIELS AVANT RÉPARTITION</td>
        <td class="clWidth19">	</td>
      </tr>
    </table>
    <img src="{$root}Images/risque/shim_bleu.gif" width="635" height="1" vspace="8" alt=""/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">PRINCIPAUX RATIOS INDIVIDUELS ET SECTORIELS AVANT RÉPARTITION</caption>
      <tr>
        <td class="clCouleur2 clWidth266 clHeight16"/>
        <td class="clCouleur2 clWidth40 clHeight16 clAlignCenter">&#160;</td>
        <td class="clCouleur2 clWidth210 clHeight16 clAlignRight" colspan="2">ENTREPRISE&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</td>
        <td class="clCouleur2 clWidth5 clAlignCenter">&#160;</td>
        <td class="clCouleur2 clWidth105 clHeight16 clAlignRight">SECTEUR&#160;(2)</td>
      </tr>
      <tr>
        <td class="clWidth266 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth5">&#160;</td>
        <td class="clWidth105 clHeight10"/>
      </tr>
    </table>
    <xsl:call-template name="DONNEESINDIVIDUELLESAN"/>
  </xsl:template>
  <xsl:template name="DONNEESINDIVIDUELLESAN">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">&#160;Activité économique</th>
        <td class="clWidth40"/>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/CODNAF"/>
        <td class="clWidth5"/>
        <xsl:if test="DONNEESSECTORIELLES/INFOSECTORIELLES">
          <td class="clGrasFond clWidth106 clAlignRight">
            <xsl:value-of select="DONNEESSECTORIELLES/CODNAF"/>
          </td>
        </xsl:if>
        <xsl:if test="not(DONNEESSECTORIELLES/INFOSECTORIELLES)">
          <th class="clGrasFond clWidth106 clAlignRight clThNonGras">Indisponible </th>
        </xsl:if>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
        <td class="clWidth40"/>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/@DATCLOT" mode="m64"/>
        <td class="clWidth5"/>
        <xsl:if test="DONNEESSECTORIELLES/@DATSECT">
          <td class="clGrasFond clWidth106 clAlignRight">
            <xsl:call-template name="displayDateXsl">
              <xsl:with-param name="InputDate" select="(DONNEESSECTORIELLES/@DATSECT)"/>
            </xsl:call-template>
          </td>
        </xsl:if>
        <xsl:if test="not(DONNEESSECTORIELLES/INFOSECTORIELLES)">
          <td class="clFond clWidth106 clAlignRight">&#160;</td>
        </xsl:if>
      </tr>
    </table>
    <table class="clBorderCell clWidth739" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth269 clHeight14 clAlignCenter clValignMiddle clThNonGras">ACTIVITÉ</th>
        <td class="clWidth40"/>
        <td class="clWidth106"/>
        <td class="clWidth106"/>
        <td class="clWidth5"/>
        <td class="clWidth106"/>
        <td class="clWidth103 clAlignRight">
          <a href="#ancHaut">
            <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
          </a>
        </td>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth106 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clHeight14 clAlignLeft clThNonGras">&#160;Stocks / CA HT</th>
        <th class="clCouleur2 clWidth40 clHeight14 clAlignCenter clThNonGras">j</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00285|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00285"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clHeight14 clAlignLeft clThNonGras">
          &#160;Clients + Escompte
          (1) / CA TTC
        </th>
        <th class="clCouleur2 clWidth40 clHeight14 clAlignCenter clThNonGras">j</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00289|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00289"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft  clThNonGras">
          &#160;Fournisseurs /
          Achats TTC
        </th>
        <th class="clCouleur2 clWidth40 clHeight14 clAlignCenter clThNonGras">j</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00293|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00293"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          &#160;BFR d'exploitation (1) / CA
          HT
        </th>
        <th class="clCouleur2 clWidth40 clHeight14 clAlignCenter clThNonGras">j</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00295|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00295"/>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth106 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignCenter clValignMiddle clThNonGras">PRODUCTIVITÉ</th>
        <td class="clWidth40"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth5"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth106 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          &#160;Valeur ajoutée / CA
          HT&#160;
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00299|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00299"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          &#160;Charges de personnel / Valeur
          ajoutée&#160;
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00074|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00074"/>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth106 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clHeight14 clAlignCenter clThNonGras">RENTABILITÉ</th>
        <td class="clWidth40"/>
        <td class="clWidth106"/>
        <td class="clWidth106"/>
        <td class="clWidth5"/>
        <td class="clWidth106"/>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth106 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          &#160;Marge commerciale / Vente de
          marchandises&#160;
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00303|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00303"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">&#160;EBE / CA HT</th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00304|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00304"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          &#160;Intérêts et charges assimilées
          / EBE
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00307|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00307"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          &#160;Intérêts et charges assimilées
          / CA HT
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00308|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00308"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">&#160;Résultat net / CA HT</th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00365|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00365"/>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth106 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth106 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clHeight14 clAlignCenter clValignMiddle clThNonGras">STRUCTURE</th>
        <td class="clWidth40"/>
        <td class="clWidth105"/>
        <td class="clWidth105"/>
        <td class="clWidth5"/>
        <td class="clWidth105"/>
      </tr>
      <tr>
        <td class="clCouleur2 clWidth269 clHeight10 clAlignCenter clValignMiddle"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth105 clHeight10"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clHeight14 clAlignLeft clThNonGras">
          Fonds propres nets /
          Total du bilan&#160;
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00311|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00311"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          Dettes financ. stables / Fonds propres
          nets
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00317|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00317"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">
          Dettes financières stables
          / CAF
        </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras"> A.m</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00319|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00319"/>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth269 clAlignLeft clThNonGras">FRNG / BFR (1) </th>
        <th class="clCouleur2 clWidth40 clAlignCenter clThNonGras">%</th>
        <xsl:apply-templates select="DONNEESINDIVIDUELLESAN/pK00320|DONNEESSECTORIELLES/INFOSECTORIELLES/pK00320"/>
      </tr>
      <tr>
        <td class="clWidth269 clHeight10"/>
        <td class="clWidth40 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth105 clHeight10"/>
        <td class="clWidth5"/>
        <td class="clWidth105 clHeight10"/>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clItalic">(1) hors affacturage et Dailly non comptabilisés en effets escomptés non échus</td>
      </tr>
      <tr>
        <td class="clItalic">(2) année de centralisation des ratios sectoriels calculée du 1er juillet de l'année de référence au 30 juin de l'année suivante </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="CODNAF">
    <td class="clGrasFond clWidth105 clAlignRight">
      <xsl:value-of select="."/>&#160;
    </td>
    <xsl:if test="position()=1 and $isFirstAndLastDI">
      <td class="clGrasFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DATCLOT" mode="m64">
    <td class="clGrasFond clWidth105 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=1 and $isFirstAndLastDI">
      <td class="clGrasFond clWidth105 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="pK00285|pK00289|pK00293|pK00295|pK00299|pK00074|pK00303|pK00304|pK00307|pK00308|pK00365|pK00311|pK00317|pK00319|pK00320">
    <xsl:if test="(position()=last()) and $hasSectorielle">
      <td class="clWidth5"/>
    </xsl:if>
    <td class="clFond clWidth106 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=1 and $isFirstAndLastDI">
      <td class="clFond clWidth106 clAlignRight">&#160;</td>
    </xsl:if>
    <!--xsl:if test="(position()=last()) and not($hasSectorielle)">
			<td class="clWidth5"></td>
			<td class="clFond clWidth105 clAlignRight">&#160;</td>
	</xsl:if-->
  </xsl:template>
  <xsl:template match="@DATCLOT" mode="entete">
    <td class="clGrasFond clWidth165 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth165 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DUREEEX" mode="entete">
    <td class="clFond clWidth165 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth165 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="pK00061B">
    <td class="clFond clWidth165 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:value-of select="(.)"/>&#160;
      </xsl:if>
    </td>
    <xsl:if test="position()=last() and position()=1">
      <td class="clFond clWidth165 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <!--********************************************************************************************************************-->
  <xsl:template match="COMPTESCONSO">
    <xsl:apply-templates select="NOMGROUP"/>
    <xsl:apply-templates select="FILIALESPERI"/>
    <xsl:call-template name="BILCONSO"/>
  </xsl:template>
  <xsl:template match="NOMGROUP">
    <div class="clBreakPage"/>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr class="clAlignCenter">
        <td class="clCouleurGras">&#160;COMPTES CONSOLIDÉS</td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <caption class="visually-hidden">nom  du groupe</caption>
      <tr>
        <th class="clCouleur2 clWidth150 clAlignLeft clThNonGras">&#160;Nom du groupe</th>
        <td class="clFond clWidth300">
          &#160;<xsl:value-of select="../NOMGROUP"/>
        </td>
        <td class="clFond clWidth185 clHeight14"/>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
    <!-- Date de clôture + Durée  -->
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <th class="clCouleur2 clWidth355 clHeight14 clAlignLeft clThNonGras">&#160;Date de clôture</th>
        <xsl:apply-templates select="../CHIFFRESCONSO/@DATCLOT" mode="m66"/>
        <xsl:apply-templates select="../CHIFFRESCONSOIFRS/@DATCLOT" mode="m66"/>
      </tr>
      <tr>
        <th class="clCouleur2 clHeight14 clAlignLeft clThNonGras">&#160;Durée</th>
        <xsl:apply-templates select="../CHIFFRESCONSO/@DUREEEX" mode="m66"/>
        <xsl:apply-templates select="../CHIFFRESCONSOIFRS/@DUREEEX" mode="m66"/>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="FILIALESPERI">
    <xsl:call-template name="shim"/>
    <table class="clWidth635 clBorderCell">
      <tr>
        <th class="clCouleur2 clWidth235 clHeight15 clAlignLeft clThNonGras">&#160;Périmètre diffusé au</th>
        <td class="clFond clWidth60 clAlignCenter">
          <xsl:call-template name="displayDateXsl">
            <xsl:with-param name="InputDate" select="(DATPERI)"/>
          </xsl:call-template>
        </td>
        <td class="clWidth340 clHeight15" colspan="5"/>
      </tr>
      <tr>
        <td class="clWidth455 clHeight15" colspan="4"/>
        <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IG</th>
        <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">IP</th>
        <th class="clCouleur2 clWidth60 clHeight15 clAlignRight clThNonGras">ME</th>
      </tr>
      <tr>
        <th class="clCouleur2 clWidth235 clHeight15 clAlignLeft clThNonGras">&#160;Nombre de filiales consolidées</th>
        <td class="clFond clWidth60 clAlignRight">
          <xsl:value-of select="NBFILIALES/NBFILTOT"/>&#160;
        </td>
        <td class="clWidth60 clHeight15"/>
        <td class="clCouleur2 clWidth100 clHeight15 clThNonGras">&#160;réparties en</td>
        <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:value-of select="NBFILIALES/NBFILIG"/>
        </td>
        <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:value-of select="NBFILIALES/NBFILIP"/>
        </td>
        <td class="clFond clWidth60 clHeight15 clAlignRight">
          <xsl:value-of select="NBFILIALES/NBFILME"/>
        </td>
      </tr>
    </table>
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clItalic clHeight10"/>
      </tr>
      <tr>
        <td class="clItalic">&#160;IG : Filiale consolidée selon la méthode de l'intégration globale</td>
      </tr>
      <tr>
        <td class="clItalic">&#160;IP : Filiale consolidée selon la méthode de l'intégration proportionnelle</td>
      </tr>
      <tr>
        <td class="clItalic">&#160;ME : Filiale consolidée selon la méthode de la mise en équivalence</td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template name="BILCONSO">
    <xsl:if test="//CHIFFRESCONSO">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleur2 clAlignRight">
            &#160;&#160;(exprimés en
            <xsl:call-template name="displayUnitXsl">
              <xsl:with-param name="InputUnit" select="(../COMPTESCONSO/@UNITE)"/>
            </xsl:call-template>
            euros)
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clBorderCell clWidth739" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU BILAN</td>
          <td class="clWidth19">&#160;</td>
          <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">GRANDES MASSES DU BILAN</caption>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
          <xsl:apply-templates select="CHIFFRESCONSO/@DATCLOT" mode="m66"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif immobilisé net</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01143"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont écart d'acquisition</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01144"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif circulant net</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01151"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont disponibilités + VMP</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01411"/>
        </tr>
        <tr>
          <td class="clWidth355 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01171"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont intérêts minoritaires</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01167"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Fonds non remboursables</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01172"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Provisions pour risques et charges</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01174"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Dettes</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01177"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont dettes financières</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01178"/>
        </tr>
        <tr>
          <td class="clWidth355 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Total bilan</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01154"/>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU COMPTE DE RÉSULTAT</td>
          <td>

          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">GRANDES MASSES DU COMPTE DE RÉSULTAT</caption>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
          <xsl:apply-templates select="CHIFFRESCONSO/@DATCLOT" mode="m66"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Chiffre d'affaires</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pCACONS"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Pourcentage de chiffre d'affaires à l'étranger</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pEXPORT"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Excédent brut d'exploitation</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pEBE"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat d'exploitation</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRESEXPL"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat financier</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRESFIN"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat courant avant impôt</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRESCAI"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat exceptionnel</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRESEXCEP"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net consolidé av. amortissement écart d'acquisition</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRNCAAEA"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net consolidé</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRNC"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Dont part des minoritaires</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRNCPM"/>
        </tr>
        <tr>
          <td class="clWidth355 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Effectif du groupe</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pEFFECT"/>
        </tr>
      </table>
      <div class="clBreakPage"/>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth615 clAlignCenter">ÉLÉMENTS D'ANALYSE FINANCIÈRE</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">ÉLÉMENTS D'ANALYSE FINANCIÈRE</caption>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras" colspan="2">&#160;Date d'arrêté</th>
          <xsl:apply-templates select="CHIFFRESCONSO/@DATCLOT" mode="m66"/>
        </tr>
        <tr>
          <td class="clWidth325 clHeight10"/>
          <td class="clWidth30 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capacité d'autofinancement</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="../COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSO/pCAF"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;FRNG</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="../COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01376"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;BFR hors effets escomptés non échus</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="../COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01295"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Trésorerie</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="../COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01283"/>
        </tr>
        <tr>
          <td class="clWidth325 clHeight10"/>
          <td class="clWidth30 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Dettes financières stables / Fonds propres nets</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pDET_FP"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Concours bancaires courants / CA</th>
          <th class="clCouleur2 clAlignRight clThNonGras">j&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pCBC_CA"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;EBE / CA</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pEBE_CA"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net / CA</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRNC_CA"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net / Capitaux propres</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pRNC_CP"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres / Total Bilan</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSO/pK01888"/>
        </tr>
      </table>
    </xsl:if>
    <xsl:if test="//CHIFFRESCONSOIFRS">
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleur2 clAlignRight">
            &#160;&#160;(exprimés en
            <xsl:call-template name="displayUnitXsl">
              <xsl:with-param name="InputUnit" select="(/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/@UNITE)"/>
            </xsl:call-template>
            euros)
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clBorderCell clWidth739" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU BILAN</td>
          <td class="clWidth19">&#160;</td>
          <td class="clAlignRight">
            <a href="#ancHaut">
              <img src="{$root}Images/risque/fleche_haut.gif" width="18" height="18" border="0" alt="Retour en haut de la page"/>
            </a>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">GRANDES MASSES DU BILAN</caption>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Date d'arrêté</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/@DATCLOT" mode="m66"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif non courant</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02399"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont écarts d'acquisition totaux</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02618"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actif courant</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02403"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;Trésorerie et équivalents de trésorerie</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02402"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Actifs destinés à la vente</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2011EAR"/>
        </tr>
        <tr>
          <td class="clWidth355 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres totaux</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02411"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont intérêts minoritaires</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02410"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Passif non courant</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02419"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont dettes à long terme</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02418"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Passif courant</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02423"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont dettes financières CT</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02420"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Passifs destinés à la vente</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2018FBJ"/>
        </tr>
        <tr>
          <td class="clWidth355 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Total bilan</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2018FBK"/>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth615 clAlignCenter">GRANDES MASSES DU COMPTE DE RÉSULTAT</td>
          <td>

          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">GRANDES MASSES DU COMPTE DE RÉSULTAT</caption>
        <tr>
          <td class="clCouleur2 clWidth355 clHeight16">&#160;Date d'arrêté</td>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/@DATCLOT" mode="m66"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Chiffre d'affaires</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pCACONS"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Pourcentage de chiffre d'affaires à l'étranger</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pEXPORT"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat opérationnel courant</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pROC"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat opérationnel</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SAR"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Coût de l'endettement financier net</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SAS"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net des activités en cours</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SBI"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net consolidé</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pRNC"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont part du groupe</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/p2019SBL"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;&#160;dont part des minoritaires</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pRNCPM"/>
        </tr>
        <tr>
          <td class="clWidth355 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras">&#160;Effectif du groupe</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pEFFECT"/>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell" role="presentation">
        <tr>
          <td class="clCouleurGras clWidth615 clAlignCenter">ÉLÉMENTS D'ANALYSE FINANCIÈRE</td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">ÉLÉMENTS D'ANALYSE FINANCIÈRE</caption>
        <tr>
          <th class="clCouleur2 clWidth355 clHeight16 clAlignLeft clThNonGras" colspan="2">&#160;Date d'arrêté</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/@DATCLOT" mode="m66"/>
        </tr>
        <tr>
          <td class="clWidth325 clHeight10"/>
          <td class="clWidth30 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capacité d'autofinancement</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02579"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;FRNG</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02494"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;BFR</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02495"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;(ACTIFS-DETTES) DESTINÉS À LA VENTE</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02614"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Trésorerie</th>
          <td class="clCouleur2">
            <div class="clAlignRight">
              <xsl:value-of select="/FIBEN/PERSONNE/MODULEAN/DIFFAN/INFOCOMPTABLESDETAIL/COMPTESCONSO/@UNITE"/>
              <img src="{$root}Images/risque/euro_symb_bleu.gif" width="8" height="9" border="0"/>&#160;
            </div>
          </td>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02496"/>
        </tr>
        <tr>
          <td class="clWidth325 clHeight10"/>
          <td class="clWidth30 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
          <td class="clWidth140 clHeight10"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Dettes financières à + d'un an / Capitaux propres</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02606"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Concours bancaires courants / CA</th>
          <th class="clCouleur2 clAlignRight clThNonGras">j&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pCBC_CA"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Résultat opérationnel courant / CA HT</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pROC_CA"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Résultat opérationnel / CA HT</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02685"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net des activités en cours / CA HT</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02705"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Résultat net / Capitaux propres</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pRNC_CP"/>
        </tr>
        <tr>
          <th class="clCouleur2 clWidth325 clHeight16 clAlignLeft clThNonGras">&#160;Capitaux propres / Total Bilan</th>
          <th class="clCouleur2 clAlignRight clThNonGras">%&#160;	</th>
          <xsl:apply-templates select="CHIFFRESCONSOIFRS/pK02615"/>
        </tr>
      </table>
    </xsl:if>
    <!--xsl:call-template name="shim"/><br /-->
  </xsl:template>
  <xsl:template match="@DATCLOT" mode="m66">
    <td class="clGrasFond clWidth140 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="$isOnlyOneCC">
      <td class="clGrasFond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="@DUREEEX" mode="m66">
    <td class="clFond clWidth140 clAlignRight">
      <xsl:call-template name="displayDateXsl">
        <xsl:with-param name="InputDate" select="(.)"/>
      </xsl:call-template>&#160;
    </td>
    <xsl:if test="$isOnlyOneCC">
      <td class="clFond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="pCACONS|pEXPORT|pEBE|pRESEXPL|pRESFIN|pRESCAI|pRESEXCEP|pRNCAAEA|pRNC|pRNCPM|pEFFECT|pK01143|pK01144|pK01151|pK01411|pK01171|pK01167|pK01172|pK01174|pK01177|pK01178|pK01154|pCAF|pK01376|pK01295|pK01283|pDET_FP|pCBC_CA|pEBE_CA|pRNC_CA|pRNC_CP|pK01888|pROC_CA">
    <td class="clFond clWidth140 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="$isOnlyOneCC">
      <td class="clFond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <xsl:template match="pROC|p2019SAR|p2019SAS|p2019SBI|pRNC|p2019SBL|pRNCPM|pEFFECT|pK02399|pK02618|pK02403|pK02402|p2011EAR|pK02411|pK02410|pK02419|pK02418|pK02423|pK02420|p2018FBJ|p2018FBK|pK02579|pK02494|pK02495|pK02614|pK02496|pK02606|pCBC_CA|pK02685|pK02705|pRNC_CP|pK02615|pROC_CA">
    <td class="clFond clWidth140 clAlignRight">
      <xsl:if test="@ETAT">
        <xsl:value-of select="@ETAT"/>&#160;
      </xsl:if>
      <xsl:if test="not(@ETAT)">
        <xsl:call-template name="displayNumberXsl">
          <xsl:with-param name="InputStringNumber" select="(.)"/>
        </xsl:call-template>&#160;
      </xsl:if>
    </td>
    <xsl:if test="$isOnlyOneCC">
      <td class="clFond clWidth140 clAlignRight">&#160;</td>
    </xsl:if>
  </xsl:template>
  <!--*****************************************************************************************************************-->
  <!--TEMPLATE 5eme PAVE : SOCIETE CONSOLIDANTE-->
  <xsl:template match="DIFFAN/EJ">
    <!--<div class="clBreakPage"></div>-->
    <a name="SteConso"/>
    <xsl:if test="position()=last()">
      <table class="clBorderCell clWidth739" role="presentation">
        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_SoCoEn'"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">SOCIÉTÉ(S) CONSOLIDANT L'ENTREPRISE</caption>
        <xsl:for-each select="../EJ">
          <tr>
            <td class="clFond clWidth130">
              &#160;<xsl:call-template name="displaySirenXsl">
                <xsl:with-param name="InputSiren" select="(IDENTS)"/>
              </xsl:call-template>
            </td>
            <td class="clFond clWidth425">
              &#160;<xsl:value-of select="DENOM"/>
            </td>
            <td class="clFond clWidth80 clAlignRight">
              &#160;	<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Au'"/>
              </xsl:call-template>&#160;
              <xsl:call-template name="displayDateXsl">
                <xsl:with-param name="InputDate" select="(@DATPERI)"/>
              </xsl:call-template>
            </td>
          </tr>
          <xsl:if test="not($NonResident='NR')">
            <tr>
              <td class="clWidth635 clAlignRight" colspan="3">
                <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
                  <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
                </a>
              </td>
            </tr>
          </xsl:if>
        </xsl:for-each>
      </table>
      <xsl:call-template name="shim"/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="IST/EJ">
    <xsl:if test="position()=last()">
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clBorderCell clWidth739" role="presentation">
        <tr class="clAlignCenter">
          <td class="clCouleurGras">
            <xsl:call-template name="tradlib">
              <xsl:with-param name="Lang" select="$Lang"/>
              <xsl:with-param name="codeLib" select="'m27_SoCoEn'"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>
      <xsl:call-template name="shim"/>
      <br/>
      <table class="clWidth635 clBorderCell">
        <caption class="visually-hidden">SOCIÉTÉ(S) CONSOLIDANT L'ENTREPRISE</caption>
        <xsl:for-each select="../EJ">
          <tr>
            <td class="clFond clWidth130">
              &#160;<xsl:call-template name="displaySirenXsl">
                <xsl:with-param name="InputSiren" select="(IDENTS)"/>
              </xsl:call-template>
            </td>
            <td class="clFond clWidth425">
              &#160;<xsl:value-of select="DENOM"/>
            </td>
            <td class="clFond clWidth80 clAlignRight">
              &#160;	<xsl:call-template name="tradlib">
                <xsl:with-param name="Lang" select="$Lang"/>
                <xsl:with-param name="codeLib" select="'m27_Au'"/>
              </xsl:call-template>&#160;
              <xsl:call-template name="displayDateXsl">
                <xsl:with-param name="InputDate" select="(@DATPERI)"/>
              </xsl:call-template>
            </td>
          </tr>
          <tr>
            <td class="clWidth635 clAlignRight" colspan="3">
              <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{IDENTS}',cstMultipleConfirm);">
                <img border="0" height="12" src="{$root}images/Commun/clignotant2.gif" width="90" alt="plus d'infos"/>
              </a>
            </td>
          </tr>
        </xsl:for-each>
      </table>
    </xsl:if>
  </xsl:template>
  <xsl:template match="STECONSO" mode="genLib">
    <table class="clWidth635 clBorderCell" role="presentation">
      <tr>
        <td class="clCouleur2" colspan="2">
          &#160;<xsl:apply-templates select="."/>
        </td>
      </tr>
      <tr>
        <td class="clWidth130"/>
        <td class="clWidth505 clAlignRight">
          <a href="#nullepart" onClick="requestBDFInfos('27|30|66|67|','','1','{/FIBEN/PERSONNE/MODULE60/EJ/IDENTS}',cstMultipleConfirm);">
            <img src="{$root}Images/Commun/clignotant2.gif" width="90" height="12" alt="Plus d'infos" border="0"/>
          </a>
        </td>
      </tr>
    </table>
    <xsl:call-template name="shim"/>
    <br/>
  </xsl:template>
  <xsl:template match="BIL02[@ISCODE='1']">
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clHeight125 clBorderCell" role="presentation">
      <tr>
        <td>
          <xsl:call-template name="traduction">
            <xsl:with-param name="code" select="'BIL02'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="BIL01S[@ISCODE='1']">
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clHeight125 clBorderCell" role="presentation">
      <tr>
        <td>
          <xsl:call-template name="traduction">
            <xsl:with-param name="code" select="'BIL01S'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="BIL01C[@ISCODE='1']">
    <xsl:call-template name="shim"/>
    <br/>
    <table class="clWidth635 clHeight125 clBorderCell" role="presentation">
      <tr>
        <td>
          <xsl:call-template name="traduction">
            <xsl:with-param name="code" select="'BIL01C'"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>
  <!--**************************************************************************************************************-->
  <!-- 01/2004 template supprimé : plus besoin d'afficher la succursale dans IEC01 -->
  <xsl:template match="IEC01" mode="DisplayM27">
    <br/>
    <xsl:apply-templates select="."/>
  </xsl:template>
</xsl:stylesheet>
